/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.HorizontalAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;

public class HorizontalAxesAdjuster
implements IAxisAdjuster {
    private OneAxis[] fHorizontalAxes;
    private OneAxis fVerticalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;

    public HorizontalAxesAdjuster(OneAxis[] horizontalAxes, OneAxis verticalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fHorizontalAxes = horizontalAxes;
        this.fVerticalAxis = verticalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    public void adjust() throws ChartException {
        double iXTitleLocation;
        double deltaY2;
        AutoScale scY = this.fVerticalAxis.getScale();
        boolean isForward = scY.getDirection() == 1;
        ArrayList<HorizontalAxisAdjuster> values = new ArrayList<HorizontalAxisAdjuster>();
        ArrayList<HorizontalAxisAdjuster> min = new ArrayList<HorizontalAxisAdjuster>();
        ArrayList<HorizontalAxisAdjuster> max = new ArrayList<HorizontalAxisAdjuster>();
        OneAxis[] oneAxisArray = this.fHorizontalAxes;
        int n = this.fHorizontalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis oa = oneAxisArray[n2];
            HorizontalAxisAdjuster vaa = new HorizontalAxisAdjuster(oa, this.fVerticalAxis, this.fPlotWithAxes, this.fPlotBounds);
            int iv = oa.getIntersectionValue().getType();
            switch (iv) {
                case 2: {
                    min.add(vaa);
                    break;
                }
                case 1: {
                    max.add(vaa);
                    break;
                }
                default: {
                    values.add(vaa);
                }
            }
            ++n2;
        }
        double y = Double.NaN;
        double bottom = Double.NaN;
        double top = Double.NaN;
        double[] endPoints = this.fVerticalAxis.getScale().getEndPoints();
        this.fVerticalAxis.getScale().resetShifts();
        int i = 0;
        while (i < values.size()) {
            ((HorizontalAxisAdjuster)values.get(i)).adjust();
            double locationDelta = Math.abs(AxesAdjuster.getLocationDelta(this.fVerticalAxis.getScale(), ((HorizontalAxisAdjuster)values.get(i)).getHorizontalAxis().getIntersectionValue()));
            if (Double.isNaN(y)) {
                y = ((HorizontalAxisAdjuster)values.get(i)).getAxisY();
                if (!isForward) {
                    bottom = ((HorizontalAxisAdjuster)values.get(i)).getAxisBottomEdge();
                    if ((y += locationDelta) > bottom) {
                        bottom = y;
                    }
                    top = y;
                } else {
                    bottom = y -= locationDelta;
                    top = ((HorizontalAxisAdjuster)values.get(i)).getAxisTopEdge();
                    if (y < top) {
                        top = y;
                    }
                }
            } else {
                double deltaY1 = bottom - y;
                double deltaY22 = y - top;
                double newY = ((HorizontalAxisAdjuster)values.get(i)).getAxisY();
                newY = !isForward ? (newY += locationDelta) : (newY -= locationDelta);
                if (!isForward) {
                    if (newY < y) {
                        y = newY;
                    }
                    bottom = y + Math.max(deltaY1, ((HorizontalAxisAdjuster)values.get(i)).getAxisBottomEdge() - y);
                    top = y;
                } else {
                    if (newY > y) {
                        y = newY;
                    }
                    bottom = y;
                    top = y - Math.max(deltaY22, y - ((HorizontalAxisAdjuster)values.get(i)).getAxisTopEdge());
                }
            }
            scY.setEndPoints(endPoints[0], endPoints[1]);
            ++i;
        }
        scY.setEndPoints(endPoints[0], endPoints[1]);
        scY.resetShifts();
        i = 0;
        while (i < min.size()) {
            ((HorizontalAxisAdjuster)min.get(i)).adjust();
            if (Double.isNaN(y)) {
                y = ((HorizontalAxisAdjuster)min.get(i)).getAxisY();
                bottom = ((HorizontalAxisAdjuster)min.get(i)).getAxisBottomEdge();
                top = ((HorizontalAxisAdjuster)min.get(i)).getAxisTopEdge();
            } else {
                double deltaY1 = bottom - y;
                deltaY2 = y - top;
                if (((HorizontalAxisAdjuster)min.get(i)).getAxisY() < y) {
                    y = ((HorizontalAxisAdjuster)min.get(i)).getAxisY();
                }
                bottom = y + Math.max(deltaY1, ((HorizontalAxisAdjuster)min.get(i)).getAxisBottomEdge() - ((HorizontalAxisAdjuster)min.get(i)).getAxisY());
                top = y - Math.max(deltaY2, ((HorizontalAxisAdjuster)min.get(i)).getAxisY() - ((HorizontalAxisAdjuster)min.get(i)).getAxisTopEdge());
            }
            scY.setEndPoints(endPoints[0], endPoints[1]);
            ++i;
        }
        scY.setEndPoints(endPoints[0], endPoints[1]);
        if (!Double.isNaN(y)) {
            double[] positions = this.adjustOrthogonalAxis(2, this.fVerticalAxis, y, bottom, top);
            y = positions[0];
            top = positions[1];
            bottom = positions[2];
        }
        i = 0;
        while (i < values.size()) {
            OneAxis oa = ((HorizontalAxisAdjuster)values.get(i)).getHorizontalAxis();
            iXTitleLocation = oa.getTitlePosition();
            double axisCoordinate = 0.0;
            double locationDelta = Math.abs(AxesAdjuster.getLocationDelta(this.fVerticalAxis.getScale(), ((HorizontalAxisAdjuster)values.get(i)).getHorizontalAxis().getIntersectionValue()));
            if (!isForward) {
                axisCoordinate = scY.getEndPoints()[0];
                axisCoordinate -= locationDelta;
            } else {
                axisCoordinate = scY.getEndPoints()[1];
                axisCoordinate += locationDelta;
            }
            double axisTitleCoordinate = iXTitleLocation == 8.0 ? bottom - 1.0 - locationDelta - ((HorizontalAxisAdjuster)values.get(i)).getAxisTitleThickness() : axisCoordinate - ((HorizontalAxisAdjuster)values.get(i)).getAxisTitleThickness() + 1.0 - (oa.getLabelPosition() == 8 ? 0.0 : ((HorizontalAxisAdjuster)values.get(i)).getAxisLabelThickness());
            oa.setAxisCoordinate(axisCoordinate);
            oa.setTitleCoordinate(axisTitleCoordinate);
            ++i;
        }
        i = 0;
        while (i < min.size()) {
            OneAxis oa;
            iXTitleLocation = (oa = ((HorizontalAxisAdjuster)min.get(i)).getHorizontalAxis()).getTitlePosition();
            oa.setTitleCoordinate(iXTitleLocation == 8.0 ? bottom - 1.0 - ((HorizontalAxisAdjuster)min.get(i)).getAxisTitleThickness() : top + 1.0);
            oa.setAxisCoordinate(y);
            ++i;
        }
        y = Double.NaN;
        bottom = Double.NaN;
        top = Double.NaN;
        endPoints = scY.getEndPoints();
        scY.resetShifts();
        i = 0;
        while (i < max.size()) {
            ((HorizontalAxisAdjuster)max.get(i)).adjust();
            if (Double.isNaN(y)) {
                y = ((HorizontalAxisAdjuster)max.get(i)).getAxisY();
                bottom = ((HorizontalAxisAdjuster)max.get(i)).getAxisBottomEdge();
                top = ((HorizontalAxisAdjuster)max.get(i)).getAxisTopEdge();
            } else {
                double deltaY1 = bottom - y;
                deltaY2 = y - top;
                if (((HorizontalAxisAdjuster)max.get(i)).getAxisY() > y) {
                    y = ((HorizontalAxisAdjuster)max.get(i)).getAxisY();
                    bottom = y + Math.max(deltaY1, ((HorizontalAxisAdjuster)max.get(i)).getAxisBottomEdge() - y);
                    top = y - Math.max(deltaY2, y - ((HorizontalAxisAdjuster)max.get(i)).getAxisTopEdge());
                }
            }
            scY.setEndPoints(endPoints[0], endPoints[1]);
            ++i;
        }
        if (!Double.isNaN(y)) {
            scY.setEndPoints(endPoints[0], endPoints[1]);
            double[] positions = this.adjustOrthogonalAxis(1, this.fVerticalAxis, y, bottom, top);
            y = positions[0];
            top = positions[1];
            bottom = positions[2];
        }
        i = 0;
        while (i < max.size()) {
            OneAxis oa;
            iXTitleLocation = (oa = ((HorizontalAxisAdjuster)max.get(i)).getHorizontalAxis()).getTitlePosition();
            oa.setTitleCoordinate(iXTitleLocation == 8.0 ? bottom - 1.0 - ((HorizontalAxisAdjuster)max.get(i)).getAxisTitleThickness() : top + 1.0);
            oa.setAxisCoordinate(y);
            ++i;
        }
        scY.computeTicks(this.fPlotWithAxes.getDisplayServer(), this.fVerticalAxis.getLabel(), this.fVerticalAxis.getLabelPosition(), 1, scY.getStart(), scY.getEnd(), false, this.fPlotWithAxes.getAxes());
        scY.resetShifts();
    }

    public double[] adjustOrthogonalAxis(int iv, OneAxis orthogonalAxis, double dY, double dBottom, double dTop) throws ChartException {
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        AutoScale scY = orthogonalAxis.getScale();
        AllAxes aax = this.fPlotWithAxes.getAxes();
        Label laYAxisLabels = orthogonalAxis.getLabel();
        int iYLabelLocation = orthogonalAxis.getLabelPosition();
        boolean bForwardScale = scY.getDirection() == 1;
        double dXAxisThickness = dBottom - dTop;
        double dDeltaY1 = dY - dTop;
        double dDeltaY2 = dBottom - dY;
        boolean startEndChanged = false;
        if (bForwardScale && iv == 2 || !bForwardScale && iv == 1) {
            if (bForwardScale && dXAxisThickness > scY.getStartShift() || !bForwardScale && dXAxisThickness > scY.getEndShift()) {
                double dStart = scY.getStart();
                double dEnd = dBottom - scY.getEndShift();
                if (bForwardScale) {
                    dStart = dBottom - scY.getStartShift();
                    dEnd = scY.getEnd();
                }
                scY.resetShifts();
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(ids, laYAxisLabels, iYLabelLocation)) {
                        if (!scY.zoomOut()) break;
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, aax);
                        if (scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
            }
            dTop = (dY -= this.fPlotWithAxes.getPlotInsets().getTop()) - dDeltaY1;
            dBottom = dY + dDeltaY2;
        } else if (bForwardScale && iv == 1 || !bForwardScale && iv == 2) {
            if (bForwardScale && dXAxisThickness > scY.getEndShift() || !bForwardScale && dXAxisThickness > scY.getStartShift()) {
                double dStart = dTop + scY.getStartShift();
                double dEnd = scY.getEnd();
                if (bForwardScale) {
                    dStart = scY.getStart();
                    dEnd = dTop + scY.getEndShift();
                }
                scY.resetShifts();
                if (dStart < dEnd + 1.0) {
                    dStart = dEnd + 1.0;
                    startEndChanged = true;
                }
                scY.setEndPoints(dStart, dEnd);
                scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, false, aax);
                if (!scY.isStepFixed()) {
                    Object[] oaMinMax = scY.getMinMax();
                    while (!scY.checkFit(ids, laYAxisLabels, iYLabelLocation)) {
                        if (!scY.zoomOut()) break;
                        double dOldStep = ((Number)scY.getStep()).doubleValue();
                        scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scY.computeTicks(ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, startEndChanged, false, aax);
                        double dNewStep = ((Number)scY.getStep()).doubleValue();
                        if (dNewStep < dOldStep || scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                    }
                }
            }
            dTop = (dY += this.fPlotWithAxes.getPlotInsets().getBottom()) - dDeltaY1;
            dBottom = dY + dDeltaY2;
        }
        return new double[]{dY, dTop, dBottom};
    }
}

