/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.content.wrap;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.internal.content.wrap.AbstractContentWrapper;
import org.eclipse.birt.report.engine.internal.content.wrap.TableBandContentWrapper;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.util.ContentUtil;

public class TableContentWrapper
extends AbstractContentWrapper
implements ITableContent {
    protected ITableContent tableContent;
    protected TableBandContentWrapper footer;
    protected TableBandContentWrapper body;
    protected TableBandContentWrapper header;
    private List columns;
    private Boolean hasHorzPageBreak;

    public TableContentWrapper(ITableContent content, List columns) {
        super(content);
        this.tableContent = content;
        this.columns = columns;
    }

    public TableContentWrapper(TableContentWrapper content) {
        super(content);
        this.tableContent = content;
        this.columns = content.columns;
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitTable(this, value);
    }

    public void addColumn(IColumn column) {
        this.tableContent.addColumn(column);
    }

    public String getCaption() {
        return this.tableContent.getCaption();
    }

    public IColumn getColumn(int index) {
        return (IColumn)this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ITableBandContent getFooter() {
        if (this.footer == null) {
            this.footer = new TableBandContentWrapper(this.tableContent.getFooter());
        }
        return this.footer;
    }

    public ITableBandContent getHeader() {
        if (this.header == null) {
            this.header = new TableBandContentWrapper(this.tableContent.getHeader());
        }
        return this.header;
    }

    public boolean isHeaderRepeat() {
        return this.tableContent.isHeaderRepeat();
    }

    public String getCaptionKey() {
        return this.tableContent.getCaptionKey();
    }

    public void setCaption(String caption) {
        this.tableContent.setCaption(caption);
    }

    public void setCaptionKey(String key) {
        this.tableContent.setCaptionKey(key);
    }

    public void setHeaderRepeat(boolean repeat) {
        this.tableContent.setHeaderRepeat(repeat);
    }

    public List getColumns() {
        return this.tableContent.getColumns();
    }

    public DimensionType getWidth() {
        if (this.getColumnCount() != this.tableContent.getColumnCount()) {
            if (this.hasHorzPageBreak == null) {
                this.hasHorzPageBreak = ContentUtil.hasHorzPageBreak(this.tableContent);
            }
            if (Boolean.TRUE == this.hasHorzPageBreak) {
                return null;
            }
        }
        return this.tableContent.getWidth();
    }

    public String getSummary() {
        return this.tableContent.getSummary();
    }

    public void setSummary(String summary) {
        this.tableContent.setSummary(summary);
    }

    public IContent cloneContent(boolean isDeep) {
        if (isDeep) {
            throw new UnsupportedOperationException();
        }
        return new TableContentWrapper(this);
    }
}

