/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;

public class NativeRowObject
implements Scriptable {
    ExecutionContext context;
    Scriptable prototype;
    Scriptable parent;
    IQueryResultSet rset;
    static final String JS_CLASS_NAME = "DataSetRow";

    public String getClassName() {
        return JS_CLASS_NAME;
    }

    public NativeRowObject() {
    }

    public NativeRowObject(Scriptable parent, ExecutionContext context) {
        this.setParentScope(parent);
        this.context = context;
    }

    public NativeRowObject(Scriptable parent, IQueryResultSet rset) {
        this.setParentScope(parent);
        this.rset = rset;
    }

    protected IQueryResultSet getResultSet() {
        IBaseResultSet ctxRset;
        if (this.rset == null && (ctxRset = this.context.getResultSet()) != null && ctxRset.getType() == 0) {
            return (IQueryResultSet)ctxRset;
        }
        return this.rset;
    }

    public Object get(String name, Scriptable start) {
        IQueryResultSet rset = this.getResultSet();
        if (rset == null) {
            return null;
        }
        if ("_outer".equals(name)) {
            IBaseResultSet parent = rset.getParent();
            if (parent != null && parent.getType() == 0) {
                return new NativeRowObject(start, (IQueryResultSet)parent);
            }
            return null;
        }
        try {
            if ("__rownum".equals(name)) {
                return new Long(rset.getRowIndex());
            }
            return rset.getValue(name);
        }
        catch (BirtException ex) {
            throw new EvaluatorException(ex.toString());
        }
    }

    public Object get(int index, Scriptable start) {
        if (index == 0) {
            return this.get("__rownum", start);
        }
        return this.get(String.valueOf(index), start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean has(String name, Scriptable start) {
        IQueryResultSet rset = this.getResultSet();
        if (rset == null) {
            return false;
        }
        try {
            IResultMetaData metaData = rset.getResultMetaData();
            int i = 0;
            while (true) {
                if (i >= metaData.getColumnCount()) {
                    return false;
                }
                String colName = metaData.getColumnName(i);
                if (colName.equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    public boolean has(int index, Scriptable start) {
        return false;
    }

    public void put(String name, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
    }

    public void delete(int index) {
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public Object[] getIds() {
        IQueryResultSet rset = this.getResultSet();
        if (rset == null) {
            return null;
        }
        try {
            IResultMetaData metaData = rset.getResultMetaData();
            Object[] names = new Object[metaData.getColumnCount()];
            int i = 0;
            while (i < names.length) {
                names[i] = metaData.getColumnName(i);
                ++i;
            }
            return names;
        }
        catch (BirtException birtException) {
            return null;
        }
    }

    public Object getDefaultValue(Class hint) {
        return null;
    }

    public boolean hasInstance(Scriptable instance) {
        return false;
    }
}

