/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.Value;

public class CellComputedStyle
extends ComputedStyle {
    private CSSStylableElement cell;
    private IStyle columnStyle;
    private IStyle rowStyle;

    public CellComputedStyle(ICellContent elt) {
        super(elt);
        IRowContent row = (IRowContent)elt.getParent();
        if (row != null) {
            int columnId;
            this.rowStyle = row.getStyle();
            ITableContent table = row.getTable();
            if (table != null && (columnId = elt.getColumn()) >= 0 && columnId < table.getColumnCount()) {
                IColumn column = table.getColumn(columnId);
                this.columnStyle = column.getStyle();
            }
        }
        this.cell = elt;
    }

    protected Value resolveProperty(int index) {
        IStyle s;
        Value sv;
        CSSStylableElement parent = (CSSStylableElement)this.cell.getParent();
        IStyle pcs = null;
        if (parent != null) {
            pcs = parent.getComputedStyle();
        }
        Value value = sv = (s = this.cell.getStyle()) == null ? null : (Value)s.getProperty(index);
        if (sv == null && this.columnStyle != null) {
            if (!this.engine.isInheritedProperty(index)) {
                if (this.isBackgroundProperties(index)) {
                    Value rowValue = null;
                    if (this.rowStyle != null) {
                        rowValue = (Value)this.rowStyle.getProperty(index);
                    }
                    if (rowValue == null) {
                        sv = (Value)this.columnStyle.getProperty(index);
                    }
                } else if (index == 38) {
                    if (this.rowStyle != null) {
                        sv = (Value)this.rowStyle.getProperty(index);
                    }
                    if (sv == null) {
                        sv = (Value)this.columnStyle.getProperty(index);
                    }
                } else {
                    sv = (Value)this.columnStyle.getProperty(index);
                }
            } else {
                sv = (Value)this.rowStyle.getProperty(index);
                if (sv == null) {
                    sv = (Value)this.columnStyle.getProperty(index);
                }
            }
        }
        Value cv = this.engine.resolveStyle(this.elt, index, sv, pcs);
        return cv;
    }

    private boolean isBackgroundProperties(int index) {
        return 25 == index || 52 == index || 49 == index || 15 == index;
    }
}

