/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.ui.action.ChangeAttachmentJob;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.BugzillaAttachmentWizardPage;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.widgets.Shell;

public class BugzillaAttachmentWizard
extends Wizard {
    private final AttributeEditorFactory factory;
    private final TaskAttribute attachmentAttribute;
    private BugzillaAttachmentWizardPage attachmentWizardPage;
    private final Shell parentShell;
    private boolean changed = false;
    private final TaskEditor taskEditor;
    private final ITaskAttachment attachment;

    public BugzillaAttachmentWizard(Shell parentShell, AttributeEditorFactory factory, TaskAttribute attachmentAttribute, TaskEditor taskEditor, ITaskAttachment attachment) {
        this.factory = factory;
        this.attachmentAttribute = attachmentAttribute;
        this.parentShell = parentShell;
        this.taskEditor = taskEditor;
        this.attachment = attachment;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.BugzillaAttachmentWizard_Attachment_Details_Dialog_Title);
    }

    public boolean performFinish() {
        TaskAttribute attachmentTaskAttribute = this.attachment.getTaskAttribute();
        for (TaskAttribute child : this.attachmentAttribute.getAttributes().values()) {
            attachmentTaskAttribute.deepAddCopy(child);
        }
        ChangeAttachmentJob job = new ChangeAttachmentJob(this.attachment, this.taskEditor);
        job.setUser(true);
        if (this.attachmentWizardPage.runInBackground()) {
            this.runInBackground(job);
        } else {
            this.runInWizard(job);
        }
        return true;
    }

    private boolean runInWizard(final ChangeAttachmentJob job) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    job.run(monitor);
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", "Unexpected error", (Throwable)e));
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void runInBackground(ChangeAttachmentJob job) {
        job.schedule();
    }

    public void addPages() {
        this.attachmentWizardPage = new BugzillaAttachmentWizardPage(this.parentShell, this.factory, this.attachmentAttribute, this.attachment.getTask().getTaskId());
        this.addPage((IWizardPage)this.attachmentWizardPage);
    }

    public boolean canFinish() {
        return this.isChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

