/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.resources.ui.ResourcePatternExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiExtensionPointReader;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUiPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String PREF_DEFAULT_SCOPE = "org.eclipse.mylyn.ide.resources";
    @Deprecated
    private static final String PREF_STORE_DELIM = ", ";
    @Deprecated
    private static final String PREF_RESOURCES_IGNORED = "org.eclipse.mylyn.ide.resources.ignored.pattern";
    private static final String PREF_RESOURCES_IGNORED_ANT = "org.eclipse.mylyn.ide.resources.ignored.pattern.ant";
    public static final String PREF_MODIFIED_DATE_EXCLUSIONS = "org.eclipse.mylyn.ide.resources.date.modified.exclusion";
    private static final String KEY_RESOURCE_EXCLUSIONS = "resourceExclusions";
    private static final String KEY_EXCLUSION = "exclusion";
    private static final String KEY_ANT_PATTERN = "antPattern";
    public static Set<String> forcedExclusionPatterns = new HashSet<String>();
    public static Set<String> cachedExclusionPatterns = null;

    public void initializeDefaultPreferences() {
        HashSet<String> defaultPatterns = new HashSet<String>();
        defaultPatterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern(".*"));
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setDefault(PREF_RESOURCES_IGNORED_ANT, ResourcesUiPreferenceInitializer.createResourceExclusionMemento(defaultPatterns));
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setDefault(PREF_MODIFIED_DATE_EXCLUSIONS, true);
    }

    public static void restoreDefaultExcludedResourcePatterns() {
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(ResourcesUiExtensionPointReader.getDefaultResourceExclusions());
    }

    public static synchronized void setExcludedResourcePatterns(Set<String> patterns) {
        cachedExclusionPatterns = new HashSet<String>(patterns);
        String memento = ResourcesUiPreferenceInitializer.createResourceExclusionMemento(patterns);
        if (memento != null) {
            ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue(PREF_RESOURCES_IGNORED_ANT, memento);
        }
    }

    private static String createResourceExclusionMemento(Set<String> patterns) {
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)KEY_RESOURCE_EXCLUSIONS);
        for (String string : patterns) {
            IMemento memento = rootMemento.createChild(KEY_EXCLUSION);
            memento.putString(KEY_ANT_PATTERN, string);
        }
        StringWriter writer = new StringWriter();
        String memento = null;
        try {
            rootMemento.save((Writer)writer);
            memento = writer.getBuffer().toString();
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not store resource exclusions", (Throwable)e));
        }
        return memento;
    }

    private static Set<String> getResourceExclusionsFromMemento(String mementoString) {
        HashSet<String> exclusions = new HashSet<String>();
        try {
            XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
            IMemento[] iMementoArray = rootMemento.getChildren(KEY_EXCLUSION);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                String pattern = memento.getString(KEY_ANT_PATTERN);
                if (pattern != null) {
                    exclusions.add(pattern);
                }
                ++n2;
            }
        }
        catch (WorkbenchException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not load resource exclusions", (Throwable)e));
        }
        return exclusions;
    }

    public static synchronized Set<String> getExcludedResourcePatterns() {
        if (cachedExclusionPatterns != null) {
            return new HashSet<String>(cachedExclusionPatterns);
        }
        Set<String> exclusions = new HashSet<String>();
        if (ResourcesUiBridgePlugin.getDefault().getPreferenceStore().contains(PREF_RESOURCES_IGNORED_ANT) && !ResourcesUiBridgePlugin.getDefault().getPreferenceStore().isDefault(PREF_RESOURCES_IGNORED_ANT)) {
            exclusions = ResourcesUiPreferenceInitializer.getResourceExclusionsFromMemento(ResourcesUiBridgePlugin.getDefault().getPreferenceStore().getString(PREF_RESOURCES_IGNORED_ANT));
        } else {
            String read = ResourcesUiBridgePlugin.getDefault().getPreferenceStore().getString(PREF_RESOURCES_IGNORED);
            if (read != null) {
                StringTokenizer st = new StringTokenizer(read, PREF_STORE_DELIM);
                while (st.hasMoreTokens()) {
                    exclusions.addAll(ResourcePatternExclusionStrategy.convertToAntPattern(st.nextToken()));
                }
            }
            ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(exclusions);
        }
        cachedExclusionPatterns = new HashSet<String>(exclusions);
        return cachedExclusionPatterns;
    }

    public static Set<String> getForcedExcludedResourcePatterns() {
        return forcedExclusionPatterns;
    }

    public static void addForcedExclusionPattern(String pattern) {
        forcedExclusionPatterns.add(pattern);
    }

    public static void removeForcedExclusionPattern(String pattern) {
        forcedExclusionPatterns.remove(pattern);
    }
}

