/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.resources.ui.IResourceExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;

public class ResourceModifiedDateExclusionStrategy
extends AbstractContextListener
implements IResourceExclusionStrategy,
IPropertyChangeListener {
    private transient Date lastActivatedDate = null;
    private boolean isEnabled = false;

    public void dispose() {
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init() {
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.isEnabled = ResourcesUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.resources.date.modified.exclusion");
        ContextCore.getContextManager().addListener((AbstractContextListener)this);
        if (ContextCore.getContextManager().isContextActive()) {
            this.lastActivatedDate = new Date();
        }
    }

    public void update() {
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isExcluded(IResource resource) {
        return this.isEnabled() && resource instanceof IFile && !this.wasModifiedAfter(resource, this.lastActivatedDate);
    }

    public boolean wasModifiedAfter(IResource resource, Date date) {
        if (date == null) {
            return false;
        }
        long modificationStamp = resource.getLocalTimeStamp();
        if (modificationStamp > 0L && modificationStamp != -1L) {
            Date resourceDate = new Date(modificationStamp);
            return resourceDate.equals(date) || resourceDate.after(date);
        }
        return false;
    }

    public Date getLastActivatedDate() {
        return this.lastActivatedDate;
    }

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: {
                long currentTime = new Date().getTime();
                currentTime = (long)((double)currentTime - (double)currentTime % 1000.0);
                this.lastActivatedDate = new Date(currentTime);
                break;
            }
            case DEACTIVATED: {
                this.lastActivatedDate = null;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.mylyn.ide.resources.date.modified.exclusion".equals(event.getProperty())) {
            Object newValue = event.getNewValue();
            if (newValue instanceof Boolean) {
                this.setEnabled((Boolean)newValue);
            } else if (newValue instanceof String) {
                this.setEnabled(Boolean.parseBoolean((String)newValue));
            }
        }
    }
}

