/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private boolean needStackingForCommitRollbackPrepare = false;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:36:21_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
            this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_version < 8170) {
            throw new XAException(-6);
        }
    }

    public void start(Xid xid, int n2) throws XAException {
        int n3 = -1;
        Object var4_4 = null;
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            int n4 = n2 & 0xFF00;
            int n5 = (n2 &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
            if (((n2 &= 0xFFFEFFFF) & 0x8200002) != n2 || n5 != 0 && (n5 & 0x10000) != 65536) {
                throw new XAException(-5);
            }
            if ((n4 & 0xFF00) != 0 && n4 != 256 && n4 != 512 && n4 != 1024) {
                throw new XAException(-5);
            }
            if ((n2 & 0x8200000) != 0 && ((n4 & 0xFF00) != 0 || (n5 & 0x10000) != 0)) {
                throw new XAException(-5);
            }
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            n3 = this.doStart(xid, n2 |= n4 | n5);
            this.checkError(n3);
            boolean[] blArray = new boolean[]{false};
            super.createOrUpdateXid(xid, false, blArray);
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int n2) throws XAException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_start_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, this.timeout);
            callableStatement.setInt(6, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n2) throws XAException {
        int n3 = -1;
        boolean bl = false;
        try {
            if (xid == null) {
                throw new XAException(-5);
            }
            int n4 = 638582786;
            if ((n2 & n4) != n2) {
                throw new XAException(-5);
            }
            boolean bl2 = this.isCurrentXidSuspended(xid);
            Xid xid2 = super.suspendStacked(xid, n2);
            boolean[] blArray = new boolean[]{false, false};
            boolean bl3 = true;
            if (n2 == 0x2000000) {
                super.createOrUpdateXid(xid, true, blArray);
            } else if (xid2 != null) {
                bl3 = super.updateXidList(xid, blArray);
                bl = blArray[1];
            }
            if (!bl) {
                if (!bl3 && n2 == 0x4000000) {
                    bl = true;
                } else if (bl2) {
                    bl = true;
                }
            }
            if (bl && (n3 = this.doStart(xid, 0x8000000)) != 0) {
                super.resumeStacked(xid2);
                this.checkError(n3);
            }
            n3 = this.doEnd(xid, n2, blArray[0]);
            if (n2 == 0x4000000 && n3 == 0) {
                this.removeXidFromList(xid);
                this.currentXidListEntry = null;
            }
            if (xid2 != null) {
                super.resumeStacked(xid2);
            } else if (this.isXidListEmpty()) {
                this.exitGlobalTxnMode();
                this.currentXidListEntry = null;
            }
            this.checkError(n3);
        }
        finally {
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException {
        CallableStatement callableStatement = null;
        int n3 = -1;
        try {
            callableStatement = this.connection.prepareCall(xa_end_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        int n2 = -1;
        boolean bl2 = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        int n3 = bl ? 1 : 0;
        Xid xid2 = null;
        if (this.needStackingForCommitRollbackPrepare) {
            xid2 = super.suspendStacked(xid);
        } else {
            this.exitGlobalTxnMode();
            this.currentXidListEntry = null;
        }
        n2 = this.doCommit(xid, n3);
        if (n2 != 0 && OracleXAException.errorConvert(n2, -7) == -7) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        } else if (this.needStackingForCommitRollbackPrepare) {
            super.resumeStacked(xid2);
        }
        this.checkError(n2, -7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doCommit(Xid xid, int n2) throws XAException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        boolean bl = false;
        try {
            callableStatement = this.connection.prepareCall(xa_commit_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    public int prepare(Xid xid) throws XAException {
        int n2;
        int n3 = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = null;
        if (this.needStackingForCommitRollbackPrepare) {
            xid2 = super.suspendStacked(xid);
        }
        n3 = this.doPrepare(xid);
        if (this.needStackingForCommitRollbackPrepare) {
            super.resumeStacked(xid2);
        }
        int n4 = n2 = n3 == 0 ? 0 : OracleXAException.errorConvert(n3);
        if (n2 != 0 && n2 != 3) {
            throw new OracleXAException(n3);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_prepare_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    public void forget(Xid xid) throws XAException {
        int n2 = 0;
        if (xid == null) {
            throw new XAException(-5);
        }
        n2 = this.doForget(xid);
        this.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doForget(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_forget_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    public void rollback(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl = false;
        if (xid == null) {
            throw new XAException(-5);
        }
        Xid xid2 = null;
        if (this.needStackingForCommitRollbackPrepare) {
            xid2 = super.suspendStacked(xid);
        } else {
            this.exitGlobalTxnMode();
            this.currentXidListEntry = null;
        }
        n2 = this.doRollback(xid);
        if (this.needStackingForCommitRollbackPrepare) {
            super.resumeStacked(xid2);
        }
        this.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRollback(Xid xid) throws XAException {
        int n2 = 0;
        boolean bl = false;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_rollback_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                throw new XAException(-6);
            }
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        this.doDoTwoPhaseAction(n2, n3, stringArray, xidArray);
    }

    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        throw new XAException(-6);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

