/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.fieldassist.FieldAssistHelper;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DataDefinitionSelector;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSeriesSelectorComponent
extends DefaultSelectDataComponent {
    private EList<?>[] seriesDefnsArray;
    private ChartWizardContext wizardContext = null;
    private String sTitle = null;
    private Group cmpLeft;
    private DataDefinitionSelector[] selectors;
    private ISelectDataCustomizeUI selectDataUI = null;
    private String areaTitle = Messages.getString("SelectDataChartWithAxisUI.Label.ValueYSeries");

    public MultipleSeriesSelectorComponent(EList<?>[] seriesDefnsArray, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefnsArray = seriesDefnsArray;
        this.wizardContext = wizardContext;
        this.sTitle = sTitle;
        this.selectDataUI = selectDataUI;
    }

    protected DataDefinitionSelector createDataDefinitionSelector(int axisIndex, EList<?> seriesDefns, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        return new DataDefinitionSelector(axisIndex, seriesDefns, wizardContext, sTitle, selectDataUI);
    }

    public Composite createArea(Composite parent) {
        Label topAngle = new Label(parent, 0);
        topAngle.setLayoutData((Object)new GridData(128));
        topAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_topright.gif"));
        this.cmpLeft = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.cmpLeft.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        this.cmpLeft.setLayoutData((Object)gd);
        if (FieldAssistHelper.getInstance().isShowingRequiredFieldIndicator()) {
            this.cmpLeft.setText(this.areaTitle.concat("*"));
        } else {
            this.cmpLeft.setText(this.areaTitle);
        }
        if (this.seriesDefnsArray.length > 2) {
            this.wizardContext.setMoreAxesSupported(true);
        }
        if (this.wizardContext.isMoreAxesSupported()) {
            this.selectors = new DataDefinitionSelector[1];
            this.selectors[0] = new DataDefinitionSelector(this.wizardContext, this.sTitle, this.selectDataUI);
            if (this.wizardContext.getModel() instanceof DialChart) {
                this.selectors[0].setSelectionPrefix(Messages.getString("DialBottomAreaComponent.Label.Dial"));
            }
            this.selectors[0].createArea((Composite)this.cmpLeft);
        } else {
            this.selectors = new DataDefinitionSelector[this.seriesDefnsArray.length];
            int i = 0;
            while (i < this.seriesDefnsArray.length) {
                int axisIndex = this.seriesDefnsArray.length == 1 ? -1 : i;
                this.selectors[i] = this.createDataDefinitionSelector(axisIndex, this.seriesDefnsArray[i], this.wizardContext, this.sTitle, this.selectDataUI);
                if (this.wizardContext.getModel() instanceof DialChart) {
                    this.selectors[i].setSelectionPrefix(Messages.getString("DialBottomAreaComponent.Label.Dial"));
                }
                this.selectors[i].createArea((Composite)this.cmpLeft);
                ++i;
            }
        }
        Label bottomAngle = new Label(parent, 0);
        bottomAngle.setLayoutData((Object)new GridData(128));
        bottomAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_bottomright.gif"));
        return this.cmpLeft;
    }

    public void selectArea(boolean selected, Object data) {
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i].selectArea(selected, data);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public void setAreaTitle(String areaTitle) {
        this.areaTitle = areaTitle;
    }
}

