/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskIndex;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class Hierarchy
implements IHierarchy {
    private IDocumentManager documentManager = null;
    private IDocumentObject documentObj = null;
    private IDocumentObject offsetDocObj = null;
    private Level[] levels = null;
    private String name = null;
    private Map levelMap = new HashMap();
    private String dimensionName;

    public Hierarchy(IDocumentManager documentManager, String dimensionName, String hierarchyName) {
        this.documentManager = documentManager;
        this.dimensionName = dimensionName;
        this.name = hierarchyName;
    }

    public ILevel[] getLevels() {
        return this.levels;
    }

    public String getName() {
        return this.name;
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.levels.length) {
            this.levels[i].close();
            ++i;
        }
        if (this.documentObj != null) {
            this.documentObj.close();
            this.documentObj = null;
        }
        if (this.offsetDocObj != null) {
            this.offsetDocObj.close();
            this.offsetDocObj = null;
        }
    }

    public int size() {
        return this.levels[this.levels.length - 1].size();
    }

    public void createAndSaveHierarchy(IDatasetIterator datasetIterator, ILevelDefn[] levelDefs, StopSign stopSign) throws IOException, BirtException {
        this.documentObj = this.createHierarchyDocumentObject();
        this.offsetDocObj = this.createLevelOffsetDocumentObject();
        DiskSortedStack sortedDimensionSet = Hierarchy.getSortedDimRows(datasetIterator, levelDefs);
        this.documentObj.seek(4L);
        this.saveHierarchyMetadata(datasetIterator, levelDefs);
        int[][] keyDataType = new int[levelDefs.length][];
        int[][] attributesDataType = new int[levelDefs.length][];
        int i = 0;
        while (i < levelDefs.length) {
            keyDataType[i] = new int[levelDefs[i].getKeyColumns().length];
            int j = 0;
            while (j < levelDefs[i].getKeyColumns().length) {
                keyDataType[i][j] = datasetIterator.getFieldType(levelDefs[i].getKeyColumns()[j]);
                ++j;
            }
            if (levelDefs[i].getAttributeColumns() != null) {
                attributesDataType[i] = new int[levelDefs[i].getAttributeColumns().length];
                j = 0;
                while (j < levelDefs[i].getAttributeColumns().length) {
                    attributesDataType[i][j] = datasetIterator.getFieldType(levelDefs[i].getAttributeColumns()[j]);
                    ++j;
                }
            }
            ++i;
        }
        int size = this.saveHierarchyRows(levelDefs, keyDataType, attributesDataType, sortedDimensionSet, stopSign);
        int savedPointer = (int)this.documentObj.getFilePointer();
        this.documentObj.seek(0L);
        this.documentObj.writeInt(size);
        this.documentObj.seek(savedPointer);
        this.closeWriteDocuemntObject();
        this.openReadDocuemntObject();
    }

    private void closeWriteDocuemntObject() throws IOException {
        if (this.documentObj != null) {
            this.documentObj.close();
            this.documentObj = null;
        }
        if (this.offsetDocObj != null) {
            this.offsetDocObj.close();
            this.offsetDocObj = null;
        }
    }

    private void openReadDocuemntObject() throws IOException {
        if (this.documentObj == null) {
            this.documentObj = this.documentManager.openDocumentObject(NamingUtil.getHierarchyDocName(this.dimensionName, this.name));
        }
        if (this.offsetDocObj == null) {
            this.offsetDocObj = this.documentManager.openDocumentObject(NamingUtil.getHierarchyOffsetDocName(this.dimensionName, this.name));
        }
    }

    public void loadFromDisk() throws IOException, DataException {
        this.openReadDocuemntObject();
        int size = this.documentObj.readInt();
        this.levels = new Level[this.documentObj.readInt()];
        int i = 0;
        while (i < this.levels.length) {
            String levelName = this.documentObj.readString();
            String[] keyColName = new String[this.documentObj.readInt()];
            int[] keyDataType = new int[keyColName.length];
            int j = 0;
            while (j < keyColName.length) {
                keyColName[j] = this.documentObj.readString();
                keyDataType[j] = this.documentObj.readInt();
                ++j;
            }
            int attributeNumber = this.documentObj.readInt();
            String[] attributeColNames = null;
            int[] attributeDataTypes = null;
            if (attributeNumber > 0) {
                attributeColNames = new String[attributeNumber];
                attributeDataTypes = new int[attributeNumber];
                int j2 = 0;
                while (j2 < attributeNumber) {
                    attributeColNames[j2] = this.documentObj.readString();
                    attributeDataTypes[j2] = this.documentObj.readInt();
                    ++j2;
                }
            }
            this.levels[i] = new Level(this.documentManager, new LevelDefinition(levelName, keyColName, attributeColNames), keyDataType, attributeDataTypes, size, size == 0 ? null : DiskIndex.loadIndex(this.documentManager, NamingUtil.getLevelIndexDocName(this.dimensionName, levelName)));
            ++i;
        }
    }

    private IDocumentObject createHierarchyDocumentObject() throws IOException {
        return this.documentManager.createDocumentObject(NamingUtil.getHierarchyDocName(this.dimensionName, this.name));
    }

    private IDocumentObject createLevelOffsetDocumentObject() throws IOException {
        return this.documentManager.createDocumentObject(NamingUtil.getHierarchyOffsetDocName(this.dimensionName, this.name));
    }

    private void saveHierarchyMetadata(IDatasetIterator iterator, ILevelDefn[] levelDefs) throws IOException, BirtException {
        this.documentObj.writeInt(levelDefs.length);
        int i = 0;
        while (i < levelDefs.length) {
            this.saveLevelMetadata(iterator, levelDefs[i]);
            ++i;
        }
    }

    private void saveLevelMetadata(IDatasetIterator iterator, ILevelDefn levelDef) throws IOException, BirtException {
        this.documentObj.writeString(levelDef.getLevelName());
        this.documentObj.writeInt(levelDef.getKeyColumns().length);
        int i = 0;
        while (i < levelDef.getKeyColumns().length) {
            this.documentObj.writeString(levelDef.getKeyColumns()[i]);
            this.documentObj.writeInt(iterator.getFieldType(levelDef.getKeyColumns()[i]));
            ++i;
        }
        String[] attributes = levelDef.getAttributeColumns();
        if (attributes != null) {
            this.documentObj.writeInt(attributes.length);
            int j = 0;
            while (j < attributes.length) {
                this.documentObj.writeString(attributes[j]);
                this.documentObj.writeInt(iterator.getFieldType(attributes[j]));
                ++j;
            }
        } else {
            this.documentObj.writeInt(0);
        }
    }

    private int saveHierarchyRows(ILevelDefn[] levelDefs, int[][] keyDataType, int[][] attributesDataType, DiskSortedStack sortedDimensionSet, StopSign stopSign) throws IOException, BirtException {
        DiskSortedStack sortedDimMembers = new DiskSortedStack(Math.min(sortedDimensionSet.size(), Constants.MAX_LIST_BUFFER_SIZE), true, false, Member.getCreator());
        IDiskArray[] indexKeyLists = new IDiskArray[keyDataType.length];
        int i = 0;
        while (i < indexKeyLists.length) {
            indexKeyLists[i] = new BufferedStructureArray(IndexKey.getCreator(), Math.min(sortedDimensionSet.size(), Constants.MAX_LIST_BUFFER_SIZE));
            ++i;
        }
        Object obj = sortedDimensionSet.pop();
        int currentIndex = 0;
        IndexKey indexKey = null;
        while (obj != null) {
            if (stopSign.isStopped()) break;
            DimensionRow dimRows = (DimensionRow)obj;
            Member[] levelMembers = dimRows.getMembers();
            int i2 = 0;
            while (i2 < indexKeyLists.length) {
                indexKey = new IndexKey();
                indexKey.setKey(levelMembers[i2].getKeyValues());
                indexKey.setOffset((int)this.documentObj.getFilePointer());
                indexKey.setDimensionPos(currentIndex);
                indexKeyLists[i2].add(indexKey);
                ++i2;
            }
            this.offsetDocObj.writeInt((int)this.documentObj.getFilePointer());
            sortedDimMembers.push(dimRows.getMembers()[levelDefs.length - 1]);
            this.writeDimensionRow(dimRows, keyDataType, attributesDataType);
            obj = sortedDimensionSet.pop();
            ++currentIndex;
        }
        this.validateDimensionMembers(sortedDimMembers);
        DiskIndex[] diskIndex = new DiskIndex[indexKeyLists.length];
        int i3 = 0;
        while (i3 < indexKeyLists.length) {
            diskIndex[i3] = DiskIndex.createIndex(this.documentManager, NamingUtil.getLevelIndexDocName(this.dimensionName, levelDefs[i3].getLevelName()), indexKeyLists[i3], false);
            ++i3;
        }
        this.levels = new Level[levelDefs.length];
        i3 = 0;
        while (i3 < this.levels.length) {
            this.levels[i3] = new Level(this.documentManager, levelDefs[i3], keyDataType[i3], attributesDataType[i3], currentIndex, diskIndex[i3]);
            this.levels[i3].setLevelType(levelDefs[i3].getTimeType());
            ++i3;
        }
        i3 = 0;
        while (i3 < this.levels.length) {
            this.levelMap.put(this.levels[i3].getName(), this.levels[i3]);
            ++i3;
        }
        return currentIndex;
    }

    private void validateDimensionMembers(DiskSortedStack sortedDimMembers) throws IOException, DataException {
        Object obj = sortedDimMembers.pop();
        Member lastMember = null;
        while (obj != null) {
            Member currentMember = (Member)obj;
            if (lastMember != null && lastMember.equals(currentMember)) {
                throw new DataException("data.olap.DetailMemberHaveMultiParent", lastMember.getKeyValues()[0]);
            }
            lastMember = currentMember;
            obj = sortedDimMembers.pop();
        }
    }

    private void writeDimensionRow(DimensionRow dimensionMember, int[][] keyDataType, int[][] attributesDataType) throws IOException, DataException {
        Member[] levelMembers = dimensionMember.getMembers();
        int i = 0;
        while (i < levelMembers.length) {
            this.writeLevelMember(levelMembers[i], keyDataType[i], attributesDataType[i]);
            ++i;
        }
    }

    private void writeLevelMember(Member levelMember, int[] keyDataType, int[] attributesDataType) throws IOException, DataException {
        int i = 0;
        while (i < levelMember.getKeyValues().length) {
            DocumentObjectUtil.writeValue(this.documentObj, keyDataType[i], levelMember.getKeyValues()[i]);
            ++i;
        }
        if (levelMember.getAttributes() != null) {
            i = 0;
            while (i < levelMember.getAttributes().length) {
                DocumentObjectUtil.writeValue(this.documentObj, attributesDataType[i], levelMember.getAttributes()[i]);
                ++i;
            }
        }
    }

    private DimensionRow readDimensionRow() throws IOException {
        Member[] levelMembers = new Member[this.levels.length];
        int i = 0;
        while (i < levelMembers.length) {
            levelMembers[i] = this.readLevelMember(this.levels[i]);
            ++i;
        }
        return new DimensionRow(levelMembers);
    }

    private Member readLevelMember(Level level) throws IOException {
        Member levelMember = new Member();
        levelMember.setKeyValues(new Object[level.getKeyColNames().length]);
        int i = 0;
        while (i < level.getKeyColNames().length) {
            levelMember.getKeyValues()[i] = DocumentObjectUtil.readValue(this.documentObj, level.getKeyDataType()[i]);
            ++i;
        }
        if (level.getAttributeDataTypes() != null && level.getAttributeDataTypes().length > 0) {
            levelMember.setAttributes(new Object[level.getAttributeDataTypes().length]);
            i = 0;
            while (i < level.getAttributeDataTypes().length) {
                levelMember.getAttributes()[i] = DocumentObjectUtil.readValue(this.documentObj, level.getAttributeDataTypes()[i]);
                ++i;
            }
        }
        return levelMember;
    }

    public IDiskArray readAllRows(StopSign stopSign) throws IOException, DataException {
        if (this.documentObj == null) {
            this.loadFromDisk();
        }
        this.documentObj.seek(0L);
        int size = this.documentObj.readInt();
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionRow.getCreator(), size + 1);
        if (size == 0) {
            return resultArray;
        }
        this.offsetDocObj.seek(0L);
        this.documentObj.seek(this.offsetDocObj.readInt());
        int i = 0;
        while (i < size) {
            if (stopSign.isStopped()) break;
            resultArray.add(this.readDimensionRow());
            ++i;
        }
        return resultArray;
    }

    public DimensionRow readRowByPosition(int dimPosition) throws IOException {
        this.offsetDocObj.seek(dimPosition * 4);
        return this.readRowByOffset(this.offsetDocObj.readInt());
    }

    public DimensionRow readRowByOffset(int offset) throws IOException {
        this.documentObj.seek(offset);
        return this.readDimensionRow();
    }

    private static DiskSortedStack getSortedDimRows(IDatasetIterator iterator, ILevelDefn[] levelDefs) throws BirtException, IOException {
        DiskSortedStack result = new DiskSortedStack(Constants.LIST_BUFFER_SIZE, true, true, DimensionRow.getCreator());
        int[][] levelKeyColumnIndex = new int[levelDefs.length][];
        int[][] levelAttributesIndex = new int[levelDefs.length][];
        int i = 0;
        while (i < levelDefs.length) {
            levelKeyColumnIndex[i] = new int[levelDefs[i].getKeyColumns().length];
            int j = 0;
            while (j < levelDefs[i].getKeyColumns().length) {
                levelKeyColumnIndex[i][j] = iterator.getFieldIndex(levelDefs[i].getKeyColumns()[j]);
                ++j;
            }
            String[] attributeColumns = levelDefs[i].getAttributeColumns();
            if (attributeColumns != null) {
                levelAttributesIndex[i] = new int[attributeColumns.length];
                int j2 = 0;
                while (j2 < attributeColumns.length) {
                    levelAttributesIndex[i][j2] = iterator.getFieldIndex(attributeColumns[j2]);
                    ++j2;
                }
            }
            ++i;
        }
        Member[] levelMembers = null;
        while (iterator.next()) {
            levelMembers = new Member[levelDefs.length];
            int i2 = 0;
            while (i2 < levelDefs.length) {
                levelMembers[i2] = Hierarchy.getLevelMember(iterator, levelKeyColumnIndex[i2], levelAttributesIndex[i2], levelDefs[i2]);
                ++i2;
            }
            result.push(new DimensionRow(levelMembers));
        }
        return result;
    }

    private static Member getLevelMember(IDatasetIterator iterator, int[] keyCols, int[] attributeCols, ILevelDefn levelDefn) throws BirtException {
        Member levelMember = new Member();
        levelMember.setKeyValues(new Object[keyCols.length]);
        int i = 0;
        while (i < keyCols.length) {
            levelMember.getKeyValues()[i] = iterator.getValue(keyCols[i]);
            if (levelMember.getKeyValues()[i] == null) {
                throw new DataException("data.olap.KeyValueCanNotBeNull", levelDefn.getKeyColumns()[i]);
            }
            ++i;
        }
        if (attributeCols != null) {
            levelMember.setAttributes(new Object[attributeCols.length]);
            i = 0;
            while (i < attributeCols.length) {
                levelMember.getAttributes()[i] = iterator.getValue(attributeCols[i]);
                ++i;
            }
        }
        return levelMember;
    }
}

