/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;

public class AggregationResultSetSaveUtil {
    private static String PREFIX_RESULTSET = "_ar_";

    public static void save(String name, IAggregationResultSet[] resultSets, IDocArchiveWriter writer) throws IOException {
        if (writer == null || name == null) {
            return;
        }
        RAOutputStream outputStream = writer.createRandomAccessStream(name);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)outputStream);
        if (resultSets == null) {
            dataOutputStream.writeInt(-1);
            return;
        }
        dataOutputStream.writeInt(resultSets.length);
        dataOutputStream.close();
        int i = 0;
        while (i < resultSets.length) {
            outputStream = writer.createRandomAccessStream(String.valueOf(name) + PREFIX_RESULTSET + i);
            dataOutputStream = new DataOutputStream((OutputStream)outputStream);
            AggregationResultSetSaveUtil.saveOneResultSet(dataOutputStream, resultSets[i]);
            dataOutputStream.close();
            ++i;
        }
    }

    public static IAggregationResultSet[] load(String name, IDocArchiveReader reader, int version) throws IOException {
        RAInputStream inputStream = reader.getStream(name);
        DataInputStream dataInputStream = new DataInputStream((InputStream)inputStream);
        int size = dataInputStream.readInt();
        inputStream.close();
        if (size <= 0) {
            return null;
        }
        IAggregationResultSet[] result = new IAggregationResultSet[size];
        int i = 0;
        while (i < size) {
            inputStream = version != 20 ? reader.getStream(String.valueOf(name) + PREFIX_RESULTSET + i) : reader.getStream(String.valueOf(name) + i);
            dataInputStream = new DataInputStream((InputStream)inputStream);
            result[i] = AggregationResultSetSaveUtil.loadOneResultSet(dataInputStream);
            dataInputStream.close();
            ++i;
        }
        return result;
    }

    private static IAggregationResultSet loadOneResultSet(DataInputStream dataInputStream) throws IOException {
        String[] dimNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        String[] levelNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        DimLevel[] levels = null;
        if (dimNames != null && levelNames != null) {
            levels = new DimLevel[levelNames.length];
            int i = 0;
            while (i < levels.length) {
                levels[i] = new DimLevel(dimNames[i], levelNames[i]);
                ++i;
            }
        }
        String[][] keyNames = AggregationResultSetSaveUtil.convertToMDStringArray(AggregationResultSetSaveUtil.readMDObjectArray(dataInputStream));
        int[][] keyDataTypes = AggregationResultSetSaveUtil.readMDIntArray(dataInputStream);
        String[][] attributeNames = AggregationResultSetSaveUtil.convertToMDStringArray(AggregationResultSetSaveUtil.readMDObjectArray(dataInputStream));
        int[][] attributeDataTypes = AggregationResultSetSaveUtil.readMDIntArray(dataInputStream);
        int[] sortTypes = AggregationResultSetSaveUtil.readIntArray(dataInputStream);
        String[] aggregationNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        int[] aggregationDataType = AggregationResultSetSaveUtil.readIntArray(dataInputStream);
        int size = IOUtil.readInt((InputStream)dataInputStream);
        return new CachedAggregationResultSet(dataInputStream, size, levels, sortTypes, keyNames, attributeNames, keyDataTypes, attributeDataTypes, aggregationNames, aggregationDataType);
    }

    private static String[] convertToStringArray(Object[] objs) {
        if (objs == null) {
            return null;
        }
        String[] result = new String[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }

    private static String[][] convertToMDStringArray(Object[][] objs) {
        if (objs == null) {
            return null;
        }
        String[][] result = new String[objs.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.convertToStringArray(objs[i]);
            ++i;
        }
        return result;
    }

    private static void saveOneResultSet(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        AggregationResultSetSaveUtil.saveMetaData(outputStream, resultSet);
        AggregationResultSetSaveUtil.saveAggregationRowSet(outputStream, resultSet);
    }

    private static void saveAggregationRowSet(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        IOUtil.writeInt((OutputStream)outputStream, (int)resultSet.length());
        int i = 0;
        while (i < resultSet.length()) {
            resultSet.seek(i);
            AggregationResultSetSaveUtil.saveAggregationRow(outputStream, resultSet.getCurrentRow());
            ++i;
        }
    }

    private static void saveAggregationRow(DataOutputStream outputStream, IAggregationResultRow resultRow) throws IOException {
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultRow.getFieldValues());
    }

    public static AggregationResultRow loadAggregationRow(DataInputStream inputStream) throws IOException {
        Object[] objects = AggregationResultSetSaveUtil.readObjectArray(inputStream);
        if (objects == null || objects.length == 0) {
            return null;
        }
        return (AggregationResultRow)AggregationResultRow.getCreator().createInstance(objects);
    }

    private static void saveMetaData(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        DimLevel[] levels = resultSet.getAllLevels();
        Object[] dimensionNames = null;
        Object[] levelNames = null;
        if (levels != null) {
            dimensionNames = new String[levels.length];
            levelNames = new String[levels.length];
            int i = 0;
            while (i < levels.length) {
                dimensionNames[i] = levels[i].getDimensionName();
                levelNames[i] = levels[i].getLevelName();
                ++i;
            }
        }
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, dimensionNames);
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, levelNames);
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultSet.getLevelKeys());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getLevelKeyDataType());
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultSet.getLevelAttributes());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getLevelAttributeDataType());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getSortType());
        Object[] aggregationNames = new String[resultSet.getAggregationCount()];
        int i = 0;
        while (i < aggregationNames.length) {
            aggregationNames[i] = resultSet.getAggregationName(i);
            ++i;
        }
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, aggregationNames);
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getAggregationDataType());
    }

    private static void writeObjectArray(DataOutputStream outputStream, Object[] objects) throws IOException {
        if (objects == null) {
            IOUtil.writeInt((OutputStream)outputStream, (int)-1);
            return;
        }
        IOUtil.writeInt((OutputStream)outputStream, (int)objects.length);
        int i = 0;
        while (i < objects.length) {
            IOUtil.writeObject((DataOutputStream)outputStream, (Object)objects[i]);
            ++i;
        }
    }

    private static Object[] readObjectArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        if (size == -1) {
            return null;
        }
        Object[] result = new Object[size];
        int i = 0;
        while (i < result.length) {
            result[i] = IOUtil.readObject((DataInputStream)inputStream, (ClassLoader)DataEngineSession.getCurrentClassLoader());
            ++i;
        }
        return result;
    }

    private static Object[][] readMDObjectArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        if (size == -1) {
            return null;
        }
        Object[][] result = new Object[size][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.readObjectArray(inputStream);
            ++i;
        }
        return result;
    }

    private static void writeObjectArray(DataOutputStream outputStream, Object[][] objects) throws IOException {
        if (objects == null) {
            IOUtil.writeInt((OutputStream)outputStream, (int)-1);
            return;
        }
        IOUtil.writeInt((OutputStream)outputStream, (int)objects.length);
        int i = 0;
        while (i < objects.length) {
            AggregationResultSetSaveUtil.writeObjectArray(outputStream, objects[i]);
            ++i;
        }
    }

    private static int[] readIntArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        if (size == -1) {
            return null;
        }
        int[] result = new int[size];
        int i = 0;
        while (i < result.length) {
            result[i] = IOUtil.readInt((InputStream)inputStream);
            ++i;
        }
        return result;
    }

    private static int[][] readMDIntArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        if (size == -1) {
            return null;
        }
        int[][] result = new int[size][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.readIntArray(inputStream);
            ++i;
        }
        return result;
    }

    private static void writeIntArray(DataOutputStream outputStream, int[] iA) throws IOException {
        if (iA == null) {
            IOUtil.writeInt((OutputStream)outputStream, (int)-1);
            return;
        }
        IOUtil.writeInt((OutputStream)outputStream, (int)iA.length);
        int i = 0;
        while (i < iA.length) {
            IOUtil.writeInt((OutputStream)outputStream, (int)iA[i]);
            ++i;
        }
    }

    private static void writeIntArray(DataOutputStream outputStream, int[][] iA) throws IOException {
        if (iA == null) {
            IOUtil.writeInt((OutputStream)outputStream, (int)-1);
            return;
        }
        IOUtil.writeInt((OutputStream)outputStream, (int)iA.length);
        int i = 0;
        while (i < iA.length) {
            AggregationResultSetSaveUtil.writeIntArray(outputStream, iA[i]);
            ++i;
        }
    }
}

