/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;

public class DocumentObjectCache {
    private IDocumentManager documentManager = null;
    private int cachedSize;
    private LinkedList linkedList = null;
    private HashMap map = null;

    public DocumentObjectCache(IDocumentManager documentManager) {
        this(documentManager, 200);
    }

    public DocumentObjectCache(IDocumentManager documentManager, int cachedSize) {
        this.documentManager = documentManager;
        this.cachedSize = cachedSize;
        this.linkedList = new LinkedList();
        this.map = new HashMap();
    }

    public IDocumentObject getIDocumentObject(String name) throws IOException {
        IDocumentObject newDocumentObject;
        Object cachedObject = this.map.get(name);
        if (cachedObject != null) {
            return (IDocumentObject)cachedObject;
        }
        if (this.linkedList.size() >= this.cachedSize) {
            String lastName = (String)this.linkedList.getLast();
            this.linkedList.removeLast();
            ((IDocumentObject)this.map.get(lastName)).close();
            this.map.remove(lastName);
        }
        if ((newDocumentObject = this.documentManager.openDocumentObject(name)) == null) {
            newDocumentObject = this.documentManager.createDocumentObject(name);
        }
        newDocumentObject.seek(newDocumentObject.length());
        this.map.put(name, newDocumentObject);
        this.linkedList.addFirst(name);
        return newDocumentObject;
    }

    public void closeAll() throws IOException {
        Iterator allOjbects = this.map.values().iterator();
        while (allOjbects.hasNext()) {
            ((IDocumentObject)allOjbects.next()).close();
        }
    }
}

