/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.DimensionCursorImpl;
import org.eclipse.birt.data.engine.olap.cursor.DimensionNavigator;
import org.eclipse.birt.data.engine.olap.cursor.EdgeNavigator;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

class EdgeCursorImpl
extends AbstractCursorSupport
implements EdgeCursor {
    private CubeCursor pageOwner;
    private CubeCursor ordinateOwner;
    private List dimensionCursorList = new ArrayList();

    EdgeCursorImpl(BirtEdgeView view, boolean isPage, IEdgeAxis axis, CubeCursor cursor) throws OLAPException {
        super(new EdgeNavigator(axis), null);
        if (isPage) {
            this.pageOwner = cursor;
        } else {
            this.ordinateOwner = cursor;
        }
        view.setEdgeCursor(this);
        int i = view.getPageEndingIndex() + 1;
        while (i < axis.getAllDimensionAxis().length) {
            this.dimensionCursorList.add(new DimensionCursorImpl(this, axis.getDimensionAxis(i), new DimensionNavigator(axis.getDimensionAxis(i))));
            ++i;
        }
    }

    public List getDimensionCursor() throws OLAPException {
        return this.dimensionCursorList;
    }

    public CubeCursor getOrdinateOwner() throws OLAPException {
        return this.ordinateOwner;
    }

    public CubeCursor getPageOwner() throws OLAPException {
        return this.pageOwner;
    }

    public void setOrdinateOwner(CubeCursor value) throws OLAPException {
        this.ordinateOwner = value;
    }

    public void setPageOwner(CubeCursor value) throws OLAPException {
        this.pageOwner = value;
    }
}

