/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;

public class EngineExecutionHints
implements IEngineExecutionHints {
    private Set cachedDataSetNames = new HashSet();

    EngineExecutionHints() {
    }

    void populateCachedDataSets(DataEngineImpl dataEngine, IDataQueryDefinition[] queryDefns) throws DataException {
        if (queryDefns != null) {
            ArrayList temp = new ArrayList();
            int i = 0;
            while (i < queryDefns.length) {
                IQueryDefinition qd;
                String dataSetName;
                if (queryDefns[i] instanceof IQueryDefinition && (dataSetName = (qd = (IQueryDefinition)queryDefns[i]).getDataSetName()) != null) {
                    this.populateDataSetNames(dataEngine.getDataSetDesign(dataSetName), dataEngine, temp);
                }
                ++i;
            }
            HashSet tempSet = new HashSet();
            int i2 = 0;
            while (i2 < temp.size()) {
                if (tempSet.contains(temp.get(i2))) {
                    this.cachedDataSetNames.add(temp.get(i2));
                } else {
                    tempSet.add(temp.get(i2));
                }
                ++i2;
            }
        }
    }

    private void populateDataSetNames(IBaseDataSetDesign design, DataEngineImpl engine, List names) throws DataException {
        if (design == null) {
            return;
        }
        names.add(design.getName());
        if (design instanceof IJointDataSetDesign) {
            IJointDataSetDesign jointDesign = (IJointDataSetDesign)design;
            this.populateDataSetNames(engine.getDataSetDesign(jointDesign.getLeftDataSetDesignName()), engine, names);
            this.populateDataSetNames(engine.getDataSetDesign(jointDesign.getRightDataSetDesignName()), engine, names);
        }
    }

    public boolean needCacheDataSet(String dataSetName) {
        return this.cachedDataSetNames.contains(dataSetName);
    }
}

