/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SimpleResultSet
implements IResultIterator {
    private ResultSet resultSet;
    private RowResultSet rowResultSet;
    private IResultObject currResultObj;
    private IEventHandler handler;
    private int initialRowCount;
    private int rowCount;
    private StreamWrapper streamsWrapper;
    private OutputStream dataSetStream;
    private DataOutputStream dataSetLenStream;
    private long offset = 4L;
    private long rowCountOffset = 0L;
    private Set resultSetNameSet = null;
    private IBaseQueryDefinition query;

    public SimpleResultSet(DataSourceQuery dataSourceQuery, ResultSet resultSet, IResultClass resultClass, IEventHandler handler) throws DataException {
        this.rowResultSet = new RowResultSet(new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(resultSet), resultClass, false));
        this.currResultObj = this.rowResultSet.next();
        this.initialRowCount = this.currResultObj != null ? -1 : 0;
        this.rowCount = this.currResultObj != null ? 1 : 0;
        this.resultSet = resultSet;
        this.handler = handler;
        this.resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(handler.getAllColumnBindings());
        this.query = dataSourceQuery.getQueryDefinition();
        if (this.query instanceof IQueryDefinition && ((IQueryDefinition)this.query).needAutoBinding()) {
            int i = 1;
            while (i <= resultClass.getFieldCount()) {
                this.resultSetNameSet.add(resultClass.getFieldName(i));
                this.resultSetNameSet.add(resultClass.getFieldAlias(i));
                ++i;
            }
        }
    }

    public void close() throws DataException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.dataSetStream != null) {
            try {
                if (this.dataSetStream instanceof RAOutputStream) {
                    ((RAOutputStream)this.dataSetStream).seek(this.rowCountOffset);
                    IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.rowCount);
                }
                if (this.streamsWrapper.getStreamManager().hasOutStream(31, 0, 2)) {
                    OutputStream exprValueStream = this.streamsWrapper.getStreamManager().getOutStream(31, 0, 2);
                    if (exprValueStream instanceof RAOutputStream) {
                        ((RAOutputStream)exprValueStream).seek(0L);
                        IOUtil.writeInt((OutputStream)exprValueStream, (int)this.rowCount);
                    }
                    exprValueStream.close();
                }
                this.dataSetStream.close();
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            this.dataSetStream = null;
        }
        if (this.dataSetLenStream != null) {
            try {
                this.dataSetLenStream.close();
            }
            catch (Exception exception) {}
            this.dataSetLenStream = null;
        }
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        this.streamsWrapper = streamsWrapper;
        if (streamsWrapper.getStreamForGroupInfo() != null) {
            try {
                IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForGroupInfo(), (int)0);
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        if (streamsWrapper.getStreamForResultClass() != null) {
            ((ResultClass)this.getResultClass()).doSave(streamsWrapper.getStreamForResultClass(), (List<IBinding>)(this.query instanceof IQueryDefinition && ((IQueryDefinition)this.query).needAutoBinding() ? null : this.handler.getAllColumnBindings()));
        }
        try {
            streamsWrapper.getStreamForResultClass().close();
            this.dataSetStream = this.streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
            this.dataSetLenStream = streamsWrapper.getStreamForDataSetRowLens();
            if (this.dataSetStream instanceof RAOutputStream) {
                this.rowCountOffset = ((RAOutputStream)this.dataSetStream).getOffset();
            }
            IOUtil.writeInt((OutputStream)this.dataSetStream, (int)this.initialRowCount);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public void first(int groupingLevel) throws DataException {
    }

    public Object getAggrValue(String aggrName) throws DataException {
        return null;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return 0;
    }

    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObj;
    }

    public int getCurrentResultIndex() throws DataException {
        return this.rowResultSet.getIndex();
    }

    public int getEndingGroupLevel() throws DataException {
        if (this.rowResultSet.hasNext()) {
            return 1;
        }
        return 0;
    }

    public IExecutorHelper getExecutorHelper() {
        return this.handler.getExecutorHelper();
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return null;
    }

    public IResultClass getResultClass() throws DataException {
        return this.rowResultSet.getMetaData();
    }

    public ResultSetCache getResultSetCache() {
        return null;
    }

    public int getRowCount() throws DataException {
        return this.initialRowCount;
    }

    public int getStartingGroupLevel() throws DataException {
        if (this.rowResultSet.getIndex() == 0) {
            return 0;
        }
        return 1;
    }

    public void last(int groupingLevel) throws DataException {
    }

    public boolean next() throws DataException {
        if (this.streamsWrapper != null && this.currResultObj != null) {
            try {
                if (this.dataSetStream != null) {
                    int colCount = this.currResultObj.getResultClass().getFieldCount();
                    IOUtil.writeLong((DataOutputStream)this.dataSetLenStream, (long)this.offset);
                    this.offset += (long)ResultSetUtil.writeResultObject(new DataOutputStream(this.dataSetStream), this.currResultObj, colCount, this.resultSetNameSet);
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        this.currResultObj = this.rowResultSet.next();
        if (this.currResultObj != null) {
            ++this.rowCount;
        }
        return this.currResultObj != null;
    }
}

