/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;

public class TaglibClassLoader
extends URLClassLoader {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibclassloader"));
    private static final String FILE = "file:/";
    private static final String RESOURCE = "platform:/resource/";

    public TaglibClassLoader(ClassLoader parentLoader) {
        super(new URL[0], parentLoader);
    }

    public void addDirectory(String dirPath) {
        this.addJavaFile(String.valueOf(dirPath) + "/");
    }

    public void addFile(IPath filePath) {
        try {
            URL url = new URL(RESOURCE + filePath.toString());
            super.addURL(url);
            if (DEBUG) {
                System.out.println("added: [" + url + "] to classpath");
            }
        }
        catch (MalformedURLException e) {
            Logger.logException(filePath.toString(), e);
        }
    }

    public void addFolder(IPath folderPath) {
        try {
            URL url = new URL(RESOURCE + folderPath.toString() + "/");
            super.addURL(url);
            if (DEBUG) {
                System.out.println("added: [" + url + "] to classpath");
            }
        }
        catch (MalformedURLException e) {
            Logger.logException(folderPath.toString(), e);
        }
    }

    public void addJar(String filename) {
        this.addJavaFile(filename);
    }

    void addJavaFile(String filename) {
        try {
            URL url = new URL(FILE + filename);
            super.addURL(url);
            if (DEBUG) {
                System.out.println("added: [" + url + "] to classpath");
            }
        }
        catch (MalformedURLException e) {
            Logger.logException(filename, e);
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        if (DEBUG) {
            System.out.println("finding: [" + className + "]");
        }
        return super.findClass(className);
    }
}

