/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.swt.custom;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

class TextCanvas
extends Canvas
implements PaintListener,
FocusListener {
    private String text;
    private Font textFont;
    private boolean isFocusIn = false;

    public TextCanvas(Composite parent, int iStyle, String text) {
        super(parent, iStyle);
        this.text = text;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = this.getDisplay().getSystemColor(24);
            cBackground = this.getDisplay().getSystemColor(25);
        } else {
            cForeground = this.getDisplay().getSystemColor(16);
            cBackground = this.getDisplay().getSystemColor(22);
        }
        GC gc = pe.gc;
        if (this.isFocusIn) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            gc.setBackground(cBackground);
            gc.setForeground(cForeground);
        }
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        if (this.textFont != null) {
            gc.setFont(this.textFont);
        }
        if (this.text != null) {
            gc.drawText(this.text, 2, 2);
        }
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }
}

