/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.HashMap;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TabbedPropertyTitle
extends Composite
implements IPropertyChangeListener {
    private CLabel label;
    private Image image = null;
    private String text = null;
    private static final String BLANK = "";
    public int marginWidth = 4;
    public int marginHeight = 4;
    private FormWidgetFactory factory;
    private ToolBar toolbar;
    private HashMap actionMap = new HashMap();
    private Listener toolItemListener;
    private LocalResourceManager imageManager;
    private Color bg;
    private Color gbg;
    private Color border;

    public TabbedPropertyTitle(Composite parent, FormWidgetFactory factory) {
        super(parent, 0);
        this.factory = factory;
        this.bg = factory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.gbg = factory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.border = factory.getColors().getColor("org.eclipse.ui.forms.TB_BORDER");
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TabbedPropertyTitle.this.image == null && (TabbedPropertyTitle.this.text == null || TabbedPropertyTitle.this.text.equals(TabbedPropertyTitle.BLANK))) {
                    TabbedPropertyTitle.this.label.setVisible(false);
                } else {
                    TabbedPropertyTitle.this.label.setVisible(true);
                    TabbedPropertyTitle.this.drawTitleBackground(e);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (TabbedPropertyTitle.this.toolbar != null) {
                    TabbedPropertyTitle.this.toolbar.setFocus();
                } else {
                    TabbedPropertyTitle.this.getParent().setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        factory.getColors().initializeSectionToolBarColors();
        this.setBackground(factory.getColors().getBackground());
        this.setForeground(factory.getColors().getForeground());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 11;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.label = new CLabel(this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point p = super.computeSize(wHint, hHint, changed);
                p.y += 2;
                return p;
            }
        };
        this.label.setBackground(parent.getBackground());
        this.label.setText(BLANK);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        this.label.setLayout((Layout)gl);
        this.label.setBackground(new Color[]{factory.getColors().getColor("org.eclipse.ui.forms.TB_BG"), factory.getColors().getColor("org.eclipse.ui.forms.TB_BG")}, new int[]{100}, true);
        this.label.setFont(JFaceResources.getBannerFont());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
    }

    public void showResetButton(boolean show) {
    }

    protected void drawTitleBackground(PaintEvent e) {
        Rectangle bounds = this.getClientArea();
        Object tsize = null;
        Point labelSize = null;
        int twidth = bounds.width - this.marginWidth - this.marginWidth;
        if (this.label != null) {
            labelSize = this.label.computeSize(-1, -1, true);
        }
        if (labelSize != null) {
            twidth -= labelSize.x + 4;
        }
        int tvmargin = 4;
        int theight = this.getHeight();
        if (labelSize != null) {
            theight = Math.max(theight, labelSize.y);
        }
        int midpoint = (theight += tvmargin + tvmargin) * 66 / 100;
        int rem = theight - midpoint;
        GC gc = e.gc;
        gc.setForeground(this.bg);
        gc.setBackground(this.gbg);
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight, bounds.width - 1 - this.marginWidth - this.marginWidth, midpoint - 1, true);
        gc.setForeground(this.gbg);
        gc.setBackground(this.getBackground());
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight + midpoint - 1, bounds.width - 1 - this.marginWidth - this.marginWidth, rem - 1, true);
        gc.setForeground(this.border);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth, this.marginHeight + theight - 1);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
        gc.drawLine(this.marginWidth + 2, this.marginHeight, bounds.width - this.marginWidth - 3, this.marginHeight);
        gc.drawLine(bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2);
        gc.drawLine(bounds.width - this.marginWidth - 1, this.marginHeight + 2, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
    }

    public void setTitle(String text, Image image) {
        this.text = text;
        this.image = image;
        if (text != null) {
            this.label.setText(text);
        } else {
            this.label.setText(BLANK);
        }
        this.label.setImage(image);
        this.redraw();
    }

    public int getHeight() {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(this.getFont());
        Point point = gc.textExtent(BLANK);
        ++point.x;
        int textOrImageHeight = Math.max(point.x, 16);
        gc.dispose();
        shell.dispose();
        return textOrImageHeight + 8;
    }

    public void setActions(IAction[] actions) {
        if (actions != null) {
            if (this.toolbar != null) {
                while (this.toolbar.getItemCount() > 0) {
                    ToolItem item = this.toolbar.getItem(0);
                    IAction action = (IAction)this.actionMap.get(item);
                    if (action != null) {
                        action.removePropertyChangeListener((IPropertyChangeListener)this);
                    }
                    item.dispose();
                }
                this.actionMap.clear();
                this.toolbar.dispose();
            }
            this.toolbar = new ToolBar((Composite)this.label, 0x800000);
            this.toolbar.setBackground(this.gbg);
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 0x1000008;
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 0x1000000;
            this.toolbar.setLayoutData((Object)gd);
            int i = 0;
            while (i < actions.length) {
                IAction action = actions[i];
                int flags = 8;
                if (action != null) {
                    int style = action.getStyle();
                    if (style == 2) {
                        flags = 32;
                    } else if (style == 8) {
                        flags = 16;
                    } else if (style == 4) {
                        flags = 4;
                    }
                }
                ToolItem item = new ToolItem(this.toolbar, flags);
                item.addListener(13, this.getToolItemListener());
                action.addPropertyChangeListener((IPropertyChangeListener)this);
                this.actionMap.put(item, action);
                ++i;
            }
            this.updateToolBar();
            this.label.layout();
        } else if (this.toolbar != null) {
            this.toolbar.dispose();
            this.toolbar = null;
        }
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            TabbedPropertyTitle.this.handleWidgetSelection(event, (ToolItem)ew);
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void handleWidgetSelection(Event e, ToolItem item) {
        boolean selection = item.getSelection();
        int style = item.getStyle();
        IAction action = (IAction)this.actionMap.get(item);
        if ((style & 0x22) != 0) {
            if (action.getStyle() == 2) {
                action.setChecked(selection);
            }
        } else if ((style & 0x10) != 0) {
            if (action.getStyle() == 8) {
                action.setChecked(selection);
            }
        } else if ((style & 4) != 0 && e.detail == 4 && action.getStyle() == 4) {
            Menu m;
            IMenuCreator mc = action.getMenuCreator();
            ToolItem ti = item;
            if (mc != null && (m = mc.getMenu((Control)ti.getParent())) != null) {
                Point point = ti.getParent().toDisplay(new Point(e.x, e.y));
                m.setLocation(point.x, point.y);
                m.setVisible(true);
                return;
            }
        }
        action.runWithEvent(e);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateToolBar();
    }

    private void updateToolBar() {
        if (this.toolbar != null) {
            ResourceManager parentResourceManager = JFaceResources.getResources();
            LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
            int i = 0;
            while (i < this.toolbar.getItemCount()) {
                ToolItem item = this.toolbar.getItem(i);
                IAction action = (IAction)this.actionMap.get(item);
                if (action != null) {
                    ImageDescriptor image = null;
                    if (action.isEnabled() && action.getImageDescriptor() != null) {
                        image = action.getImageDescriptor();
                    } else if (action.isEnabled() && action.getImageDescriptor() != null) {
                        image = action.getDisabledImageDescriptor();
                    }
                    if (image != null) {
                        item.setImage(localManager.createImageWithDefault(image));
                    }
                    item.setToolTipText(action.getToolTipText());
                    if (2 == action.getStyle()) {
                        item.setSelection(action.isChecked());
                    }
                }
                ++i;
            }
            this.disposeOldImages();
            this.imageManager = localManager;
            if (this.toolbar.isFocusControl()) {
                this.toolbar.setFocus();
            }
        }
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeOldImages();
    }
}

