/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import org.eclipse.birt.report.designer.data.ui.property.AbstractPropertyDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractTitlePropertyDialog
extends AbstractPropertyDialog {
    private RGB titleAreaRGB;
    Color titleAreaColor;
    private Label titleLabel;
    private Label titleImageLabel;
    private Image titleImage;
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    private Label messageImageLabel;
    private Text messageLabel;
    private int messageLabelHeight;
    private Label leftFillerLabel;
    private String errorMessage;
    private boolean showingError = false;
    private String message = "";
    private Image messageImage;
    private static final int H_GAP_IMAGE = 5;
    private boolean titleImageLargest = true;
    private Composite titleArea;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        if (reg.get(DLG_IMG_TITLE_BANNER) == null) {
            reg.put(DLG_IMG_TITLE_BANNER, ImageDescriptor.createFromFile(TitleAreaDialog.class, (String)"images/title_banner.gif"));
        }
    }

    public AbstractTitlePropertyDialog(Shell parentShell, Object model) {
        super(parentShell, model);
    }

    protected Control createDialogArea(Composite parent) {
        this.createDialogTitleArea(parent);
        return super.createDialogArea(parent);
    }

    private void createDialogTitleArea(Composite parent) {
        Color foreground;
        Color background;
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.titleArea = new Composite(contents, 0);
        this.initializeDialogUnits((Control)this.titleArea);
        FormData titleAreaData = new FormData();
        titleAreaData.top = new FormAttachment(0, 0);
        titleAreaData.left = new FormAttachment(0, 0);
        titleAreaData.right = new FormAttachment(100, 0);
        this.titleArea.setLayoutData((Object)titleAreaData);
        layout = new FormLayout();
        this.titleArea.setLayout((Layout)layout);
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractTitlePropertyDialog.this.titleAreaColor != null) {
                    AbstractTitlePropertyDialog.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = this.titleArea.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.titleArea.setBackground(background);
        this.titleImageLabel = new Label(this.titleArea, 0x1000000);
        this.titleImageLabel.setBackground(background);
        if (this.titleImage == null || this.titleImage.isDisposed()) {
            this.titleImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_BANNER));
        } else {
            this.titleImageLabel.setImage(this.titleImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)imageData);
        this.titleLabel = new Label(this.titleArea, 16384);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleImageLabel);
        titleData.left = new FormAttachment(0, horizontalSpacing);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(this.titleArea, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text(this.titleArea, 72);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(this.titleArea, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
        } else {
            String displayedErrorMessage = " " + this.errorMessage;
            this.updateMessage(displayedErrorMessage);
            if (!this.showingError) {
                this.showingError = true;
                this.messageImageLabel.setImage(JFaceResources.getImage((String)DLG_IMG_TITLE_ERROR));
                this.setImageLabelVisible(true);
            }
        }
        this.layoutForNewMessage();
    }

    private void updateMessage(String newMessage) {
        this.messageLabel.setText(newMessage);
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    public void setTitleMessage(String message) {
        if (this.messageLabel != null) {
            this.messageLabel.setText(message);
            this.layoutForNewMessage();
        }
    }

    public void setTitleTitle(String title) {
        if (this.titleLabel != null) {
            this.titleLabel.setText(title);
            this.layoutForNewMessage();
        }
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData imageLabelData = new FormData();
        imageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        imageLabelData.left = new FormAttachment((Control)this.leftFillerLabel);
        imageLabelData.right = new FormAttachment((Control)this.messageLabel);
        this.messageImageLabel.setLayoutData((Object)imageLabelData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.titleLabel, 0, 128);
        data.left = new FormAttachment(0, 5);
        data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    public boolean isTitleImageLargest() {
        return this.titleImageLargest;
    }

    public void setTitleImageLargest(boolean titleImageLargest) {
        this.titleImageLargest = titleImageLargest;
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public void setTitleImage(Image titleImage) {
        this.titleImage = titleImage;
    }

    private void layoutForNewMessage() {
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        if (this.errorMessage == null && this.messageImage == null) {
            this.setImageLabelVisible(false);
            this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        } else {
            this.messageImageLabel.setVisible(true);
            this.leftFillerLabel.setVisible(true);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            this.messageImageLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0, 131072);
            data = new FormData();
            data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
            data.left = new FormAttachment(0, 0);
            data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
            data.right = new FormAttachment((Control)this.messageImageLabel, 0);
            this.leftFillerLabel.setLayoutData((Object)data);
            FormData messageLabelData = new FormData();
            messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
            messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
            messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, 0);
            messageLabelData.height = this.messageLabelHeight;
            if (this.titleImageLargest) {
                messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
            }
            this.messageLabel.setLayoutData((Object)messageLabelData);
        }
        if (this.dialogArea != null) {
            this.titleArea.getParent().layout(true);
            this.titleArea.layout(true);
        }
    }
}

