/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphEvent;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraphListener;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphImpl
implements IDependencyGraph {
    private Object graphLock = new Object();
    private Map<IProject, Set<IProject>> graph = null;
    private long modStamp = 0L;
    private Map<String, Object> referenceOptions = new HashMap<String, Object>();
    private ListenerList listeners = new ListenerList();
    private static DependencyGraphImpl instance = null;
    private DependencyGraphResourceChangedListener listener = null;
    public static final Object GRAPH_UPDATE_JOB_FAMILY = new Object();
    private static final int JOB_DELAY = 100;
    private final GraphUpdateJob graphUpdateJob = new GraphUpdateJob();
    private final Object jobLock = new Object();
    private int pauseCount = 0;

    static IDependencyGraph getInstance() {
        if (instance == null) {
            instance = new DependencyGraphImpl();
            instance.initGraph();
        }
        return instance;
    }

    private DependencyGraphImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModStamp() {
        Object object = this.graphLock;
        synchronized (object) {
            return this.modStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProject> getReferencingComponents(IProject targetProject) {
        this.waitForAllUpdates(null);
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> set = this.graph.get(targetProject);
            if (set == null) {
                return Collections.EMPTY_SET;
            }
            Iterator<IProject> iterator = set.iterator();
            while (iterator.hasNext()) {
                IProject project = iterator.next();
                if (project.isAccessible()) continue;
                iterator.remove();
            }
            HashSet<IProject> copy = new HashSet<IProject>();
            copy.addAll(set);
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph() {
        Object object = this.graphLock;
        synchronized (object) {
            this.referenceOptions.put("GET_JAVA_REFS", Boolean.FALSE);
            try {
                this.preUpdate();
                this.graph = new HashMap<IProject, Set<IProject>>();
                this.listener = new DependencyGraphResourceChangedListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
                this.initAll();
            }
            finally {
                this.postUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAll() {
        Object object = this.graphLock;
        synchronized (object) {
            try {
                IProject[] allProjects;
                this.preUpdate();
                IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject sourceProject = iProjectArray[n2];
                    this.queueProjectAdded(sourceProject);
                    ++n2;
                }
            }
            finally {
                this.postUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllReferences(IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            boolean removed = false;
            Set<IProject> removedSet = this.graph.remove(targetProject);
            if (removedSet != null && !removedSet.isEmpty()) {
                removed = true;
                Iterator<Map.Entry<IProject, Set<IProject>>> iterator = removedSet.iterator();
                while (iterator.hasNext()) {
                    event.removeReference((IProject)iterator.next(), targetProject);
                }
            }
            for (Map.Entry<IProject, Set<IProject>> entry : this.graph.entrySet()) {
                if (entry.getValue().isEmpty() || !entry.getValue().remove(targetProject)) continue;
                removed = true;
                event.removeReference(targetProject, entry.getKey());
            }
            if (removed) {
                ++this.modStamp;
                event.setModStamp(this.modStamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference(IProject sourceProject, IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects != null && referencingProjects.remove(sourceProject)) {
                event.removeReference(sourceProject, targetProject);
                ++this.modStamp;
                event.setModStamp(this.modStamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference(IProject sourceProject, IProject targetProject, DependencyGraphEvent event) {
        Object object = this.graphLock;
        synchronized (object) {
            boolean added;
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects == null) {
                referencingProjects = new HashSet<IProject>();
                this.graph.put(targetProject, referencingProjects);
            }
            if (added = referencingProjects.add(sourceProject)) {
                event.addRefererence(sourceProject, targetProject);
                ++this.modStamp;
                event.setModStamp(this.modStamp);
            }
        }
    }

    @Override
    public void addListener(IDependencyGraphListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IDependencyGraphListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void queueProjectAdded(IProject project) {
        this.update(project, 1);
    }

    public void queueProjectDeleted(IProject project) {
        this.update(project, 2);
    }

    @Override
    public void update(IProject project) {
        this.update(project, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IProject project, int updateType) {
        switch (updateType) {
            case 0: {
                this.graphUpdateJob.queueProjectUpdated(project);
                break;
            }
            case 1: {
                this.graphUpdateJob.queueProjectAdded(project);
                break;
            }
            case 2: {
                this.graphUpdateJob.queueProjectDeleted(project);
            }
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.graphUpdateJob.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            ++this.pauseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.graphUpdateJob.schedule(100L);
    }

    public void waitForAllUpdates(IProgressMonitor monitor) {
        block9: {
            Thread graphUpdateThread = this.graphUpdateJob.getThread();
            if (graphUpdateThread != null && graphUpdateThread != Thread.currentThread()) {
                try {
                    if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                        IJobManager manager = Job.getJobManager();
                        Job job = manager.currentJob();
                        if (job != null && job.getRule() == null) {
                            try {
                                manager.beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
                                this.graphUpdateJob.join();
                                break block9;
                            }
                            finally {
                                manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                            }
                        }
                        this.graphUpdateJob.join();
                        break block9;
                    }
                    this.graphUpdateJob.join();
                }
                catch (InterruptedException e) {
                    ModulecorePlugin.logError(e);
                }
            }
        }
        if (this.graphUpdateJob.shouldSchedule()) {
            this.graphUpdateJob.run(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.graphLock;
        synchronized (object) {
            StringBuffer buff = new StringBuffer("Dependency Graph:\n{\n");
            for (Map.Entry<IProject, Set<IProject>> entry : this.graph.entrySet()) {
                buff.append("  " + entry.getKey().getName() + " -> {");
                Iterator<IProject> mappedProjects = entry.getValue().iterator();
                while (mappedProjects.hasNext()) {
                    buff.append(mappedProjects.next().getName());
                    if (!mappedProjects.hasNext()) continue;
                    buff.append(", ");
                }
                buff.append("}\n");
            }
            buff.append("}");
            return buff.toString();
        }
    }

    private class DependencyGraphResourceChangedListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private DependencyGraphResourceChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                try {
                    DependencyGraphImpl.this.preUpdate();
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    ModulecorePlugin.logError(e);
                    DependencyGraphImpl.this.postUpdate();
                }
            }
            finally {
                DependencyGraphImpl.this.postUpdate();
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    int kind = delta.getKind();
                    if ((1 & kind) != 0) {
                        DependencyGraphImpl.this.queueProjectAdded((IProject)resource);
                        return false;
                    }
                    if ((2 & kind) != 0) {
                        DependencyGraphImpl.this.queueProjectDeleted((IProject)resource);
                        return false;
                    }
                    if ((4 & kind) != 0) {
                        int flags = delta.getFlags();
                        if ((0x4000 & flags) != 0) {
                            boolean isOpen = ((IProject)resource).isOpen();
                            if (isOpen) {
                                DependencyGraphImpl.this.queueProjectAdded((IProject)resource);
                            } else {
                                DependencyGraphImpl.this.queueProjectDeleted((IProject)resource);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return resource.getName().equals(".settings");
                }
                case 1: {
                    String name = resource.getName();
                    if (!name.equals("org.eclipse.wst.common.component")) break;
                    DependencyGraphImpl.this.update(resource.getProject());
                }
            }
            return false;
        }
    }

    private class GraphUpdateJob
    extends Job {
        private Queue projectsAdded;
        private Queue projectsRemoved;
        private Queue projectsUpdated;

        public GraphUpdateJob() {
            super("Graph Update Job");
            this.projectsAdded = new Queue();
            this.projectsRemoved = new Queue();
            this.projectsUpdated = new Queue();
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            if (family == GRAPH_UPDATE_JOB_FAMILY) {
                return true;
            }
            return super.belongsTo(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectAdded(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsAdded.add(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectDeleted(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsRemoved.add(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectUpdated(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsUpdated.add(project);
        }

        public boolean shouldSchedule() {
            boolean isEmpty = this.projectsAdded.isEmpty() && this.projectsRemoved.isEmpty() && this.projectsUpdated.isEmpty();
            return !isEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            final DependencyGraphEvent event = new DependencyGraphEvent();
            final Object[] removed = this.projectsRemoved.getListeners();
            final Object[] updated = this.projectsUpdated.getListeners();
            final Object[] added = this.projectsAdded.getListeners();
            if (removed.length == 0 && updated.length == 0 && added.length == 0) {
                return Status.OK_STATUS;
            }
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    ModulecorePlugin.logError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    IProject[] allProjects;
                    int n;
                    Object object = DependencyGraphImpl.this.graphLock;
                    synchronized (object) {
                        Object[] objectArray = removed;
                        n = removed.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            IProject project = (IProject)o;
                            DependencyGraphImpl.this.removeAllReferences(project, event);
                            ++n2;
                        }
                    }
                    if (added.length > 0) {
                        allProjects = null;
                        int state = ResourcesPlugin.getPlugin().getBundle().getState();
                        if (state != 32) {
                            return;
                        }
                        allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        IProject[] iProjectArray = allProjects;
                        int n3 = allProjects.length;
                        n = 0;
                        while (n < n3) {
                            IProject sourceProject = iProjectArray[n];
                            IVirtualComponent component = ComponentCore.createComponent(sourceProject);
                            if (component != null) {
                                IVirtualReference[] references = null;
                                references = DependencyGraphImpl.this.referenceOptions != null && component instanceof VirtualComponent ? ((VirtualComponent)component).getReferences(DependencyGraphImpl.this.referenceOptions) : component.getReferences();
                                IVirtualReference[] iVirtualReferenceArray = references;
                                int n4 = references.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    IProject targetProject;
                                    IVirtualReference ref = iVirtualReferenceArray[n5];
                                    IVirtualComponent targetComponent = ref.getReferencedComponent();
                                    if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                        DependencyGraphImpl.this.addReference(sourceProject, targetProject, event);
                                    }
                                    ++n5;
                                }
                            }
                            ++n;
                        }
                    } else if (updated.length > 0) {
                        allProjects = null;
                        int state = ResourcesPlugin.getPlugin().getBundle().getState();
                        if (state != 32) {
                            return;
                        }
                        allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        HashSet<IProject> validRefs = new HashSet<IProject>();
                        Object[] objectArray = updated;
                        int n6 = updated.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            Object o = objectArray[n7];
                            IProject sourceProject = (IProject)o;
                            IVirtualComponent component = ComponentCore.createComponent(sourceProject);
                            if (component != null) {
                                validRefs.clear();
                                IVirtualReference[] references = null;
                                references = DependencyGraphImpl.this.referenceOptions != null && component instanceof VirtualComponent ? ((VirtualComponent)component).getReferences(DependencyGraphImpl.this.referenceOptions) : component.getReferences();
                                IVirtualReference[] iVirtualReferenceArray = references;
                                int n8 = references.length;
                                int n9 = 0;
                                while (n9 < n8) {
                                    IProject targetProject;
                                    IVirtualReference ref = iVirtualReferenceArray[n9];
                                    IVirtualComponent targetComponent = ref.getReferencedComponent();
                                    if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                        validRefs.add(targetProject);
                                    }
                                    ++n9;
                                }
                                Object object2 = DependencyGraphImpl.this.graphLock;
                                synchronized (object2) {
                                    IProject[] iProjectArray = allProjects;
                                    int n10 = allProjects.length;
                                    n8 = 0;
                                    while (n8 < n10) {
                                        IProject targetProject = iProjectArray[n8];
                                        if (validRefs.remove(targetProject)) {
                                            DependencyGraphImpl.this.addReference(sourceProject, targetProject, event);
                                        } else {
                                            DependencyGraphImpl.this.removeReference(sourceProject, targetProject, event);
                                        }
                                        ++n8;
                                    }
                                }
                            } else {
                                DependencyGraphImpl.this.removeAllReferences(sourceProject, event);
                            }
                            ++n7;
                        }
                    }
                    boolean scheduleUpdate = false;
                    Object state = DependencyGraphImpl.this.graphLock;
                    synchronized (state) {
                        if (DependencyGraphImpl.this.referenceOptions != null) {
                            scheduleUpdate = true;
                            DependencyGraphImpl.this.referenceOptions = null;
                        }
                    }
                    if (scheduleUpdate) {
                        DependencyGraphImpl.this.initAll();
                    }
                    Job notificationJob = new Job("Graph Update Notification Job"){

                        protected IStatus run(final IProgressMonitor monitor) {
                            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                public void run() throws Exception {
                                    Object[] objectArray = DependencyGraphImpl.this.listeners.getListeners();
                                    int n = objectArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object listener = objectArray[n2];
                                        ((IDependencyGraphListener)listener).dependencyGraphUpdate(event);
                                        ++n2;
                                    }
                                    monitor.done();
                                }

                                public void handleException(Throwable exception) {
                                    ModulecorePlugin.logError(exception);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    notificationJob.setSystem(true);
                    notificationJob.setRule(null);
                    notificationJob.schedule();
                }
            });
            return Status.OK_STATUS;
        }

        private class Queue
        extends ListenerList {
            private Queue() {
            }

            public synchronized Object[] getListeners() {
                Object[] data = super.getListeners();
                this.clear();
                return data;
            }

            public synchronized boolean isEmpty() {
                return super.isEmpty();
            }
        }
    }
}

