/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Stack;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class XMLWriter {
    private int lineCounter = 1;
    protected boolean markLineNumber = true;
    protected static final String OUTPUT_ENCODING = "UTF-8";
    protected PrintStream out = null;
    protected Stack<String> elementStack = new Stack();
    protected boolean elementActive = false;
    private int attrCount = 0;
    protected Stack<String> pendingElementStack = new Stack();

    protected XMLWriter() {
    }

    public XMLWriter(File outputFile, String signature) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        this.out = new PrintStream((OutputStream)stream, false, OUTPUT_ENCODING);
        this.init(signature);
    }

    public XMLWriter(File outputFile, String signature, boolean needMarkLineNumber) throws IOException {
        FileOutputStream stream = new FileOutputStream(outputFile);
        this.out = new PrintStream((OutputStream)stream, false, OUTPUT_ENCODING);
        this.init(signature);
        this.markLineNumber = needMarkLineNumber;
    }

    public XMLWriter(OutputStream os, String signature) throws IOException {
        this.out = new PrintStream(os, false, OUTPUT_ENCODING);
        this.init(signature);
    }

    public XMLWriter(OutputStream os, String signature, boolean needMarkLineNumber) throws IOException {
        this.out = new PrintStream(os, false, OUTPUT_ENCODING);
        this.markLineNumber = needMarkLineNumber;
        this.init(signature);
    }

    private void init(String signature) {
        this.writeUTFSignature(signature);
        this.out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.printLine();
    }

    protected final void writeUTFSignature(String signature) {
        if (OUTPUT_ENCODING.equals(signature)) {
            this.out.write(239);
            this.out.write(187);
            this.out.write(191);
        }
        if ("UnicodeBig".equals(signature)) {
            this.out.write(254);
            this.out.write(255);
        }
        if ("UnicodeLittle".equals(signature)) {
            this.out.write(255);
            this.out.write(254);
        }
        if ("UCS-4Big".equals(signature)) {
            this.out.write(0);
            this.out.write(0);
            this.out.write(254);
            this.out.write(255);
        }
        if ("UnicodeLittle".equals(signature)) {
            this.out.write(0);
            this.out.write(0);
            this.out.write(255);
            this.out.write(254);
        }
    }

    public final void close() {
        assert (this.elementStack.size() == 0);
        this.out.close();
        this.out = null;
    }

    public final void startElement(String tagName) {
        this.flushPendingElements();
        this.closeTag();
        this.emitStartTag(tagName);
    }

    protected void emitStartTag(String tagName) {
        this.elementStack.push(tagName);
        this.elementActive = true;
        this.out.print("<");
        this.out.print(tagName);
        this.attrCount = 0;
    }

    protected void checkAttribute() {
        this.flushPendingElements();
        if (this.attrCount++ == 3) {
            this.printLine();
            this.attrCount = 0;
        }
    }

    protected final void flushPendingElements() {
        while (!this.pendingElementStack.isEmpty()) {
            this.closeTag();
            this.emitStartTag((String)this.pendingElementStack.remove(0));
        }
    }

    public void attribute(String attrName, String value) {
        if (value == null) {
            return;
        }
        this.checkAttribute();
        assert (this.elementActive);
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
            } else if (c == '<') {
                this.out.print("&lt;");
            } else if (c == '\"') {
                this.out.print("&quot;");
            } else if (c < ' ') {
                this.out.print("&#x");
                this.out.print(Integer.toHexString(c));
                this.out.print(';');
            } else if (c == '\n') {
                this.printLine();
            } else {
                this.out.print(c);
            }
            ++i;
        }
        this.out.print("\"");
    }

    public final void attribute(String attrName, int value) {
        assert (this.elementActive);
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
    }

    public final void attribute(String attrName, double value) {
        assert (this.elementActive);
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value);
        this.out.print("\"");
    }

    public final void attribute(String attrName, boolean value) {
        assert (this.elementActive);
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(value ? "true" : "false");
        this.out.print("\"");
    }

    public void endElement() {
        if (!this.pendingElementStack.isEmpty()) {
            this.pendingElementStack.pop();
            return;
        }
        assert (this.elementStack.size() > 0);
        String tagName = this.elementStack.pop();
        if (this.elementActive) {
            this.out.print("/>");
            this.printLine();
        } else {
            this.out.print("</");
            this.out.print(tagName);
            this.out.print(">");
            this.printLine();
        }
        this.elementActive = false;
    }

    public void text(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
            } else if (c == '<') {
                this.out.print("&lt;");
            } else if (c == '>') {
                if (i - 2 >= 0 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                    this.out.print("&gt;");
                } else {
                    this.out.print(c);
                }
            } else if (c == '\n') {
                this.printLine();
            } else if (c == '\r') {
                this.out.print("&#13;");
            } else {
                this.out.print(c);
            }
            ++i;
        }
    }

    public void textCDATA(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        this.out.print("<![CDATA[");
        if (!this.markLineNumber) {
            this.out.print(text);
        } else {
            int len = text.length();
            int i = 0;
            while (i < len) {
                char c = text.charAt(i);
                if (c == '\n') {
                    this.printLine();
                } else {
                    this.out.print(c);
                }
                ++i;
            }
        }
        this.out.print("]]>");
    }

    public void literal(String text) {
        if (!this.markLineNumber) {
            this.out.print(text);
            return;
        }
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '\n') {
                this.printLine();
            } else {
                this.out.print(c);
            }
            ++i;
        }
    }

    private void closeTag() {
        if (!this.elementActive) {
            return;
        }
        this.elementActive = false;
        this.out.print(">");
        this.printLine();
    }

    protected final void closeTextTag() {
        if (!this.elementActive) {
            return;
        }
        this.elementActive = false;
        this.out.print(">");
    }

    public final void taggedText(String tag, String text) {
        if (text == null) {
            return;
        }
        this.startElement(tag);
        this.text(text);
        this.endElement();
    }

    public final void conditionalStartElement(String element) {
        this.pendingElementStack.push(element);
    }

    public final void rgbAttribute(String attrName, int rgb) {
        assert (this.elementActive);
        this.checkAttribute();
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        this.out.print(StringUtil.toRgbText(rgb));
        this.out.print("\"");
    }

    public final int getLineCounter() {
        return this.lineCounter;
    }

    public void indentLongText(String text) {
        this.text(text);
    }

    protected void printLine() {
        this.out.print('\n');
        if (this.markLineNumber) {
            ++this.lineCounter;
        }
    }
}

