/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.regex.Pattern;

public class CssPropertyUtil {
    public static final String WRONG_URL = "URL(-1)";
    private static final String URL_CSS_PATTERN_1 = "[uU][rR][lL][(][\\s]*[\\w%.\\*\\-\\/:]*[\\s]*[)]";
    private static Pattern cssURLPattern_1 = Pattern.compile("[uU][rR][lL][(][\\s]*[\\w%.\\*\\-\\/:]*[\\s]*[)]");
    private static final String URL_CSS_PATTERN_2 = "[uU][rR][lL][(][\\s]*['\"][\\s]*[\\w%.\\*\\-\\/:]*[\\s]*['\"][\\s]*[)]";
    private static Pattern cssURLPattern_2 = Pattern.compile("[uU][rR][lL][(][\\s]*['\"][\\s]*[\\w%.\\*\\-\\/:]*[\\s]*['\"][\\s]*[)]");

    public static final String getPropertyName(String cssPropertyName) {
        if (cssPropertyName == null) {
            return null;
        }
        String name = cssPropertyName.toLowerCase();
        if ("font-family".equals(name)) {
            return "fontFamily";
        }
        if ("font-size".equals(name)) {
            return "fontSize";
        }
        if ("font-style".equals(name)) {
            return "fontStyle";
        }
        if ("font-variant".equals(name)) {
            return "fontVariant";
        }
        if ("font-weight".equals(name)) {
            return "fontWeight";
        }
        if ("text-align".equals(name)) {
            return "textAlign";
        }
        if ("text-indent".equals(name)) {
            return "textIndent";
        }
        if ("letter-spacing".equals(name)) {
            return "letterSpacing";
        }
        if ("word-spacing".equals(name)) {
            return "wordSpacing";
        }
        if ("text-transform".equals(name)) {
            return "textTransform";
        }
        if ("white-space".equals(name)) {
            return "whiteSpace";
        }
        if ("margin-top".equals(name)) {
            return "marginTop";
        }
        if ("margin-right".equals(name)) {
            return "marginRight";
        }
        if ("margin-bottom".equals(name)) {
            return "marginBottom";
        }
        if ("margin-left".equals(name)) {
            return "marginLeft";
        }
        if ("padding-top".equals(name)) {
            return "paddingTop";
        }
        if ("padding-right".equals(name)) {
            return "paddingRight";
        }
        if ("padding-bottom".equals(name)) {
            return "paddingBottom";
        }
        if ("padding-left".equals(name)) {
            return "paddingLeft";
        }
        if ("color".equals(name)) {
            return "color";
        }
        if ("background-color".equals(name)) {
            return "backgroundColor";
        }
        if ("background-image".equals(name)) {
            return "backgroundImage";
        }
        if ("background-repeat".equals(name)) {
            return "backgroundRepeat";
        }
        if ("background-attachment".equals(name)) {
            return "backgroundAttachment";
        }
        if ("orphans".equals(name)) {
            return "orphans";
        }
        if ("widows".equals(name)) {
            return "widows";
        }
        if ("display".equals(name)) {
            return "display";
        }
        if ("page-break-before".equals(name)) {
            return "pageBreakBefore";
        }
        if ("page-break-after".equals(name)) {
            return "pageBreakAfter";
        }
        if ("page-break-inside".equals(name)) {
            return "pageBreakInside";
        }
        if ("vertical-align".equals(name)) {
            return "verticalAlign";
        }
        if ("line-height".equals(name)) {
            return "lineHeight";
        }
        if ("border-bottom-color".equals(name)) {
            return "borderBottomColor";
        }
        if ("border-bottom-style".equals(name)) {
            return "borderBottomStyle";
        }
        if ("border-bottom-width".equals(name)) {
            return "borderBottomWidth";
        }
        if ("border-left-color".equals(name)) {
            return "borderLeftColor";
        }
        if ("border-left-style".equals(name)) {
            return "borderLeftStyle";
        }
        if ("border-left-width".equals(name)) {
            return "borderLeftWidth";
        }
        if ("border-right-color".equals(name)) {
            return "borderRightColor";
        }
        if ("border-right-style".equals(name)) {
            return "borderRightStyle";
        }
        if ("border-right-width".equals(name)) {
            return "borderRightWidth";
        }
        if ("border-top-color".equals(name)) {
            return "borderTopColor";
        }
        if ("border-top-style".equals(name)) {
            return "borderTopStyle";
        }
        if ("border-top-width".equals(name)) {
            return "borderTopWidth";
        }
        if ("direction".equals(name)) {
            return "bidiTextDirection";
        }
        return null;
    }

    public static String getURLValue(String cssValue) {
        if (cssValue == null) {
            return null;
        }
        if (cssURLPattern_1.matcher(cssValue).matches()) {
            int start = cssValue.indexOf(40);
            int end = cssValue.indexOf(41);
            String value = cssValue.substring(start + 1, end).trim();
            return value;
        }
        if (cssURLPattern_2.matcher(cssValue).matches()) {
            int start = cssValue.indexOf(40);
            int end = cssValue.indexOf(41);
            String value = cssValue.substring(start + 1, end).trim();
            int length = value.length();
            value = value.substring(1, length - 1);
            value = value.trim();
            return value;
        }
        return WRONG_URL;
    }
}

