/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencable;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefPropertyType;
import org.eclipse.birt.report.model.metadata.StructRefValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferencableStructure
extends Structure
implements IReferencable {
    public static final String LIB_REFERENCE_MEMBER = "libReference";
    protected ArrayList<BackRef> clients = new ArrayList();
    protected StructRefValue libReference = null;
    protected ArrayList<Structure> clientStructures = new ArrayList();

    @Override
    public boolean isReferencable() {
        return true;
    }

    @Override
    public void addClient(DesignElement client, String propName) {
        this.clients.add(new BackRef(client, propName));
    }

    @Override
    public void dropClient(DesignElement client) {
        int i = 0;
        while (i < this.clients.size()) {
            if (this.clients.get(i).getElement() == client) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        assert (false);
    }

    @Override
    public List<BackRef> getClientList() {
        return this.clients;
    }

    @Override
    public boolean hasReferences() {
        return !this.clients.isEmpty();
    }

    public void broadcast(NotificationEvent ev) {
        ev.setDeliveryPath(5);
        int i = 0;
        while (i < this.clients.size()) {
            this.clients.get(i).getElement().broadcast(ev);
            ++i;
        }
    }

    public abstract boolean isReferencableProperty(String var1);

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (LIB_REFERENCE_MEMBER.equalsIgnoreCase(propName)) {
            return this.libReference;
        }
        assert (false);
        return null;
    }

    @Override
    public Object getProperty(Module module, PropertyDefn propDefn) {
        ReferencableStructure refStruct;
        assert (propDefn != null);
        Object value = this.getLocalProperty(module, propDefn);
        if (value != null) {
            return value;
        }
        if (this.libReference != null && (refStruct = this.libReference.getTargetStructure()) != null) {
            Library root = null;
            if (module != null) {
                root = module.getLibraryWithNamespace(this.libReference.getLibraryNamespace(), 1);
            }
            if ((value = refStruct.getProperty(root, propDefn)) != null) {
                return value;
            }
        }
        return propDefn.getDefault();
    }

    @Override
    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        if (this.libReference != null && !this.libReference.isResolved()) {
            PropertyDefn libRefDefn = (PropertyDefn)this.getDefn().getMember(LIB_REFERENCE_MEMBER);
            assert (libRefDefn != null);
            StructRefPropertyType type = (StructRefPropertyType)libRefDefn.getType();
            type.resolve(module, libRefDefn, this.libReference);
            if (this.libReference.isResolved()) {
                this.libReference.getTargetStructure().addClientStructure(this);
            }
        }
        return super.getLocalProperty(module, propDefn);
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (LIB_REFERENCE_MEMBER.equalsIgnoreCase(propName)) {
            this.updateReference(this.libReference, (StructRefValue)value);
            this.libReference = (StructRefValue)value;
        } else assert (false);
    }

    protected void updateReference(StructRefValue oldRef, StructRefValue newRef) {
        ReferencableStructure target;
        if (oldRef != null && (target = oldRef.getTargetStructure()) != null) {
            target.dropClientStructure(this);
        }
        if (newRef != null && (target = newRef.getTargetStructure()) != null) {
            target.addClientStructure(this);
        }
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        ArrayList<SemanticException> errors = new ArrayList<SemanticException>();
        StructRefValue ref = (StructRefValue)this.getLocalProperty(module, LIB_REFERENCE_MEMBER);
        if (ref != null && !ref.isResolved()) {
            errors.add(new SemanticError(element, new String[]{this.getDefn().getName(), this.getReferencableProperty(), this.libReference.getQualifiedReference()}, "Error.SemanticError.INVALID_LIBRARY_REFERENCE"));
            return errors;
        }
        return errors;
    }

    protected Object clone() throws CloneNotSupportedException {
        ReferencableStructure struct = (ReferencableStructure)super.clone();
        struct.libReference = null;
        struct.clients = new ArrayList();
        struct.clientStructures = new ArrayList();
        if (this.libReference == null) {
            return struct;
        }
        Iterator<IPropertyDefn> propIter = this.getDefn().getPropertyIterator();
        block0: while (propIter.hasNext()) {
            PropertyDefn prop = (PropertyDefn)propIter.next();
            if (struct.getLocalProperty(null, prop) != null || LIB_REFERENCE_MEMBER.equals(prop.getName())) continue;
            StructRefValue libRef = this.libReference;
            while (libRef != null) {
                ReferencableStructure libStructure = libRef.getTargetStructure();
                if (libStructure == null) {
                    struct.libReference = new StructRefValue(this.libReference.getLibraryNamespace(), this.libReference.getName());
                    return struct;
                }
                Object value = libStructure.getLocalProperty(null, prop);
                if (value != null) {
                    struct.setProperty(prop, value);
                    continue block0;
                }
                libRef = (StructRefValue)libStructure.getLocalProperty(null, LIB_REFERENCE_MEMBER);
            }
        }
        return struct;
    }

    public void addClientStructure(Structure struct) {
        this.clientStructures.add(struct);
    }

    public void dropClientStructure(Structure struct) {
        assert (this.clientStructures.contains(struct));
        this.clientStructures.remove(struct);
    }

    public List<Structure> getClientStructures() {
        return this.clientStructures;
    }
}

