/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.LibraryEvent;
import org.eclipse.birt.report.model.command.AbstractLibraryRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;

public class ShiftLibraryRecord
extends AbstractLibraryRecord {
    private int oldPosn = -1;
    private int newPosn = -1;

    ShiftLibraryRecord(Module module, int oldPosn, int newPosn) {
        super(module);
        this.oldPosn = oldPosn;
        this.newPosn = newPosn;
    }

    protected void perform(boolean undo) {
        this.library = this.module.getLibraries().get(undo ? this.newPosn : this.oldPosn);
        assert (this.library != null);
        this.module.dropLibrary(this.library);
        this.module.insertLibrary(this.library, undo ? this.oldPosn : this.newPosn);
        List<Library> librariesToUpdate = this.module.getLibraries().subList(Math.min(this.oldPosn, this.newPosn), Math.max(this.oldPosn, this.newPosn));
        this.updateReferenceableClients(librariesToUpdate.size());
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public NotificationEvent getEvent() {
        assert (this.library != null);
        return new LibraryEvent(this.library, 3);
    }
}

