/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertyStructure;
import org.eclipse.birt.report.model.util.ModelUtil;

public class FilterCondition
extends PropertyStructure {
    public static final String FILTER_COND_STRUCT = "FilterCondition";
    public static final String OPERATOR_MEMBER = "operator";
    public static final String EXPR_MEMBER = "expr";
    public static final String VALUE1_MEMBER = "value1";
    public static final String VALUE2_MEMBER = "value2";
    public static final String FILTER_TARGET_MEMBER = "filterTarget";
    public static final String IS_OPTIONAL_MEMBER = "isOptional";
    public static final String EXTENSION_NAME_MEMBER = "extensionName";
    public static final String EXTENSION_EXPR_ID_MEMBER = "extensionExprId";
    public static final String PUSH_DOWN_MEMBER = "pushDown";
    public static final String DYNAMIC_FILTER_PARAMETER_MEMBER = "dynamicFilterParameter";

    public String getStructName() {
        return FILTER_COND_STRUCT;
    }

    public String getExpr() {
        return this.getStringProperty(null, EXPR_MEMBER);
    }

    public void setExpr(String expr) {
        this.setProperty(EXPR_MEMBER, (Object)expr);
    }

    public String getOperator() {
        return (String)this.getProperty(null, OPERATOR_MEMBER);
    }

    public void setOperator(String operator) {
        this.setProperty(OPERATOR_MEMBER, (Object)operator);
    }

    public String getValue1() {
        List valueList = this.getValue1List();
        if (valueList == null || valueList.isEmpty()) {
            return null;
        }
        return (String)valueList.get(0);
    }

    public List getValue1List() {
        List valueList = (List)this.getProperty(null, VALUE1_MEMBER);
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(ModelUtil.getExpressionCompatibleList(valueList));
    }

    public List getValue1ExpressionList() {
        List valueList = (List)this.getProperty(null, VALUE1_MEMBER);
        if (valueList == null || valueList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(valueList);
    }

    public void setValue1(String value1) {
        if (value1 == null) {
            this.setProperty(VALUE1_MEMBER, null);
            return;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value1);
        this.setProperty(VALUE1_MEMBER, valueList);
    }

    public void setValue1(List value1List) {
        this.setProperty(VALUE1_MEMBER, (Object)value1List);
    }

    public String getValue2() {
        return this.getStringProperty(null, VALUE2_MEMBER);
    }

    public void setValue2(String value2) {
        this.setProperty(VALUE2_MEMBER, (Object)value2);
    }

    public List validate(Module module, DesignElement element) {
        List<SemanticException> list = super.validate(module, element);
        if (StringUtil.isBlank(this.getFilterExpr())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(EXPR_MEMBER), (Object)this.getFilterExpr(), "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new FilterConditionHandle(valueHandle, index);
    }

    public String getColumn() {
        return null;
    }

    public void setColumn(String column) {
    }

    public String getFilterExpr() {
        return this.getExpr();
    }

    public void setFilterExpr(String filterExpr) {
        this.setExpr(filterExpr);
    }

    public String getValue1Expr() {
        return this.getValue1();
    }

    public void setValue1Expr(String value1Expr) {
        this.setValue1(value1Expr);
    }

    public String getValue2Expr() {
        return this.getValue2();
    }

    public void setValue2Expr(String value2Expr) {
        this.setValue2(value2Expr);
    }

    public String getFilterTarget() {
        return (String)this.getProperty(null, FILTER_TARGET_MEMBER);
    }

    public void setFilterTarget(String filterTarget) {
        this.setProperty(FILTER_TARGET_MEMBER, (Object)filterTarget);
    }

    public boolean isOptional() {
        Boolean isOptional = (Boolean)this.getProperty(null, IS_OPTIONAL_MEMBER);
        if (isOptional == null) {
            return false;
        }
        return isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.setProperty(IS_OPTIONAL_MEMBER, (Object)isOptional);
    }

    public String getExtensionName() {
        return (String)this.getProperty(null, EXTENSION_NAME_MEMBER);
    }

    public String getExtensionExprId() {
        return (String)this.getProperty(null, EXTENSION_EXPR_ID_MEMBER);
    }

    public boolean pushDown() {
        Boolean pushDown = (Boolean)this.getProperty(null, PUSH_DOWN_MEMBER);
        if (pushDown == null) {
            return false;
        }
        return pushDown;
    }

    public String getDynamicFilterParameter() {
        return this.getStringProperty(null, DYNAMIC_FILTER_PARAMETER_MEMBER);
    }

    public void setExtensionName(String extensionName) {
        this.setProperty(EXTENSION_NAME_MEMBER, (Object)extensionName);
    }

    public void setExtensionExprId(String extensionExprId) {
        this.setProperty(EXTENSION_EXPR_ID_MEMBER, (Object)extensionExprId);
    }

    public void setPushDown(boolean pushDown) {
        this.setProperty(PUSH_DOWN_MEMBER, (Object)pushDown);
    }

    public void setDynamicFilterParameter(String parameterName) {
        this.setProperty(DYNAMIC_FILTER_PARAMETER_MEMBER, (Object)parameterName);
    }
}

