/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateAttributeEditor
extends AbstractAttributeEditor {
    private DatePicker datePicker;
    private boolean showTime;

    public DateAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
    }

    public void createControl(Composite composite, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            Text text = new Text(composite, 0x800008);
            text.setFont(EditorUtil.TEXT_FONT);
            toolkit.adapt((Control)text, false, false);
            text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            text.setText(this.getTextValue());
            this.setControl((Control)text);
        } else {
            this.datePicker = new DatePicker(composite, 0x800000, this.getTextValue(), this.showTime, 0);
            this.datePicker.setFont(EditorUtil.TEXT_FONT);
            if (!this.showTime) {
                this.datePicker.setDateFormat(EditorUtil.getDateFormat());
            } else {
                this.datePicker.setDateFormat(EditorUtil.getDateTimeFormat());
            }
            if (this.getValue() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getValue());
                this.datePicker.setDate(cal);
            }
            this.datePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Calendar cal = DateAttributeEditor.this.datePicker.getDate();
                    if (cal != null) {
                        Date value;
                        if (!DateAttributeEditor.this.showTime) {
                            TaskActivityUtil.snapStartOfDay((Calendar)cal);
                        }
                        if (!(value = cal.getTime()).equals(DateAttributeEditor.this.getValue())) {
                            DateAttributeEditor.this.setValue(value);
                        }
                    } else {
                        if (DateAttributeEditor.this.getValue() != null) {
                            DateAttributeEditor.this.setValue(null);
                        }
                        DateAttributeEditor.this.datePicker.setDate(null);
                    }
                }
            });
            GridDataFactory.fillDefaults().hint(120, -1).grab(false, false).applyTo((Control)this.datePicker);
            this.datePicker.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            toolkit.adapt((Control)this.datePicker, false, false);
            this.setControl((Control)this.datePicker);
        }
    }

    protected void decorateIncoming(Color color) {
        if (this.datePicker != null) {
            this.datePicker.setBackground(color);
        }
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    private String getTextValue() {
        Date date = this.getValue();
        if (date != null) {
            if (this.getShowTime()) {
                return EditorUtil.formatDateTime(date);
            }
            return EditorUtil.formatDate(date);
        }
        return "";
    }

    public Date getValue() {
        return this.getAttributeMapper().getDateValue(this.getTaskAttribute());
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public void setValue(Date date) {
        this.getAttributeMapper().setDateValue(this.getTaskAttribute(), date);
        this.attributeChanged();
    }
}

