/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.component.component.CONNECTION_QUANTIFIER;
import org.eclipse.comma.behavior.component.component.CommandReply;
import org.eclipse.comma.behavior.component.component.CommandReplyWithVars;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPart;
import org.eclipse.comma.behavior.component.component.Connection;
import org.eclipse.comma.behavior.component.component.ConnectionVariable;
import org.eclipse.comma.behavior.component.component.EventCall;
import org.eclipse.comma.behavior.component.component.EventWithVars;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.PortSelector;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.TriggeredTransition;
import org.eclipse.comma.behavior.component.utilities.ClauseFragments;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.component.utilities.FunctionFragment;
import org.eclipse.comma.behavior.component.utilities.FunctionFragmentCall;
import org.eclipse.comma.behavior.component.utilities.IfHelperAction;
import org.eclipse.comma.behavior.component.utilities.StateTransitionAction;
import org.eclipse.comma.behavior.component.utilities.TransitionDecomposer;
import org.eclipse.comma.behavior.component.utilities.TransitionFragment;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.CommaScope;
import org.eclipse.comma.monitoring.generator.EventPatternMixin;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FunctionalConstraintGenerator
extends EventPatternMixin {
    private Iterable<Interface> interfaces;
    private boolean inEventReception = false;
    private String eventReceptionPort = "";
    private String eventReceptionConnection = "";
    private Map<Variable, String> triggerVariables;
    private Map<Transition, Map<Clause, ClauseFragments>> clauseFragments;

    public FunctionalConstraintGenerator(Iterable<Interface> interfaces, IFileSystemAccess fsa) {
        super(null, fsa);
        this.interfaces = interfaces;
    }

    public HashMap<Transition, Map<Clause, ClauseFragments>> populateClauseFragments(StateBasedFunctionalConstraint fc) {
        HashMap<Transition, Map<Clause, ClauseFragments>> _xblockexpression = null;
        HashMap<Transition, Map<Clause, ClauseFragments>> result = new HashMap<Transition, Map<Clause, ClauseFragments>>();
        HashMap<Variable, String> _hashMap = new HashMap<Variable, String>();
        this.triggerVariables = _hashMap;
        EList _states = fc.getStates();
        for (State s : _states) {
            int subStateCounter = 1;
            int functionCounter = 1;
            EList _transitions = s.getTransitions();
            for (Transition t : _transitions) {
                HashMap<Clause, ClauseFragments> clausesMap = new HashMap<Clause, ClauseFragments>();
                EList _clauses = t.getClauses();
                for (Clause cl : _clauses) {
                    ClauseFragments fragments = TransitionDecomposer.decomposeTransition((StateBasedFunctionalConstraint)fc, (Transition)t, (Clause)cl);
                    List _subTransitionFragments = fragments.getSubTransitionFragments();
                    for (TransitionFragment f : _subTransitionFragments) {
                        String _name = s.getName();
                        String _plus = String.valueOf(_name) + "_";
                        int _plusPlus = subStateCounter++;
                        String _plus_1 = String.valueOf(_plus) + Integer.valueOf(_plusPlus);
                        f.setSubState(_plus_1);
                    }
                    List _functionFragments = fragments.getFunctionFragments();
                    for (FunctionFragment f_1 : _functionFragments) {
                        String _name_1 = s.getName();
                        String _plus_2 = "f" + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + "_";
                        int _plusPlus_1 = functionCounter++;
                        String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_plusPlus_1);
                        f_1.setMethodName(_plus_4);
                    }
                    Consumer<Map.Entry<Variable, String>> _function = new Consumer<Map.Entry<Variable, String>>(){

                        @Override
                        public void accept(Map.Entry<Variable, String> it) {
                            FunctionalConstraintGenerator.this.triggerVariables.put(it.getKey(), "");
                        }
                    };
                    fragments.getTriggerVariables().entrySet().forEach(_function);
                    clausesMap.put(cl, fragments);
                }
                result.put(t, clausesMap);
            }
        }
        int counter = 1;
        Set<Variable> _keySet = this.triggerVariables.keySet();
        for (Variable v : _keySet) {
            String _name = v.getName();
            String _plus = String.valueOf(_name) + "_";
            int _plusPlus = counter++;
            String _plus_1 = String.valueOf(_plus) + Integer.valueOf(_plusPlus);
            this.triggerVariables.put(v, _plus_1);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public void generateUtilityClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        if (fc instanceof StateBasedFunctionalConstraint) {
            this.clauseFragments = this.populateClauseFragments((StateBasedFunctionalConstraint)fc);
        }
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(FunctionalConstraintGenerator.utilityClassName(c, fc).toString()), this.utilityClassContent(fc, c));
    }

    public void generateConstraintClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(FunctionalConstraintGenerator.constraintClassName(c, fc).toString()), this.constraintClassContent(fc, c));
    }

    public CharSequence constraintClassImportPart() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.regex.Pattern;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _constraintClassContent(PredicateFunctionalConstraint fc, Component c) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _constraintClassImportPart = this.constraintClassImportPart();
        _builder.append((Object)_constraintClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        String _utilityClassName_2 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t\t");
        String _xblockexpression = null;
        this.inEventReception = true;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("determineContextPort(message)");
        this.eventReceptionPort = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("determineContextConnection(message)");
        this.eventReceptionConnection = _builder_2.toString();
        _xblockexpression = "";
        _builder.append(_xblockexpression, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if((");
        CharSequence _generateExpression = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression, "\t\t");
        _builder.append(") &&");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _xblockexpression_1 = null;
        this.inEventReception = false;
        _xblockexpression_1 = "";
        _builder.append(_xblockexpression_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  ");
        _builder.append("(");
        CharSequence _generateExpression_1 = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression_1, "\t\t\t  ");
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  \t");
        _builder.append("result.states.add(stateOfDecisionClass);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintClassContent(StateBasedFunctionalConstraint fc, Component c) {
        StringConcatenation _xblockexpression = null;
        ArrayList<String> states = this.getStateNames(fc);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _constraintClassImportPart = this.constraintClassImportPart();
        _builder.append((Object)_constraintClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" lastReceivedState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = FunctionalConstraintGenerator.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_2 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = (");
        String _utilityClassName_3 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_3, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("stateOfDecisionClass = (");
        String _utilityClassName_4 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_4, "\t    ");
        _builder.append(") Utils.deepCopy(lastReceivedState);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("switch(lastReceivedState.getState()) {");
        _builder.newLine();
        for (String s : states) {
            _builder.append("\t\t");
            _builder.append("case \"");
            _builder.append(s, "\t\t");
            _builder.append("\" : return state");
            _builder.append(s, "\t\t");
            _builder.append("(message);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("default: return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _states = fc.getStates();
        for (State s_1 : _states) {
            _builder.append("\t");
            CharSequence _generateStateMethod = this.generateStateMethod(s_1, FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc));
            _builder.append((Object)_generateStateMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateFragmentMethods = this.generateFragmentMethods(s_1);
            _builder.append((Object)_generateFragmentMethods, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateFunctionMethods = this.generateFunctionMethods(s_1);
            _builder.append((Object)_generateFunctionMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence bindParameter(Variable v, int index) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("stateOfDecisionClass.set_");
        _builder.append("commaVar_");
        String _get = this.triggerVariables.get(v);
        _builder.append(_get);
        _builder.append("(message.getParameters().get(");
        _builder.append((Object)index);
        _builder.append("));");
        return _builder;
    }

    public CharSequence bindParameter(Variable v, String value) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("stateOfDecisionClass.set_");
        _builder.append("commaVar_");
        String _get = this.triggerVariables.get(v);
        _builder.append(_get);
        _builder.append("(");
        _builder.append(value);
        _builder.append(");");
        return _builder;
    }

    public String determineContextPort(PortSelector ev) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        ComponentPart _part = ev.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            String _name = ev.getPart().getName();
            String _plus = String.valueOf(_name) + ".";
            String _name_1 = ev.getPort().getName();
            _xifexpression = String.valueOf(_plus) + _name_1;
        } else {
            _xifexpression = ev.getPort().getName();
        }
        return _xifexpression;
    }

    public CharSequence determineContextConnection(PortSelector ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        ComponentPart _part = ev.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append("(componentInstanceName + \".\" + \"");
            String _name = ev.getPart().getName();
            _builder.append(_name);
            _builder.append("\")");
        } else {
            _builder.append("componentInstanceName");
        }
        _builder.append(".equals(message.getSource()) ? message.getDestination() : message.getSource()");
        return _builder;
    }

    public CharSequence generateFunctionMethods(State s) {
        StringConcatenation _builder = new StringConcatenation();
        EList _transitions = s.getTransitions();
        for (Transition t : _transitions) {
            EList _clauses = t.getClauses();
            for (Clause c : _clauses) {
                List _functionFragments = this.clauseFragments.get(t).get(c).getFunctionFragments();
                for (FunctionFragment fragment : _functionFragments) {
                    _builder.append("private CFunctionalConstraintResult ");
                    String _methodName = fragment.getMethodName();
                    _builder.append(_methodName);
                    _builder.append("() {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.newLine();
                    List _actions = fragment.getActions();
                    for (Object a : _actions) {
                        _builder.append("    ");
                        CharSequence _n_generateAction = this.n_generateAction(a);
                        _builder.append((Object)_n_generateAction, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("    ");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public CharSequence generateFragmentMethods(State s) {
        StringConcatenation _builder = new StringConcatenation();
        EList _transitions = s.getTransitions();
        for (Transition t : _transitions) {
            EList _clauses = t.getClauses();
            for (Clause c : _clauses) {
                List _subTransitionFragments = this.clauseFragments.get(t).get(c).getSubTransitionFragments();
                for (TransitionFragment fragment : _subTransitionFragments) {
                    _builder.append("private CFunctionalConstraintResult state");
                    String _subState = fragment.getSubState();
                    _builder.append(_subState);
                    _builder.append("(CObservedMessage message) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("   ");
                    _builder.append("CMessagePattern e;");
                    _builder.newLine();
                    _builder.append("   ");
                    _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
                    _builder.newLine();
                    _builder.append("   ");
                    Object first = fragment.getActions().get(0);
                    _builder.newLineIfNotEmpty();
                    _builder.append("   ");
                    CharSequence _headOfFragmentMethod = this.headOfFragmentMethod((EObject)first);
                    _builder.append((Object)_headOfFragmentMethod, "   ");
                    _builder.append(" ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("   ");
                    _builder.append("if(e.match(message)) {");
                    _builder.newLine();
                    if (first instanceof ActionWithVars) {
                        boolean _tripleNotEquals_1;
                        if (first instanceof EventWithVars) {
                            _builder.append("       ");
                            InterfaceEvent event = ((EventWithVars)first).getEvent();
                            _builder.newLineIfNotEmpty();
                            _builder.append("       ");
                            int counter = 0;
                            _builder.newLineIfNotEmpty();
                            int _size = event.getParameters().size();
                            Iterator _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                            Iterator iterator = _doubleDotLessThan.iterator();
                            while (iterator.hasNext()) {
                                boolean _tripleNotEquals;
                                Integer i = (Integer)iterator.next();
                                DIRECTION _direction = ((Parameter)event.getParameters().get(i.intValue())).getDirection();
                                boolean bl = _tripleNotEquals = _direction != DIRECTION.OUT;
                                if (!_tripleNotEquals) continue;
                                _builder.append("       ");
                                Variable _get = (Variable)((EventWithVars)first).getParameters().get(counter);
                                int _plusPlus = counter++;
                                CharSequence _bindParameter = this.bindParameter(_get, _plusPlus);
                                _builder.append((Object)_bindParameter, "       ");
                                _builder.newLineIfNotEmpty();
                            }
                        } else {
                            int _size_1 = ((ActionWithVars)first).getParameters().size();
                            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
                            for (Integer i_1 : _doubleDotLessThan_1) {
                                _builder.append("       ");
                                CharSequence _bindParameter_1 = this.bindParameter((Variable)((ActionWithVars)first).getParameters().get(i_1.intValue()), i_1);
                                _builder.append((Object)_bindParameter_1, "       ");
                                _builder.newLineIfNotEmpty();
                            }
                        }
                        _builder.append("       ");
                        CharSequence _bindActionWithVars = this.bindActionWithVars((ActionWithVars)first);
                        _builder.append((Object)_bindActionWithVars, "       ");
                        _builder.newLineIfNotEmpty();
                        Expression _condition = ((ActionWithVars)first).getCondition();
                        boolean bl = _tripleNotEquals_1 = _condition != null;
                        if (_tripleNotEquals_1) {
                            _builder.append("       ");
                            String _xblockexpression = null;
                            this.inEventReception = true;
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("\"");
                            String _determineContextPort = this.determineContextPort((PortSelector)first);
                            _builder_1.append(_determineContextPort);
                            _builder_1.append("\"");
                            this.eventReceptionPort = _builder_1.toString();
                            StringConcatenation _builder_2 = new StringConcatenation();
                            CharSequence _determineContextConnection = this.determineContextConnection((PortSelector)first);
                            _builder_2.append((Object)_determineContextConnection);
                            this.eventReceptionConnection = _builder_2.toString();
                            _xblockexpression = "";
                            _builder.append(_xblockexpression, "       ");
                            _builder.newLineIfNotEmpty();
                            _builder.append("       ");
                            _builder.append("if(");
                            CharSequence _generateExpression = this.generateExpression(((ActionWithVars)first).getCondition());
                            _builder.append((Object)_generateExpression, "       ");
                            _builder.append(") {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("       ");
                            _builder.append("    ");
                            String _xblockexpression_1 = null;
                            this.inEventReception = false;
                            _xblockexpression_1 = "";
                            _builder.append(_xblockexpression_1, "           ");
                            _builder.newLineIfNotEmpty();
                            int _size_2 = fragment.getActions().size();
                            ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(1, _size_2, true);
                            for (Integer i_2 : _doubleDotLessThan_2) {
                                _builder.append("       ");
                                _builder.append("    ");
                                CharSequence _n_generateAction = this.n_generateAction(fragment.getActions().get(i_2));
                                _builder.append((Object)_n_generateAction, "           ");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("       ");
                            _builder.append("}");
                            _builder.newLine();
                        } else {
                            int _size_3 = fragment.getActions().size();
                            ExclusiveRange _doubleDotLessThan_3 = new ExclusiveRange(1, _size_3, true);
                            for (Integer i_3 : _doubleDotLessThan_3) {
                                _builder.append("       ");
                                CharSequence _n_generateAction_1 = this.n_generateAction(fragment.getActions().get(i_3));
                                _builder.append((Object)_n_generateAction_1, "       ");
                                _builder.newLineIfNotEmpty();
                            }
                        }
                    } else {
                        int _size_4 = fragment.getActions().size();
                        ExclusiveRange _doubleDotLessThan_4 = new ExclusiveRange(1, _size_4, true);
                        for (Integer i_4 : _doubleDotLessThan_4) {
                            _builder.append("       ");
                            CharSequence _n_generateAction_2 = this.n_generateAction(fragment.getActions().get(i_4));
                            _builder.append((Object)_n_generateAction_2, "       ");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("   ");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("   ");
                    _builder.newLine();
                    _builder.append("   ");
                    _builder.append("return result;                  ");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public CharSequence bindActionWithVars(ActionWithVars a) {
        StringConcatenation _xblockexpression = null;
        Variable idVarDef = ((ConnectionVariable)a).getIdVarDef();
        StringConcatenation _xifexpression = null;
        if (idVarDef != null) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _componentIdExp = this.componentIdExp((PortSelector)a);
            String _plus = "message.getDestination().equals(" + _componentIdExp;
            String _plus_1 = String.valueOf(_plus) + ") ? message.getSource() : message.getDestination()";
            CharSequence _bindParameter = this.bindParameter(idVarDef, _plus_1);
            _builder.append((Object)_bindParameter);
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1;
            _xifexpression = _builder_1 = new StringConcatenation();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence _headOfFragmentMethod(CommandReplyWithVars e) {
        StringConcatenation _xblockexpression = null;
        Command _command = this.getCommand((Reply)e);
        ArrayList _arrayList = new ArrayList();
        EventPattern event = ComponentUtilities.makeEvent(null, (Command)_command, (PortSelector)e, _arrayList);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("e = ");
        CharSequence _generateEvent = this.generateEvent(event);
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _headOfFragmentMethod(CommandReply e) {
        ExpressionVariable _idVar;
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        Command _command = this.getCommand((Reply)e);
        ArrayList _arrayList = new ArrayList();
        EventPattern event = ComponentUtilities.makeEvent(null, (Command)_command, (PortSelector)e, _arrayList);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("e = ");
        CharSequence _generateEvent = this.generateEvent(event);
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = e.getParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("e");
            EList _parameters = e.getParameters();
            for (Expression p : _parameters) {
                _builder.append(".addParameter(");
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _tripleNotEquals = (_idVar = e.getIdVar()) != null;
        if (_tripleNotEquals) {
            _builder.append("if(message.getDestination().equals(");
            CharSequence _componentIdExp = this.componentIdExp((PortSelector)e);
            _builder.append((Object)_componentIdExp);
            _builder.append(")) {e.setSource(");
            CharSequence _generateExpression_1 = this.generateExpression((Expression)e.getIdVar());
            _builder.append((Object)_generateExpression_1);
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
            _builder.append("else {e.setDestination(");
            CharSequence _generateExpression_2 = this.generateExpression((Expression)e.getIdVar());
            _builder.append((Object)_generateExpression_2);
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _headOfFragmentMethod(EventCall e) {
        ExpressionVariable _idVar;
        boolean _tripleNotEquals;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        InterfaceEvent _event = e.getEvent();
        ArrayList _arrayList = new ArrayList();
        EventPattern event = ComponentUtilities.makeEvent((InterfaceEvent)_event, null, (PortSelector)e, _arrayList);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("e = ");
        CharSequence _generateEvent = this.generateEvent(event);
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = e.getParameters().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("e");
            EList _parameters = e.getParameters();
            for (Expression p : _parameters) {
                _builder.append(".addParameter(");
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _tripleNotEquals = (_idVar = e.getIdVar()) != null;
        if (_tripleNotEquals) {
            _builder.append("if(message.getDestination().equals(");
            CharSequence _componentIdExp = this.componentIdExp((PortSelector)e);
            _builder.append((Object)_componentIdExp);
            _builder.append(")) {e.setSource(");
            CharSequence _generateExpression_1 = this.generateExpression((Expression)e.getIdVar());
            _builder.append((Object)_generateExpression_1);
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
            _builder.append("else {e.setDestination(");
            CharSequence _generateExpression_2 = this.generateExpression((Expression)e.getIdVar());
            _builder.append((Object)_generateExpression_2);
            _builder.append(");}");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _headOfFragmentMethod(EventWithVars e) {
        StringConcatenation _xblockexpression = null;
        InterfaceEvent _event = e.getEvent();
        ArrayList _arrayList = new ArrayList();
        EventPattern event = ComponentUtilities.makeEvent((InterfaceEvent)_event, null, (PortSelector)e, _arrayList);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("e = ");
        CharSequence _generateEvent = this.generateEvent(event);
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateStateMethod(State s, String stateClassName) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CFunctionalConstraintResult state");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("(CObservedMessage message){");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)s.getTransitions(), TriggeredTransition.class));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("    ");
            _builder.append("CMessagePattern e;");
            _builder.newLine();
        }
        _builder.append("    ");
        _builder.newLine();
        int _size = s.getTransitions().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            _builder.append("    ");
            CharSequence _transitionInStateMethod = this.transitionInStateMethod((Transition)s.getTransitions().get(i.intValue()), stateClassName, i);
            _builder.append((Object)_transitionInStateMethod, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _transitionInStateMethod(NonTriggeredTransition t, String stateClassName, int tIndex) {
        Expression _guard;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        if (tIndex > 0) {
            _builder.append("stateOfDecisionClass = (");
            _builder.append(stateClassName);
            _builder.append(") Utils.deepCopy(lastReceivedState);");
            _builder.newLineIfNotEmpty();
        }
        boolean bl = _tripleNotEquals = (_guard = t.getGuard()) != null;
        if (_tripleNotEquals) {
            _builder.append("if(");
            CharSequence _generateExpression = this.generateExpression(t.getGuard());
            _builder.append((Object)_generateExpression);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            EList _clauses = t.getClauses();
            for (Clause c : _clauses) {
                boolean _greaterThan;
                int _indexOf = t.getClauses().indexOf((Object)c);
                boolean bl2 = _greaterThan = _indexOf > 0;
                if (_greaterThan) {
                    _builder.append("    ");
                    _builder.append("stateOfDecisionClass = (");
                    _builder.append(stateClassName, "    ");
                    _builder.append(") Utils.deepCopy(lastReceivedState);");
                    _builder.newLineIfNotEmpty();
                }
                List _actions = this.clauseFragments.get(t).get(c).getRootFragment().getActions();
                for (Object a : _actions) {
                    _builder.append("    ");
                    CharSequence _n_generateAction = this.n_generateAction(a);
                    _builder.append((Object)_n_generateAction, "    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        } else {
            EList _clauses_1 = t.getClauses();
            for (Clause c_1 : _clauses_1) {
                boolean _greaterThan_1;
                int _indexOf_1 = t.getClauses().indexOf((Object)c_1);
                boolean bl3 = _greaterThan_1 = _indexOf_1 > 0;
                if (_greaterThan_1) {
                    _builder.append("stateOfDecisionClass = (");
                    _builder.append(stateClassName);
                    _builder.append(") Utils.deepCopy(lastReceivedState);");
                    _builder.newLineIfNotEmpty();
                }
                List _actions_1 = this.clauseFragments.get(t).get(c_1).getRootFragment().getActions();
                for (Object a_1 : _actions_1) {
                    CharSequence _n_generateAction_1 = this.n_generateAction(a_1);
                    _builder.append((Object)_n_generateAction_1);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence _n_generateAction(AssignmentAction a) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateAction = this.generateAction((Action)a);
        _builder.append((Object)_generateAction);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _n_generateAction(IfAction ifact) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(ifact.getGuard());
        _builder.append((Object)_generateExpression);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        EList _actions = ifact.getThenList().getActions();
        for (Action a : _actions) {
            _builder.append("    ");
            CharSequence _generateAction = this.generateAction(a);
            _builder.append((Object)_generateAction, "    ");
            _builder.newLineIfNotEmpty();
        }
        ActionList _elseList = ifact.getElseList();
        boolean bl = _tripleNotEquals = _elseList != null;
        if (_tripleNotEquals) {
            _builder.append("} else {");
            _builder.newLine();
            EList _actions_1 = ifact.getElseList().getActions();
            for (Action a_1 : _actions_1) {
                _builder.append("    ");
                CharSequence _generateAction_1 = this.generateAction(a_1);
                _builder.append((Object)_generateAction_1, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _n_generateAction(IfHelperAction ifact) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(ifact.getCondition());
        _builder.append((Object)_generateExpression);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        List _thenActions = ifact.getThenActions();
        for (Object a : _thenActions) {
            _builder.append("   ");
            CharSequence _n_generateAction = this.n_generateAction(a);
            _builder.append((Object)_n_generateAction, "   ");
            _builder.newLineIfNotEmpty();
        }
        List _elseActions = ifact.getElseActions();
        boolean bl = _tripleNotEquals = _elseActions != null;
        if (_tripleNotEquals) {
            _builder.append("} else {");
            _builder.newLine();
            List _elseActions_1 = ifact.getElseActions();
            for (Object a_1 : _elseActions_1) {
                _builder.append("    ");
                CharSequence _n_generateAction_1 = this.n_generateAction(a_1);
                _builder.append((Object)_n_generateAction_1, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _n_generateAction(RecordFieldAssignmentAction a) {
        return this.generateAction((Action)a);
    }

    protected CharSequence _transitionInStateMethod(TriggeredTransition t, String stateClassName, int tIndex) {
        Expression _guard;
        boolean _tripleNotEquals_2;
        int _size_2;
        boolean _greaterThan;
        boolean _tripleNotEquals_1;
        StringConcatenation _xblockexpression = null;
        EventPattern event = this.pattern(t);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("e = ");
        CharSequence _generateEvent = this.generateEvent(event);
        _builder.append((Object)_generateEvent);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("if(e.match(message)) {");
        _builder.newLine();
        if (tIndex > 0) {
            _builder.append("    ");
            _builder.append("stateOfDecisionClass = (");
            _builder.append(stateClassName, "    ");
            _builder.append(") Utils.deepCopy(lastReceivedState);");
            _builder.newLineIfNotEmpty();
        }
        if (t.getTrigger() != null && t.getTrigger() instanceof Command) {
            _builder.append("    ");
            int counter = 0;
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            InterfaceEvent _trigger = t.getTrigger();
            Command command = (Command)_trigger;
            _builder.newLineIfNotEmpty();
            int _size = command.getParameters().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _tripleNotEquals;
                DIRECTION _direction = ((Parameter)command.getParameters().get(i.intValue())).getDirection();
                boolean bl = _tripleNotEquals = _direction != DIRECTION.OUT;
                if (!_tripleNotEquals) continue;
                _builder.append("    ");
                Variable _get = (Variable)t.getParameters().get(counter);
                int _plusPlus = counter++;
                CharSequence _bindParameter = this.bindParameter(_get, _plusPlus);
                _builder.append((Object)_bindParameter, "    ");
                _builder.newLineIfNotEmpty();
            }
        } else {
            int _size_1 = t.getParameters().size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
            for (Integer i_1 : _doubleDotLessThan_1) {
                _builder.append("    ");
                CharSequence _bindParameter_1 = this.bindParameter((Variable)t.getParameters().get(i_1.intValue()), i_1);
                _builder.append((Object)_bindParameter_1, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        Variable _idVarDef = t.getIdVarDef();
        boolean bl = _tripleNotEquals_1 = _idVarDef != null;
        if (_tripleNotEquals_1) {
            _builder.append("    ");
            Variable _idVarDef_1 = t.getIdVarDef();
            CharSequence _componentIdExp = this.componentIdExp((PortSelector)t);
            String _plus = "message.getDestination().equals(" + _componentIdExp;
            String _plus_1 = String.valueOf(_plus) + ") ? message.getSource() : message.getDestination()";
            CharSequence _bindParameter_2 = this.bindParameter(_idVarDef_1, _plus_1);
            _builder.append((Object)_bindParameter_2, "    ");
            _builder.newLineIfNotEmpty();
        }
        boolean bl2 = _greaterThan = (_size_2 = t.getClauses().size()) > 1;
        if (_greaterThan) {
            _builder.append("    ");
            _builder.append(stateClassName, "    ");
            _builder.append(" tempDecisionClass = (");
            _builder.append(stateClassName, "    ");
            _builder.append(") Utils.deepCopy(stateOfDecisionClass);");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _tripleNotEquals_2 = (_guard = t.getGuard()) != null;
        if (_tripleNotEquals_2) {
            _builder.append("    ");
            String _xblockexpression_1 = null;
            this.inEventReception = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            String _determineContextPort = this.determineContextPort((PortSelector)t);
            _builder_1.append(_determineContextPort);
            _builder_1.append("\"");
            this.eventReceptionPort = _builder_1.toString();
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _determineContextConnection = this.determineContextConnection((PortSelector)t);
            _builder_2.append((Object)_determineContextConnection);
            this.eventReceptionConnection = _builder_2.toString();
            _xblockexpression_1 = "";
            _builder.append(_xblockexpression_1, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if(");
            CharSequence _generateExpression = this.generateExpression(t.getGuard());
            _builder.append((Object)_generateExpression, "    ");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("    ");
            String _xblockexpression_2 = null;
            this.inEventReception = false;
            _xblockexpression_2 = "";
            _builder.append(_xblockexpression_2, "        ");
            _builder.newLineIfNotEmpty();
            EList _clauses = t.getClauses();
            for (Clause c : _clauses) {
                boolean _greaterThan_1;
                int _indexOf = t.getClauses().indexOf((Object)c);
                boolean bl4 = _greaterThan_1 = _indexOf > 0;
                if (_greaterThan_1) {
                    _builder.append("    ");
                    _builder.append("    ");
                    _builder.append("stateOfDecisionClass = (");
                    _builder.append(stateClassName, "        ");
                    _builder.append(") Utils.deepCopy(tempDecisionClass);");
                    _builder.newLineIfNotEmpty();
                }
                List _actions = this.clauseFragments.get(t).get(c).getRootFragment().getActions();
                for (Object a : _actions) {
                    _builder.append("    ");
                    _builder.append("    ");
                    CharSequence _n_generateAction = this.n_generateAction(a);
                    _builder.append((Object)_n_generateAction, "        ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.append("    ");
                _builder.newLine();
            }
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
        } else {
            EList _clauses_1 = t.getClauses();
            for (Clause c_1 : _clauses_1) {
                boolean _greaterThan_2;
                int _indexOf_1 = t.getClauses().indexOf((Object)c_1);
                boolean bl5 = _greaterThan_2 = _indexOf_1 > 0;
                if (_greaterThan_2) {
                    _builder.append("    ");
                    _builder.append("stateOfDecisionClass = (");
                    _builder.append(stateClassName, "    ");
                    _builder.append(") Utils.deepCopy(tempDecisionClass);");
                    _builder.newLineIfNotEmpty();
                }
                List _actions_1 = this.clauseFragments.get(t).get(c_1).getRootFragment().getActions();
                for (Object a_1 : _actions_1) {
                    _builder.append("    ");
                    CharSequence _n_generateAction_1 = this.n_generateAction(a_1);
                    _builder.append((Object)_n_generateAction_1, "    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("    ");
                _builder.newLine();
            }
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _n_generateAction(StateTransitionAction a) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isInNonTriggeredRoot = a.isInNonTriggeredRoot();
        if (_isInNonTriggeredRoot) {
            _builder.append("result.states.addAll(state");
            String _nextState = a.getNextState();
            _builder.append(_nextState);
            _builder.append("(message).states);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("stateOfDecisionClass.setState(\"");
            String _nextState_1 = a.getNextState();
            _builder.append(_nextState_1);
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("result.states.add(stateOfDecisionClass);");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _n_generateAction(FunctionFragmentCall a) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("result.states.addAll(");
        String _methodName = a.getFunctionFragment().getMethodName();
        _builder.append(_methodName);
        _builder.append("().states);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public EventPattern pattern(TriggeredTransition t) {
        InterfaceEvent _trigger = t.getTrigger();
        Command _replyTo = t.getReplyTo();
        ArrayList _arrayList = new ArrayList();
        return ComponentUtilities.makeEvent((InterfaceEvent)_trigger, (Command)_replyTo, (PortSelector)t, _arrayList);
    }

    public CharSequence utilityClassImportPart() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import java.util.regex.Pattern;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CFunctionalConstraintState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CPathDescription;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _utilityClassContent(StateBasedFunctionalConstraint fc, Component c) {
        boolean _not;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _utilityClassImportPart = this.utilityClassImportPart();
        _builder.append((Object)_utilityClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String state;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* global variables */");
        _builder.newLine();
        EList _vars = fc.getVars();
        for (Variable v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _defaultValue = this.defaultValue((EObject)v.getType());
            _builder.append((Object)_defaultValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* trigger variables */");
        _builder.newLine();
        Set<Variable> _keySet = this.triggerVariables.keySet();
        for (Variable v_1 : _keySet) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _get = this.triggerVariables.get(v_1);
            _builder.append(_get, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t                ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getter and setter for current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(String s) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = s;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getters and setters for global variables */");
        _builder.newLine();
        EList _vars_1 = fc.getVars();
        for (Variable v_2 : _vars_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_2 = this.toJavaType((EObject)v_2.getType());
            _builder.append((Object)_javaType_2, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _name_1 = v_2.getName();
            _builder.append(_name_1, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append("commaVar_", "\t\t");
            String _name_2 = v_2.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _name_3 = v_2.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(Object i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("commaVar_", "\t\t");
            String _name_4 = v_2.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(" = (");
            CharSequence _javaType_3 = this.toJavaType((EObject)v_2.getType());
            _builder.append((Object)_javaType_3, "\t\t");
            _builder.append(") i;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* getters and setters for trigger variables */");
        _builder.newLine();
        Set<Variable> _keySet_1 = this.triggerVariables.keySet();
        for (Variable v_3 : _keySet_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_4 = this.toJavaType((EObject)v_3.getType());
            _builder.append((Object)_javaType_4, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _get_1 = this.triggerVariables.get(v_3);
            _builder.append(_get_1, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("return ");
            _builder.append("commaVar_", "\t    ");
            String _get_2 = this.triggerVariables.get(v_3);
            _builder.append(_get_2, "\t    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _get_3 = this.triggerVariables.get(v_3);
            _builder.append(_get_3, "\t");
            _builder.append("(Object i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("commaVar_", "\t    ");
            String _get_4 = this.triggerVariables.get(v_3);
            _builder.append(_get_4, "\t    ");
            _builder.append(" = (");
            CharSequence _javaType_5 = this.toJavaType((EObject)v_3.getType());
            _builder.append((Object)_javaType_5, "\t    ");
            _builder.append(") i;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of current state */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = \"");
        String _name_5 = ComponentUtilities.getInitialState((StateBasedFunctionalConstraint)fc).getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = fc.getInitActions().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("/* initialization of variables in init section */");
            _builder.newLine();
            EList _initActions = fc.getInitActions();
            for (Action a : _initActions) {
                _builder.append("\t\t");
                CharSequence _generateAction = this.generateAction(a);
                _builder.append((Object)_generateAction, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_6 = p.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_7 = s.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        EList _connections = c.getConnections();
        for (Connection connection : _connections) {
            if (connection.getFirstEnd().getPart() == null || connection.getSecondEnd().getPart() == null) continue;
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_8 = connection.getFirstEnd().getPart().getName();
            _builder.append(_name_8, "\t\t");
            _builder.append(".");
            String _name_9 = connection.getFirstEnd().getPort().getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort_1 = this.initialStatesForPort(connection.getFirstEnd().getPort());
            boolean _hasElements_1 = false;
            for (State s_1 : _initialStatesForPort_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_10 = s_1.getName();
                _builder.append(_name_10, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_11 = connection.getSecondEnd().getPart().getName();
            _builder.append(_name_11, "\t\t");
            _builder.append(".");
            String _name_12 = connection.getSecondEnd().getPort().getName();
            _builder.append(_name_12, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort_2 = this.initialStatesForPort(connection.getSecondEnd().getPort());
            boolean _hasElements_2 = false;
            for (State s_2 : _initialStatesForPort_2) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_13 = s_2.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _utilityClassContent(PredicateFunctionalConstraint fc, Component c) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _utilityClassImportPart = this.utilityClassImportPart();
        _builder.append((Object)_utilityClassImportPart);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = FunctionalConstraintGenerator.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name = p.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_1 = s.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        HashSet<String> visitedPorts = new HashSet<String>();
        _builder.newLineIfNotEmpty();
        EList _connections = c.getConnections();
        for (Connection connection : _connections) {
            boolean _contains_1;
            boolean _not_1;
            boolean _not;
            if (connection.getFirstEnd().getPart() == null || connection.getSecondEnd().getPart() == null) continue;
            _builder.append("\t\t");
            String _name_2 = connection.getFirstEnd().getPart().getName();
            String _plus = String.valueOf(_name_2) + ".";
            String _name_3 = connection.getFirstEnd().getPort().getName();
            String first = String.valueOf(_plus) + _name_3;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_4 = connection.getSecondEnd().getPart().getName();
            String _plus_1 = String.valueOf(_name_4) + ".";
            String _name_5 = connection.getSecondEnd().getPort().getName();
            String second = String.valueOf(_plus_1) + _name_5;
            _builder.newLineIfNotEmpty();
            boolean _contains = visitedPorts.contains(first);
            boolean bl2 = _not = !_contains;
            if (_not) {
                _builder.append("\t\t");
                _builder.append("initialPortStates.put(\"");
                _builder.append(first, "\t\t");
                _builder.append("\", new HashSet<>(Arrays.asList(");
                Iterable<State> _initialStatesForPort_1 = this.initialStatesForPort(connection.getFirstEnd().getPort());
                boolean _hasElements_1 = false;
                for (State s_1 : _initialStatesForPort_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    _builder.append("\"");
                    String _name_6 = s_1.getName();
                    _builder.append(_name_6, "\t\t");
                    _builder.append("\"");
                }
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
            boolean bl3 = _not_1 = !(_contains_1 = visitedPorts.contains(second));
            if (_not_1) {
                _builder.append("\t\t");
                _builder.append("initialPortStates.put(\"");
                _builder.append(second, "\t\t");
                _builder.append("\", new HashSet<>(Arrays.asList(");
                Iterable<State> _initialStatesForPort_2 = this.initialStatesForPort(connection.getSecondEnd().getPort());
                boolean _hasElements_2 = false;
                for (State s_2 : _initialStatesForPort_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t");
                    }
                    _builder.append("\"");
                    String _name_7 = s_2.getName();
                    _builder.append(_name_7, "\t\t");
                    _builder.append("\"");
                }
                _builder.append(")));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            String _xblockexpression = null;
            visitedPorts.add(first);
            visitedPorts.add(second);
            _xblockexpression = "";
            _builder.append(_xblockexpression, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String utilityClassName(Component c, FunctionalConstraint fc) {
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)c).toString("_");
        String _name = fc.getName();
        String _plus = String.valueOf(_string) + _name;
        return String.valueOf(_plus) + "State";
    }

    public static String constraintClassName(Component c, FunctionalConstraint fc) {
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)c).toString("_");
        String _name = fc.getName();
        String _plus = String.valueOf(_string) + _name;
        return String.valueOf(_plus) + "FunctionalConstraint";
    }

    public Iterable<State> initialStatesForPort(final Port port) {
        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface it) {
                return it.getName().equals(port.getInterface().getName());
            }
        };
        Functions.Function1<StateMachine, Iterable<State>> _function_1 = new Functions.Function1<StateMachine, Iterable<State>>(){

            public Iterable<State> apply(StateMachine it) {
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return it.isInitial();
                    }
                };
                return IterableExtensions.filter((Iterable)it.getStates(), (Functions.Function1)_function);
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map((List)((Interface)IterableExtensions.findFirst(this.interfaces, (Functions.Function1)_function)).getMachines(), (Functions.Function1)_function_1));
    }

    public ArrayList<String> getStateNames(StateBasedFunctionalConstraint fc) {
        ArrayList<String> _xblockexpression = null;
        final ArrayList<String> result = new ArrayList<String>();
        EList _states = fc.getStates();
        for (State s : _states) {
            result.add(s.getName());
            EList _transitions = s.getTransitions();
            for (Transition t : _transitions) {
                EList _clauses = t.getClauses();
                for (Clause c : _clauses) {
                    Consumer<TransitionFragment> _function = new Consumer<TransitionFragment>(){

                        @Override
                        public void accept(TransitionFragment it) {
                            result.add(it.getSubState());
                        }
                    };
                    this.clauseFragments.get(t).get(c).getSubTransitionFragments().forEach(_function);
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Override
    public CharSequence generateVariableReference(ExpressionVariable expr) {
        CharSequence _xblockexpression = null;
        EObject parent = expr.getVariable().eContainer();
        CharSequence _xifexpression = null;
        if (parent instanceof TriggeredTransition || parent instanceof ActionWithVars) {
            boolean _tripleNotEquals;
            StringConcatenation _xifexpression_1 = null;
            ExpressionQuantifier _containerOfType = (ExpressionQuantifier)EcoreUtil2.getContainerOfType((EObject)expr, ExpressionQuantifier.class);
            boolean bl = _tripleNotEquals = _containerOfType != null;
            if (_tripleNotEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("commaTVar_");
                String _name = expr.getVariable().getName();
                _builder.append(_name);
                _xifexpression_1 = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("stateOfDecisionClass.get_");
                _builder_1.append("commaVar_");
                String _get = this.triggerVariables.get(expr.getVariable());
                _builder_1.append(_get);
                _builder_1.append("()");
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = super.generateVariableReference(expr);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence _generateExpression(ExpressionInterfaceState expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(portsContext.portInState(\"");
        CharSequence _portName = this.portName((PortSelector)expr);
        _builder.append((Object)_portName);
        _builder.append("\", \"");
        String _name = expr.getState().getName();
        _builder.append(_name);
        _builder.append("\", ");
        if (this.inEventReception) {
            _builder.append(this.eventReceptionPort);
            _builder.append(", ");
            _builder.append(this.eventReceptionConnection);
        } else {
            _builder.append("null, null");
        }
        _builder.append("))");
        return _builder;
    }

    public CharSequence portName(PortSelector s) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        ComponentPart _part = s.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            String _name = s.getPart().getName();
            _builder.append(_name);
            _builder.append(".");
        }
        String _name_1 = s.getPort().getName();
        _builder.append(_name_1);
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(portsContext.connectionAtPortInState(stateOfDecisionClass.get_");
            _builder.append("commaVar_");
            String _name = expr.getIdVar().getVariable().getName();
            _builder.append(_name);
            _builder.append("(), \"");
            CharSequence _portName = this.portName((PortSelector)expr);
            _builder.append((Object)_portName);
            _builder.append("\", new HashSet<>(Arrays.asList(");
            EList _states = expr.getStates();
            boolean _hasElements = false;
            for (State s : _states) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append("\"");
                String _name_1 = s.getName();
                _builder.append(_name_1);
                _builder.append("\"");
            }
            _builder.append(")), ");
            if (this.inEventReception) {
                _builder.append(this.eventReceptionPort);
                _builder.append(", ");
                _builder.append(this.eventReceptionConnection);
            } else {
                _builder.append("null, null");
            }
            _builder.append("))");
            _xifexpression = _builder;
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenation _xifexpression_1 = null;
            Multiplicity _multiplicity = expr.getMultiplicity();
            boolean bl2 = _tripleNotEquals_1 = _multiplicity != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_2;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("(portsContext.someAtPortInState(\"");
                CharSequence _portName_1 = this.portName((PortSelector)expr);
                _builder_1.append((Object)_portName_1);
                _builder_1.append("\", new HashSet<>(Arrays.asList(");
                EList _states_1 = expr.getStates();
                boolean _hasElements_1 = false;
                for (State s_1 : _states_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)", ", "");
                    }
                    _builder_1.append("\"");
                    String _name_2 = s_1.getName();
                    _builder_1.append(_name_2);
                    _builder_1.append("\"");
                }
                _builder_1.append(")), ");
                if (this.inEventReception) {
                    _builder_1.append(this.eventReceptionPort);
                    _builder_1.append(", ");
                    _builder_1.append(this.eventReceptionConnection);
                } else {
                    _builder_1.append("null, null");
                }
                _builder_1.append(", ");
                long _lower = expr.getMultiplicity().getLower();
                _builder_1.append((Object)_lower);
                _builder_1.append(", ");
                String _upperInf = expr.getMultiplicity().getUpperInf();
                boolean bl3 = _tripleNotEquals_2 = _upperInf != null;
                if (_tripleNotEquals_2) {
                    _builder_1.append("-1");
                } else {
                    long _upper = expr.getMultiplicity().getUpper();
                    _builder_1.append((Object)_upper);
                }
                _builder_1.append("))");
                _xifexpression_1 = _builder_1;
            } else {
                CONNECTION_QUANTIFIER _quantifier_2;
                boolean _equals_2;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("(portsContext.");
                CONNECTION_QUANTIFIER _quantifier = expr.getQuantifier();
                boolean _equals = Objects.equal((Object)_quantifier, (Object)CONNECTION_QUANTIFIER.ALL);
                if (_equals) {
                    _builder_2.append("allAtPortInState");
                } else {
                    _builder_2.append("someAtPortInState");
                }
                _builder_2.append("(\"");
                CharSequence _portName_2 = this.portName((PortSelector)expr);
                _builder_2.append((Object)_portName_2);
                _builder_2.append("\", new HashSet<>(Arrays.asList(");
                EList _states_2 = expr.getStates();
                boolean _hasElements_2 = false;
                for (State s_2 : _states_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_2.appendImmediate((Object)", ", "");
                    }
                    _builder_2.append("\"");
                    String _name_3 = s_2.getName();
                    _builder_2.append(_name_3);
                    _builder_2.append("\"");
                }
                _builder_2.append(")), ");
                if (this.inEventReception) {
                    _builder_2.append(this.eventReceptionPort);
                    _builder_2.append(", ");
                    _builder_2.append(this.eventReceptionConnection);
                } else {
                    _builder_2.append("null, null");
                }
                CONNECTION_QUANTIFIER _quantifier_1 = expr.getQuantifier();
                boolean _equals_1 = Objects.equal((Object)_quantifier_1, (Object)CONNECTION_QUANTIFIER.ONE);
                if (_equals_1) {
                    _builder_2.append(", 1, 1");
                }
                if (_equals_2 = Objects.equal((Object)(_quantifier_2 = expr.getQuantifier()), (Object)CONNECTION_QUANTIFIER.SOME)) {
                    _builder_2.append(", 1, -1");
                }
                _builder_2.append("))");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CharSequence componentIdExp(PortSelector e) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("componentInstanceName");
        ComponentPart _part = e.getPart();
        boolean bl = _tripleNotEquals = _part != null;
        if (_tripleNotEquals) {
            _builder.append(" + \".");
            String _name = e.getPart().getName();
            _builder.append(_name);
            _builder.append("\"");
        }
        return _builder;
    }

    public Command getCommand(Reply r) {
        InterfaceEvent _trigger_1;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        CommandEvent _command = r.getCommand();
        boolean bl = _tripleNotEquals = _command != null;
        if (_tripleNotEquals) {
            InterfaceEvent _event = r.getCommand().getEvent();
            return (Command)_event;
        }
        TriggeredTransition transition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class);
        InterfaceEvent _trigger = null;
        if (transition != null) {
            _trigger = transition.getTrigger();
        }
        boolean bl2 = _tripleNotEquals_1 = _trigger != null;
        if (_tripleNotEquals_1 && (_trigger_1 = transition.getTrigger()) instanceof Command) {
            InterfaceEvent _trigger_2 = transition.getTrigger();
            return (Command)_trigger_2;
        }
        return null;
    }

    @Override
    protected CharSequence _generateExpression(ExpressionQuantifier expr) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        Iterable<Variable> parameters = this.filterQuantifierVariables(expr);
        StringConcatenation _builder = new StringConcatenation();
        CommaScope _commaScope = this.getCommaScope((EObject)expr);
        boolean bl = _notEquals = !Objects.equal((Object)((Object)_commaScope), (Object)((Object)CommaScope.TRANSITION));
        if (_notEquals) {
            _builder.append("this.");
        } else {
            _builder.append("stateOfDecisionClass.");
        }
        _builder.append("evalQuantifier");
        int _indexOf = this.quantifiersInMachines.indexOf(expr);
        _builder.append((Object)_indexOf);
        _builder.append("(");
        boolean _hasElements = false;
        for (Variable p : parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CommaScope _commaScope_1 = this.getCommaScope((EObject)p);
            boolean _equals = Objects.equal((Object)((Object)_commaScope_1), (Object)((Object)CommaScope.QUANTIFIER));
            if (_equals) {
                _builder.append("commaQVar_");
                String _name = p.getName();
                _builder.append(_name);
                continue;
            }
            _builder.append("stateOfDecisionClass.get_");
            _builder.append("commaVar_");
            String _get = this.triggerVariables.get(p);
            _builder.append(_get);
            _builder.append("()");
        }
        _builder.append(")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence constraintClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._constraintClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._constraintClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    public CharSequence headOfFragmentMethod(EObject e) {
        if (e instanceof CommandReply) {
            return this._headOfFragmentMethod((CommandReply)e);
        }
        if (e instanceof CommandReplyWithVars) {
            return this._headOfFragmentMethod((CommandReplyWithVars)e);
        }
        if (e instanceof EventCall) {
            return this._headOfFragmentMethod((EventCall)e);
        }
        if (e instanceof EventWithVars) {
            return this._headOfFragmentMethod((EventWithVars)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }

    public CharSequence transitionInStateMethod(Transition t, String stateClassName, int tIndex) {
        if (t instanceof TriggeredTransition) {
            return this._transitionInStateMethod((TriggeredTransition)t, stateClassName, tIndex);
        }
        if (t instanceof NonTriggeredTransition) {
            return this._transitionInStateMethod((NonTriggeredTransition)t, stateClassName, tIndex);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, stateClassName, tIndex).toString());
    }

    public CharSequence n_generateAction(Object a) {
        if (a instanceof AssignmentAction) {
            return this._n_generateAction((AssignmentAction)a);
        }
        if (a instanceof IfAction) {
            return this._n_generateAction((IfAction)a);
        }
        if (a instanceof RecordFieldAssignmentAction) {
            return this._n_generateAction((RecordFieldAssignmentAction)a);
        }
        if (a instanceof FunctionFragmentCall) {
            return this._n_generateAction((FunctionFragmentCall)a);
        }
        if (a instanceof IfHelperAction) {
            return this._n_generateAction((IfHelperAction)a);
        }
        if (a instanceof StateTransitionAction) {
            return this._n_generateAction((StateTransitionAction)a);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a).toString());
    }

    public CharSequence utilityClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._utilityClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._utilityClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    @Override
    public CharSequence generateExpression(Expression expr) {
        if (expr instanceof ExpressionAddition) {
            return this._generateExpression((ExpressionAddition)expr);
        }
        if (expr instanceof ExpressionAnd) {
            return this._generateExpression((ExpressionAnd)expr);
        }
        if (expr instanceof ExpressionBracket) {
            return this._generateExpression((ExpressionBracket)expr);
        }
        if (expr instanceof ExpressionDivision) {
            return this._generateExpression((ExpressionDivision)expr);
        }
        if (expr instanceof ExpressionEqual) {
            return this._generateExpression((ExpressionEqual)expr);
        }
        if (expr instanceof ExpressionGeq) {
            return this._generateExpression((ExpressionGeq)expr);
        }
        if (expr instanceof ExpressionGreater) {
            return this._generateExpression((ExpressionGreater)expr);
        }
        if (expr instanceof ExpressionLeq) {
            return this._generateExpression((ExpressionLeq)expr);
        }
        if (expr instanceof ExpressionLess) {
            return this._generateExpression((ExpressionLess)expr);
        }
        if (expr instanceof ExpressionMaximum) {
            return this._generateExpression((ExpressionMaximum)expr);
        }
        if (expr instanceof ExpressionMinimum) {
            return this._generateExpression((ExpressionMinimum)expr);
        }
        if (expr instanceof ExpressionMinus) {
            return this._generateExpression((ExpressionMinus)expr);
        }
        if (expr instanceof ExpressionModulo) {
            return this._generateExpression((ExpressionModulo)expr);
        }
        if (expr instanceof ExpressionMultiply) {
            return this._generateExpression((ExpressionMultiply)expr);
        }
        if (expr instanceof ExpressionNEqual) {
            return this._generateExpression((ExpressionNEqual)expr);
        }
        if (expr instanceof ExpressionNot) {
            return this._generateExpression((ExpressionNot)expr);
        }
        if (expr instanceof ExpressionOr) {
            return this._generateExpression((ExpressionOr)expr);
        }
        if (expr instanceof ExpressionPlus) {
            return this._generateExpression((ExpressionPlus)expr);
        }
        if (expr instanceof ExpressionPower) {
            return this._generateExpression((ExpressionPower)expr);
        }
        if (expr instanceof ExpressionSubtraction) {
            return this._generateExpression((ExpressionSubtraction)expr);
        }
        if (expr instanceof ExpressionConnectionState) {
            return this._generateExpression((ExpressionConnectionState)expr);
        }
        if (expr instanceof ExpressionInterfaceState) {
            return this._generateExpression((ExpressionInterfaceState)expr);
        }
        if (expr instanceof ExpressionAny) {
            return this._generateExpression((ExpressionAny)expr);
        }
        if (expr instanceof ExpressionBulkData) {
            return this._generateExpression((ExpressionBulkData)expr);
        }
        if (expr instanceof ExpressionConstantBool) {
            return this._generateExpression((ExpressionConstantBool)expr);
        }
        if (expr instanceof ExpressionConstantInt) {
            return this._generateExpression((ExpressionConstantInt)expr);
        }
        if (expr instanceof ExpressionConstantReal) {
            return this._generateExpression((ExpressionConstantReal)expr);
        }
        if (expr instanceof ExpressionConstantString) {
            return this._generateExpression((ExpressionConstantString)expr);
        }
        if (expr instanceof ExpressionEnumLiteral) {
            return this._generateExpression((ExpressionEnumLiteral)expr);
        }
        if (expr instanceof ExpressionFunctionCall) {
            return this._generateExpression((ExpressionFunctionCall)expr);
        }
        if (expr instanceof ExpressionMap) {
            return this._generateExpression((ExpressionMap)expr);
        }
        if (expr instanceof ExpressionMapRW) {
            return this._generateExpression((ExpressionMapRW)expr);
        }
        if (expr instanceof ExpressionQuantifier) {
            return this._generateExpression((ExpressionQuantifier)expr);
        }
        if (expr instanceof ExpressionRecord) {
            return this._generateExpression((ExpressionRecord)expr);
        }
        if (expr instanceof ExpressionRecordAccess) {
            return this._generateExpression((ExpressionRecordAccess)expr);
        }
        if (expr instanceof ExpressionVariable) {
            return this._generateExpression((ExpressionVariable)expr);
        }
        if (expr instanceof ExpressionVector) {
            return this._generateExpression((ExpressionVector)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

