/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.annotations.Expose;
import java.util.LinkedHashMap;
import java.util.Map;

public class CCoverageInfo {
    @Expose
    private String interfaceName = "";
    @Expose
    private Map<String, Integer> transitionCoverage = new LinkedHashMap<String, Integer>();
    @Expose
    private Map<String, Integer> stateCoverage = new LinkedHashMap<String, Integer>();
    @Expose
    private long transitionCoveragePercentage = 0L;
    @Expose
    private long stateCoveragePercentage = 0L;

    public void setInterfaceName(String name) {
        this.interfaceName = name;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setTransitionCoverage(Map<String, Integer> coverage) {
        this.transitionCoverage = coverage;
    }

    public Map<String, Integer> getTransitionCoverage() {
        return this.transitionCoverage;
    }

    public void setStateCoverage(Map<String, Integer> coverage) {
        this.stateCoverage = coverage;
    }

    public Map<String, Integer> getStateCoverage() {
        return this.stateCoverage;
    }

    public void setTransitionCoveragePercentage(int percentage) {
        this.transitionCoveragePercentage = percentage;
    }

    public long getTransitionCoveragePercentage() {
        return this.transitionCoveragePercentage;
    }

    public void setStateCoveragePercentage(int percentage) {
        this.stateCoveragePercentage = percentage;
    }

    public long getStateCoveragePercentage() {
        return this.stateCoveragePercentage;
    }

    public void calculateCoveragePercentage() {
        this.transitionCoveragePercentage = Math.round((double)this.transitionCoverage.values().stream().filter(v -> v > 0).count() * 100.0 / (double)this.transitionCoverage.size());
        this.stateCoveragePercentage = Math.round((double)this.stateCoverage.values().stream().filter(v -> v > 0).count() * 100.0 / (double)this.stateCoverage.size());
    }

    public void union(CCoverageInfo cInfo) {
        for (String key : cInfo.getTransitionCoverage().keySet()) {
            this.transitionCoverage.put(key, this.transitionCoverage.containsKey(key) ? this.transitionCoverage.get(key) + cInfo.getTransitionCoverage().get(key) : cInfo.getTransitionCoverage().get(key));
        }
        for (String key : cInfo.getStateCoverage().keySet()) {
            this.stateCoverage.put(key, this.stateCoverage.containsKey(key) ? this.stateCoverage.get(key) + cInfo.getStateCoverage().get(key) : cInfo.getStateCoverage().get(key));
        }
        this.calculateCoveragePercentage();
    }
}

