/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.python;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class PythonInterpreter {
    private static String executable;

    public static String execute(String script) {
        PythonInterpreter.loadExecutableIfNotLoaded();
        try {
            File tempFile = File.createTempFile("commasuite", "py");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            writer.write(script);
            writer.close();
            tempFile.deleteOnExit();
            ProcessBuilder pb = new ProcessBuilder(executable, tempFile.getAbsolutePath());
            Process process = pb.start();
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            PythonInterpreter.startOutConsumerThread(process.getInputStream(), stdout);
            PythonInterpreter.startOutConsumerThread(process.getErrorStream(), stderr);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new Exception(stderr.toString());
            }
            return stdout.toString();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new RuntimeException("Python execution failed: " + e.getMessage(), e);
        }
    }

    private static void startOutConsumerThread(final InputStream stream, final StringBuilder builder) {
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        if (builder.length() != 0) {
                            builder.append("\n");
                        }
                        builder.append(line);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * Unable to fully structure code
     */
    private static void loadExecutableIfNotLoaded() {
        block19: {
            if (PythonInterpreter.executable != null) {
                return;
            }
            os = System.getProperty("os.name").toLowerCase();
            pkg = null;
            exec = null;
            if (os.startsWith("windows")) {
                pkg = "org.eclipse.comma.python.win32.x86_64";
                exec = "dist/python.exe";
            } else if (os.startsWith("linux")) {
                pkg = "org.eclipse.comma.python.linux.x86_64";
                exec = "dist/python";
            } else if (os.startsWith("mac")) {
                pkg = "org.eclipse.comma.python.macosx.x86_64";
                exec = "dist/python";
            } else {
                throw new RuntimeException("PythonInterpreter does not support OS: " + os);
            }
            try {
                try {
                    rsc = Platform.getBundle((String)pkg).getResource(exec);
                    PythonInterpreter.executable = FileLocator.toFileURL((URL)rsc).getPath();
                    break block19;
                }
                catch (Exception e) {
                    sourceLocation = new File(PythonInterpreter.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    if (sourceLocation.isDirectory()) {
                        PythonInterpreter.executable = Paths.get(sourceLocation.getAbsolutePath(), new String[]{"..", "..", "..", pkg, exec}).toAbsolutePath().toString();
                        break block19;
                    }
                    if (!sourceLocation.getAbsolutePath().toLowerCase().endsWith(".jar")) break block19;
                    execFile = Paths.get(sourceLocation.getParentFile().getAbsolutePath(), new String[]{"..", "..", pkg, exec}).toFile();
                    if (execFile.isFile()) {
                        PythonInterpreter.executable = execFile.getAbsolutePath().toString();
                        break block19;
                    }
                    tempDir = Files.createTempDirectory("commapython", new FileAttribute[0]).toFile();
                    tempDir.deleteOnExit();
                    destDir = tempDir.getAbsolutePath();
                    jar = new JarFile(sourceLocation);
                    enumEntries = jar.entries();
                    ** while (enumEntries.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    entry = enumEntries.nextElement();
                    if (!entry.getName().startsWith(pkg)) continue;
                    file = new File(String.valueOf(destDir) + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    is = jar.getInputStream(entry);
                    fos = new FileOutputStream(file);
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                    fos.close();
                    is.close();
                    continue;
                }
lbl55:
                // 1 sources

                jar.close();
                PythonInterpreter.executable = Paths.get(destDir, new String[]{pkg, exec}).toAbsolutePath().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to load Python interpeter", e);
            }
        }
        if (os.startsWith("linux") || os.startsWith("mac")) {
            try {
                new ProcessBuilder(new String[0]).command(new String[]{"chmod", "+x", PythonInterpreter.executable}).start().waitFor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

