/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
import * as models from "./Models";
/**
 * The purpose of this class is to initiate and maintain the WebSocket
 * connection between the filewatcher and the server.
 *
 * After queueEstablishConnection(...) is called, we will keep trying to connect
 * to the server until it succeeds. If that connection ever goes down for any
 * reason, queueEstablishConnection() still start the reconnection process over
 * again.
 *
 * This class also sends a simple "keep alive" packet every X seconds (eg 25).
 */
export declare class WebSocketManagerThread {
    private static readonly SEND_KEEPALIVE_EVERY_X_SECONDS;
    private readonly _wsBaseUrl;
    private readonly _parent;
    /** Maintains a reference to the previous websocket, to ensure it is closed when we open a new one */
    private _previousWebSocket;
    private _previousWebSocketInterval;
    private _attemptingToEstablish;
    private _disposed;
    constructor(wsBaseUrl: string, parent: FileWatcher);
    queueEstablishConnection(): void;
    dispose(): void;
    private disposeWebSocketAsync;
    /**
     * If the websocket connection fails, we should issue a new GET request to
     * ensure we have the latest state.
     */
    private refreshWatchStatus;
    private establishOrReestablishConnectionAsync;
    private receiveMessage;
    private handleDebug;
}
export interface IWatchChangeJson {
    projects: models.IWatchedProjectJson[];
    type: string;
}
