/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EnableDisableProjectAction
extends SelectionProviderAction {
    protected CodewindEclipseApplication app;

    public EnableDisableProjectAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.DisableProjectLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable()) {
                this.setText(Messages.DisableProjectLabel);
            } else {
                this.setText(Messages.EnableProjectLabel);
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"EnableDisableProjectAction ran but no application was selected");
            return;
        }
        EnableDisableProjectAction.enableDisableProject((CodewindApplication)this.app, !this.app.isEnabled());
    }

    public static void enableDisableProject(final CodewindApplication app, final boolean enable) {
        Job job = new Job(NLS.bind((String)Messages.EnableDisableProjectJob, (Object)app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    app.connection.requestProjectOpenClose(app, enable);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred updating enablement for: " + app.name + ", with id: " + app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ErrorOnEnableDisableProject, (Object)app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }
}

