/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.ui.internal.actions.BindAction;
import org.eclipse.codewind.ui.internal.actions.ConnectDisconnectAction;
import org.eclipse.codewind.ui.internal.actions.ManageReposAction;
import org.eclipse.codewind.ui.internal.actions.NewProjectAction;
import org.eclipse.codewind.ui.internal.actions.RemoveConnectionAction;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RemoteConnectionActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private NewProjectAction newProjectAction;
    private BindAction bindAction;
    private ManageReposAction manageReposAction;
    private ConnectDisconnectAction connectDisconnectAction;
    private RemoveConnectionAction removeConnectionAction;
    private RemoteDoubleClickAction remoteDoubleClickAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.newProjectAction = new NewProjectAction(this.selProvider);
        this.bindAction = new BindAction(this.selProvider);
        this.manageReposAction = new ManageReposAction(this.selProvider);
        this.connectDisconnectAction = new ConnectDisconnectAction(this.selProvider);
        this.removeConnectionAction = new RemoveConnectionAction(this.selProvider);
        this.remoteDoubleClickAction = new RemoteDoubleClickAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.selProvider.setSelection(this.selProvider.getSelection());
        menu.appendToGroup("group.new", (IAction)this.newProjectAction);
        menu.appendToGroup("group.new", (IAction)this.bindAction);
        menu.appendToGroup("group.generate", (IAction)this.manageReposAction);
        menu.appendToGroup("additions", (IAction)this.connectDisconnectAction);
        menu.appendToGroup("additions", (IAction)this.removeConnectionAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.remoteDoubleClickAction);
    }

    private static class RemoteDoubleClickAction
    extends SelectionProviderAction {
        RemoteConnection connection = null;

        public RemoteDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            Object obj;
            if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof RemoteConnection) {
                this.connection = (RemoteConnection)obj;
                return;
            }
            this.connection = null;
        }

        public void run() {
            if (this.connection != null) {
                if (!this.connection.isConnected()) {
                    ConnectDisconnectAction.connectRemoteCodewind(this.connection);
                } else {
                    ViewHelper.toggleExpansion(this.connection);
                }
            }
        }
    }
}

