/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.codewind.core.internal.cli.LogLevels;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogLevelSelectionDialog
extends TitleAreaDialog {
    private final LogLevels logLevels;
    private String selectedLevel = null;
    private List<String> levelList;
    private List<String> levelLabels;
    private int currentLevel = -1;

    public LogLevelSelectionDialog(Shell parentShell, LogLevels logLevels) {
        super(parentShell);
        this.logLevels = logLevels;
        this.selectedLevel = logLevels.getCurrentLevel();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LogLevelDialogShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.LogLevelDialogTitle);
        this.setMessage(Messages.LogLevelDialogMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Messages.LogLevelDialogLogLabel);
        this.initLevels();
        final Combo logLevelCombo = new Combo(composite, 8);
        logLevelCombo.setItems(this.levelLabels.toArray(new String[this.levelLabels.size()]));
        logLevelCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        logLevelCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int index = logLevelCombo.getSelectionIndex();
                if (index >= 0) {
                    LogLevelSelectionDialog.this.selectedLevel = (String)LogLevelSelectionDialog.this.levelList.get(index);
                }
            }
        });
        if (this.currentLevel >= 0) {
            logLevelCombo.select(this.currentLevel);
        }
        return composite;
    }

    private void initLevels() {
        this.levelList = this.logLevels.getAllLevels();
        Collections.sort(this.levelList);
        this.levelLabels = new ArrayList<String>(this.levelList.size());
        for (int i = 0; i < this.levelList.size(); ++i) {
            String level;
            String label = level = this.levelList.get(i);
            if (level.equals(this.logLevels.getDefaultLevel())) {
                label = label + " " + Messages.LogLevelDialogLogDefault;
            }
            if (level.equals(this.logLevels.getCurrentLevel())) {
                this.currentLevel = i;
            }
            this.levelLabels.add(label);
        }
    }

    public String getSelectedLevel() {
        return this.selectedLevel;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(750, point.y);
    }
}

