/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.actions.BindAction;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.InstallerAction;
import org.eclipse.codewind.ui.internal.actions.LogLevelAction;
import org.eclipse.codewind.ui.internal.actions.ManageReposAction;
import org.eclipse.codewind.ui.internal.actions.NewProjectAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class LocalConnectionActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private InstallerAction installUninstallAction;
    private InstallerAction startStopAction;
    private NewProjectAction newProjectAction;
    private BindAction bindAction;
    private ManageReposAction manageReposAction;
    private CodewindDoubleClickAction doubleClickAction;
    private LogLevelAction logLevelAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.newProjectAction = new NewProjectAction(this.selProvider);
        this.bindAction = new BindAction(this.selProvider);
        this.manageReposAction = new ManageReposAction(this.selProvider);
        this.installUninstallAction = new InstallerAction(InstallerAction.ActionType.INSTALL_UNINSTALL, this.selProvider);
        this.startStopAction = new InstallerAction(InstallerAction.ActionType.START_STOP, this.selProvider);
        this.doubleClickAction = new CodewindDoubleClickAction(this.selProvider);
        this.logLevelAction = new LogLevelAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (CodewindManager.getManager().getInstallerStatus() != null) {
            return;
        }
        this.selProvider.setSelection(this.selProvider.getSelection());
        menu.appendToGroup("group.new", (IAction)this.newProjectAction);
        menu.appendToGroup("group.new", (IAction)this.bindAction);
        menu.appendToGroup("group.generate", (IAction)this.manageReposAction);
        InstallStatus status = CodewindManager.getManager().getInstallStatus();
        menu.appendToGroup("additions", (IAction)this.installUninstallAction);
        if (status.isInstalled()) {
            menu.appendToGroup("additions", (IAction)this.startStopAction);
        }
        if (this.logLevelAction.showAction()) {
            menu.appendToGroup("group.properties", (IAction)this.logLevelAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    private static class CodewindDoubleClickAction
    extends SelectionProviderAction {
        LocalConnection connection = null;

        public CodewindDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            Object obj;
            if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof LocalConnection) {
                this.connection = (LocalConnection)obj;
                return;
            }
            this.connection = null;
        }

        public void run() {
            if (this.connection != null) {
                CodewindManager manager = CodewindManager.getManager();
                InstallStatus status = manager.getInstallStatus();
                if (status.isStarted()) {
                    ViewHelper.toggleExpansion(this.connection);
                } else if (status.isInstalled()) {
                    CodewindInstall.startCodewind(status.getVersion(), null);
                } else if (status.hasInstalledVersions()) {
                    boolean result = IDEUtil.openConfirmDialog(Messages.UpdateCodewindDialogTitle, Messages.UpdateCodewindDialogMsg);
                    if (result) {
                        CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, null);
                    }
                } else if (!status.isUnknown()) {
                    CodewindInstall.installCodewind(InstallUtil.getVersion(), null);
                }
            }
        }
    }
}

