/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=fi

/**
 * Implementation of DateTimeFormatInfo for the "fi" locale.
 */
public class DateTimeFormatInfoImpl_fi extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ap.",
        "ip."
    };
  }

  @Override
  public String dateFormatFull() {
    return "cccc d. MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d. MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d.M.y";
  }

  @Override
  public String dateFormatShort() {
    return "d.M.y";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ennen Kristuksen syntymää",
        "jälkeen Kristuksen syntymän"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "eKr.",
        "jKr."
    };
  }

  @Override
  public String formatHour12Minute() {
    return "h.mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h.mm.ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "H.mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H.mm.ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "m.ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d. MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d. MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "cccc d. MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d.M.";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "LLL y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d. MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "LLLL y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d. MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "L.y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.M.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE d. MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "tammikuuta",
        "helmikuuta",
        "maaliskuuta",
        "huhtikuuta",
        "toukokuuta",
        "kesäkuuta",
        "heinäkuuta",
        "elokuuta",
        "syyskuuta",
        "lokakuuta",
        "marraskuuta",
        "joulukuuta"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "tammikuu",
        "helmikuu",
        "maaliskuu",
        "huhtikuu",
        "toukokuu",
        "kesäkuu",
        "heinäkuu",
        "elokuu",
        "syyskuu",
        "lokakuu",
        "marraskuu",
        "joulukuu"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "T",
        "H",
        "M",
        "H",
        "T",
        "K",
        "H",
        "E",
        "S",
        "L",
        "M",
        "J"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "tammikuuta",
        "helmikuuta",
        "maaliskuuta",
        "huhtikuuta",
        "toukokuuta",
        "kesäkuuta",
        "heinäkuuta",
        "elokuuta",
        "syyskuuta",
        "lokakuuta",
        "marraskuuta",
        "joulukuuta"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "tammi",
        "helmi",
        "maalis",
        "huhti",
        "touko",
        "kesä",
        "heinä",
        "elo",
        "syys",
        "loka",
        "marras",
        "joulu"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. neljännes",
        "2. neljännes",
        "3. neljännes",
        "4. neljännes"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1. nelj.",
        "2. nelj.",
        "3. nelj.",
        "4. nelj."
    };
  }

  @Override
  public String timeFormatFull() {
    return "H.mm.ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "H.mm.ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "H.mm.ss";
  }

  @Override
  public String timeFormatShort() {
    return "H.mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "sunnuntaina",
        "maanantaina",
        "tiistaina",
        "keskiviikkona",
        "torstaina",
        "perjantaina",
        "lauantaina"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "sunnuntai",
        "maanantai",
        "tiistai",
        "keskiviikko",
        "torstai",
        "perjantai",
        "lauantai"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "M",
        "T",
        "K",
        "T",
        "P",
        "L"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "su",
        "ma",
        "ti",
        "ke",
        "to",
        "pe",
        "la"
    };
  }
}
