/**********************************************
 * Copyright (C) 2010 Lukas Laag
 * This file is part of lib-gwt-svg.
 * 
 * libgwtsvg is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgwtsvg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgwtsvg.  If not, see http://www.gnu.org/licenses/
 **********************************************/
/*
 * Copyright (c) 2004 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */
package org.vectomatic.dom.svg.utils;

/**
 * Class to define constants commonly used in CSS, SVG and XLink
 */
public interface SVGConstants {
	
    /////////////////////////////////////////////////////////////////////////
    // XML general
    /////////////////////////////////////////////////////////////////////////
    String XML_PREFIX = "xml";
    String XMLNS_PREFIX = "xmlns";
    String XML_ID_ATTRIBUTE = "id";

    /////////////////////////////////////////////////////////////////////////
    // SVG general
    /////////////////////////////////////////////////////////////////////////

    String SVG_PUBLIC_ID = "-//W3C//DTD SVG 1.1//EN";
    String SVG_SYSTEM_ID = "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd";
    String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    String SVG_PREFIX = "svg";
    String SVG_VERSION = "1.1";

    /////////////////////////////////////////////////////////////////////////
    // XLink tag and attributes
    /////////////////////////////////////////////////////////////////////////

    String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    String XLINK_PREFIX = "xlink";
    String XLINK_HREF_ATTRIBUTE = "href";

    /////////////////////////////////////////////////////////////////////////
    // CSS tags (must use camel case as they will be set from javascript)
    /////////////////////////////////////////////////////////////////////////

    String CSS_ALIGNMENT_BASELINE_PROPERTY = "alignment-baseline";
    String CSS_BASELINE_SHIFT_PROPERTY = "baseline-shift";        
    String CSS_CLIP_PROPERTY = "clip";                            
    String CSS_CLIP_PATH_PROPERTY = "clip-path";                  
    String CSS_CLIP_RULE_PROPERTY = "clip-rule";                  
    String CSS_COLOR_PROFILE_PROPERTY = "color-profile";          
    String CSS_COLOR_PROPERTY = "color";                          
    String CSS_COLOR_INTERPOLATION_PROPERTY = "color-interpolation";
    String CSS_COLOR_INTERPOLATION_FILTERS_PROPERTY = "color-interpolation-filters";                                                                        
    String CSS_COLOR_RENDERING_PROPERTY = "color-rendering";                  
    String CSS_CURSOR_PROPERTY = "cursor";                                    
    String CSS_DIRECTION_PROPERTY = "direction";                              
    String CSS_DISPLAY_PROPERTY = "display";                                  
    String CSS_DOMINANT_BASELINE_PROPERTY = "dominant-baseline";              
    String CSS_ENABLE_BACKGROUND_PROPERTY = "enable-background";              
    String CSS_FILL_OPACITY_PROPERTY = "fill-opacity";                        
    String CSS_FILL_PROPERTY = "fill";                                        
    String CSS_FILL_RULE_PROPERTY = "fill-rule";                              
    String CSS_FILTER_PROPERTY = "filter";                                    
    String CSS_FLOOD_COLOR_PROPERTY = "flood-color";                          
    String CSS_FLOOD_OPACITY_PROPERTY = "flood-opacity";                      
    String CSS_FONT_PROPERTY = "font";                                        
    String CSS_FONT_FAMILY_PROPERTY = "font-family";                          
    String CSS_FONT_SIZE_PROPERTY = "font-size";                              
    String CSS_FONT_SIZE_ADJUST_PROPERTY = "font-size-adjust";                
    String CSS_FONT_STRETCH_PROPERTY = "font-stretch";                        
    String CSS_FONT_STYLE_PROPERTY = "font-style";                            
    String CSS_FONT_VARIANT_PROPERTY = "font-variant";                        
    String CSS_FONT_WEIGHT_PROPERTY = "font-weight";                          
    String CSS_GLYPH_ORIENTATION_HORIZONTAL_PROPERTY = "glyph-orientation-horizontal";                                                                      
    String CSS_GLYPH_ORIENTATION_VERTICAL_PROPERTY = "glyph-orientation-vertical";                                                                          
    String CSS_IMAGE_RENDERING_PROPERTY = "image-rendering";                  
    String CSS_KERNING_PROPERTY = "kerning";                                  
    String CSS_LETTER_SPACING_PROPERTY = "letter-spacing";                    
    String CSS_LIGHTING_COLOR_PROPERTY = "lighting-color";                    
    String CSS_LINE_HEIGHT_PROPERTY = "line-height";                          
    String CSS_MARKER_PROPERTY = "marker";                                    
    String CSS_MARKER_END_PROPERTY = "marker-end";                            
    String CSS_MARKER_MID_PROPERTY = "marker-mid";                            
    String CSS_MARKER_START_PROPERTY = "marker-start";                        
    String CSS_MASK_PROPERTY = "mask";                                        
    String CSS_OPACITY_PROPERTY = "opacity";                                  
    String CSS_OVERFLOW_PROPERTY = "overflow";                                
    String CSS_POINTER_EVENTS_PROPERTY = "pointer-events";                    
    String CSS_SHAPE_RENDERING_PROPERTY = "shape-rendering";                  
    String CSS_SRC_PROPERTY = "src";                                          
    String CSS_STOP_COLOR_PROPERTY = "stop-color";                            
    String CSS_STOP_OPACITY_PROPERTY = "stop-opacity";                        
    String CSS_STROKE_PROPERTY = "stroke";                                    
    String CSS_STROKE_DASHARRAY_PROPERTY = "stroke-dasharray";                
    String CSS_STROKE_DASHOFFSET_PROPERTY = "stroke-dashoffset";              
    String CSS_STROKE_LINECAP_PROPERTY = "stroke-linecap";                    
    String CSS_STROKE_LINEJOIN_PROPERTY = "stroke-linejoin";                  
    String CSS_STROKE_MITERLIMIT_PROPERTY = "stroke-miterlimit";              
    String CSS_STROKE_OPACITY_PROPERTY = "stroke-opacity";                    
    String CSS_STROKE_WIDTH_PROPERTY = "stroke-width";                        
    String CSS_TEXT_ANCHOR_PROPERTY = "text-anchor";                          
    String CSS_TEXT_DECORATION_PROPERTY = "text-decoration";                  
    String CSS_TEXT_RENDERING_PROPERTY = "text-rendering";                    
    String CSS_UNICODE_BIDI_PROPERTY = "unicode-bidi";                        
    String CSS_VISIBILITY_PROPERTY = "visibility";                            
    String CSS_WORD_SPACING_PROPERTY = "word-spacing";                        
    String CSS_WRITING_MODE_PROPERTY = "writing-mode";
    
    /////////////////////////////////////////////////////////////////////////
    // The CSS property values.
    /////////////////////////////////////////////////////////////////////////
    String CSS_ACCUMULATE_VALUE = "accumulate";
    String CSS_ACTIVEBORDER_VALUE = "activeborder";
    String CSS_ACTIVECAPTION_VALUE = "activecaption";
    String CSS_AFTER_EDGE_VALUE = "after-edge";
    String CSS_ALICEBLUE_VALUE = "aliceblue";
    String CSS_ALL_VALUE = "all";
    String CSS_ALPHABETIC_VALUE = "alphabetic";
    String CSS_ANTIQUEWHITE_VALUE = "antiquewhite";
    String CSS_APPWORKSPACE_VALUE = "appworkspace";
    String CSS_AQUAMARINE_VALUE = "aquamarine";
    String CSS_AQUA_VALUE = "aqua";
    String CSS_AUTOSENSE_SCRIPT_VALUE = "autosense-script";
    String CSS_AUTO_VALUE = "auto";
    String CSS_AZURE_VALUE = "azure";
    String CSS_BACKGROUND_VALUE = "background";
    String CSS_BASELINE_VALUE = "baseline";
    String CSS_BEFORE_EDGE_VALUE = "before-edge";
    String CSS_BEIGE_VALUE = "beige";
    String CSS_BEVEL_VALUE = "bevel";
    String CSS_BIDI_OVERRIDE_VALUE = "bidi-override";
    String CSS_BISQUE_VALUE = "bisque";
    String CSS_BLACK_VALUE = "black";
    String CSS_BLANCHEDALMOND_VALUE = "blanchedalmond";
    String CSS_BLINK_VALUE = "blink";
    String CSS_BLOCK_VALUE = "block";
    String CSS_BLUEVIOLET_VALUE = "blueviolet";
    String CSS_BLUE_VALUE = "blue";
    String CSS_BOLDER_VALUE = "bolder";
    String CSS_BOLD_VALUE = "bold";
    String CSS_BOTTOM_VALUE = "bottom";
    String CSS_BROWN_VALUE = "brown";
    String CSS_BURLYWOOD_VALUE = "burlywood";
    String CSS_BUTTONFACE_VALUE = "buttonface";
    String CSS_BUTTONHIGHLIGHT_VALUE = "buttonhighlight";
    String CSS_BUTTONSHADOW_VALUE = "buttonshadow";
    String CSS_BUTTONTEXT_VALUE = "buttontext";
    String CSS_BUTT_VALUE = "butt";
    String CSS_CADETBLUE_VALUE = "cadetblue";
    String CSS_CAPTIONTEXT_VALUE = "captiontext";
    String CSS_CAPTION_VALUE = "caption";
    String CSS_CENTER_VALUE = "center";
    String CSS_CENTRAL_VALUE = "central";
    String CSS_CHARTREUSE_VALUE = "chartreuse";
    String CSS_CHOCOLATE_VALUE = "chocolate";
    String CSS_COLLAPSE_VALUE = "collapse";
    String CSS_COMPACT_VALUE = "compact";
    String CSS_CONDENSED_VALUE = "condensed";
    String CSS_CORAL_VALUE = "coral";
    String CSS_CORNFLOWERBLUE_VALUE = "cornflowerblue";
    String CSS_CORNSILK_VALUE = "cornsilk";
    String CSS_CRIMSON_VALUE = "crimson";
    String CSS_CRISPEDGES_VALUE = "crispedges";
    String CSS_CROSSHAIR_VALUE = "crosshair";
    String CSS_CURRENTCOLOR_VALUE = "currentColor";
    String CSS_CURSIVE_VALUE = "cursive";
    String CSS_CYAN_VALUE = "cyan";
    String CSS_DARKBLUE_VALUE = "darkblue";
    String CSS_DARKCYAN_VALUE = "darkcyan";
    String CSS_DARKGOLDENROD_VALUE = "darkgoldenrod";
    String CSS_DARKGRAY_VALUE = "darkgray";
    String CSS_DARKGREEN_VALUE = "darkgreen";
    String CSS_DARKGREY_VALUE = "darkgrey";
    String CSS_DARKKHAKI_VALUE = "darkkhaki";
    String CSS_DARKMAGENTA_VALUE = "darkmagenta";
    String CSS_DARKOLIVEGREEN_VALUE = "darkolivegreen";
    String CSS_DARKORANGE_VALUE = "darkorange";
    String CSS_DARKORCHID_VALUE = "darkorchid";
    String CSS_DARKRED_VALUE = "darkred";
    String CSS_DARKSALMON_VALUE = "darksalmon";
    String CSS_DARKSEAGREEN_VALUE = "darkseagreen";
    String CSS_DARKSLATEBLUE_VALUE = "darkslateblue";
    String CSS_DARKSLATEGRAY_VALUE = "darkslategray";
    String CSS_DARKSLATEGREY_VALUE = "darkslategrey";
    String CSS_DARKTURQUOISE_VALUE = "darkturquoise";
    String CSS_DARKVIOLET_VALUE = "darkviolet";
    String CSS_DEEPPINK_VALUE = "deeppink";
    String CSS_DEEPSKYBLUE_VALUE = "deepskyblue";
    String CSS_DEFAULT_VALUE = "default";
    String CSS_DIMGRAY_VALUE = "dimgray";
    String CSS_DIMGREY_VALUE = "dimgrey";
    String CSS_DODGERBLUE_VALUE = "dodgerblue";
    String CSS_EMBED_VALUE = "embed";
    String CSS_END_VALUE = "end";
    String CSS_EVENODD_VALUE = "evenodd";
    String CSS_EXPANDED_VALUE = "expanded";
    String CSS_EXTRA_CONDENSED_VALUE = "extra-condensed";
    String CSS_EXTRA_EXPANDED_VALUE = "extra-expanded";
    String CSS_E_RESIZE_VALUE = "e-resize";
    String CSS_FANTASY_VALUE = "fantasy";
    String CSS_FILLSTROKE_VALUE = "fillstroke";
    String CSS_FILL_VALUE = "fill";
    String CSS_FIREBRICK_VALUE = "firebrick";
    String CSS_FLORALWHITE_VALUE = "floralwhite";
    String CSS_FORESTGREEN_VALUE = "forestgreen";
    String CSS_FUCHSIA_VALUE = "fuchsia";
    String CSS_GAINSBORO_VALUE = "gainsboro";
    String CSS_GEOMETRICPRECISION_VALUE = "geometricprecision";
    String CSS_GHOSTWHITE_VALUE = "ghostwhite";
    String CSS_GOLDENROD_VALUE = "goldenrod";
    String CSS_GOLD_VALUE = "gold";
    String CSS_GRAYTEXT_VALUE = "graytext";
    String CSS_GRAY_VALUE = "gray";
    String CSS_GREENYELLOW_VALUE = "greenyellow";
    String CSS_GREEN_VALUE = "green";
    String CSS_GREY_VALUE = "grey";
    String CSS_HANGING_VALUE = "hanging";
    String CSS_HELP_VALUE = "help";
    String CSS_HIDDEN_VALUE = "hidden";
    String CSS_HIGHLIGHTTEXT_VALUE = "highlighttext";
    String CSS_HIGHLIGHT_VALUE = "highlight";
    String CSS_HONEYDEW_VALUE = "honeydew";
    String CSS_HOTPINK_VALUE = "hotpink";
    String CSS_ICON_VALUE = "icon";
    String CSS_IDEOGRAPHIC_VALUE = "ideographic";
    String CSS_INACTIVEBORDER_VALUE = "inactiveborder";
    String CSS_INACTIVECAPTIONTEXT_VALUE = "inactivecaptiontext";
    String CSS_INACTIVECAPTION_VALUE = "inactivecaption";
    String CSS_INDIANRED_VALUE = "indianred";
    String CSS_INDIGO_VALUE = "indigo";
    String CSS_INFOBACKGROUND_VALUE = "infobackground";
    String CSS_INFOTEXT_VALUE = "infotext";
    String CSS_INHERIT_VALUE = "inherit";
    String CSS_INLINE_TABLE_VALUE = "inline-table";
    String CSS_INLINE_VALUE = "inline";
    String CSS_ITALIC_VALUE = "italic";
    String CSS_IVORY_VALUE = "ivory";
    String CSS_KHAKI_VALUE = "khaki";
    String CSS_LARGER_VALUE = "larger";
    String CSS_LARGE_VALUE = "large";
    String CSS_LAVENDERBLUSH_VALUE = "lavenderblush";
    String CSS_LAVENDER_VALUE = "lavender";
    String CSS_LAWNGREEN_VALUE = "lawngreen";
    String CSS_LEMONCHIFFON_VALUE = "lemonchiffon";
    String CSS_LIGHTBLUE_VALUE = "lightblue";
    String CSS_LIGHTCORAL_VALUE = "lightcoral";
    String CSS_LIGHTCYAN_VALUE = "lightcyan";
    String CSS_LIGHTER_VALUE = "lighter";
    String CSS_LIGHTGOLDENRODYELLOW_VALUE = "lightgoldenrodyellow";
    String CSS_LIGHTGRAY_VALUE = "lightgray";
    String CSS_LIGHTGREEN_VALUE = "lightgreen";
    String CSS_LIGHTGREY_VALUE = "lightgrey";
    String CSS_LIGHTPINK_VALUE = "lightpink";
    String CSS_LIGHTSALMON_VALUE = "lightsalmon";
    String CSS_LIGHTSEAGREEN_VALUE = "lightseagreen";
    String CSS_LIGHTSKYBLUE_VALUE = "lightskyblue";
    String CSS_LIGHTSLATEGRAY_VALUE = "lightslategray";
    String CSS_LIGHTSLATEGREY_VALUE = "lightslategrey";
    String CSS_LIGHTSTEELBLUE_VALUE = "lightsteelblue";
    String CSS_LIGHTYELLOW_VALUE = "lightyellow";
    String CSS_LIMEGREEN_VALUE = "limegreen";
    String CSS_LIME_VALUE = "lime";
    String CSS_LINEARRGB_VALUE = "linearrgb";
    String CSS_LINEN_VALUE = "linen";
    String CSS_LINE_THROUGH_VALUE = "line-through";
    String CSS_LIST_ITEM_VALUE = "list-item";
    String CSS_LOWER_VALUE = "lower";
    String CSS_LR_TB_VALUE = "lr-tb";
    String CSS_LR_VALUE = "lr";
    String CSS_LTR_VALUE = "ltr";
    String CSS_MAGENTA_VALUE = "magenta";
    String CSS_MARKER_VALUE = "marker";
    String CSS_MAROON_VALUE = "maroon";
    String CSS_MATHEMATICAL_VALUE = "mathematical";
    String CSS_MEDIUMAQUAMARINE_VALUE = "mediumaquamarine";
    String CSS_MEDIUMBLUE_VALUE = "mediumblue";
    String CSS_MEDIUMORCHID_VALUE = "mediumorchid";
    String CSS_MEDIUMPURPLE_VALUE = "mediumpurple";
    String CSS_MEDIUMSEAGREEN_VALUE = "mediumseagreen";
    String CSS_MEDIUMSLATEBLUE_VALUE = "mediumslateblue";
    String CSS_MEDIUMSPRINGGREEN_VALUE = "mediumspringgreen";
    String CSS_MEDIUMTURQUOISE_VALUE = "mediumturquoise";
    String CSS_MEDIUMVIOLETRED_VALUE = "mediumvioletred";
    String CSS_MEDIUM_VALUE = "medium";
    String CSS_MENU_VALUE = "menu";
    String CSS_MENUTEXT_VALUE = "menutext";
    String CSS_MESSAGE_BOX_VALUE = "message-box";
    String CSS_MIDDLE_VALUE = "middle";
    String CSS_MIDNIGHTBLUE_VALUE = "midnightblue";
    String CSS_MINTCREAM_VALUE = "mintcream";
    String CSS_MISTYROSE_VALUE = "mistyrose";
    String CSS_MITER_VALUE = "miter";
    String CSS_MOCCASIN_VALUE = "moccasin";
    String CSS_MONOSPACE_VALUE = "monospace";
    String CSS_MOVE_VALUE = "move";
    String CSS_NARROWER_VALUE = "narrower";
    String CSS_NAVAJOWHITE_VALUE = "navajowhite";
    String CSS_NAVY_VALUE = "navy";
    String CSS_NEW_VALUE = "new";
    String CSS_NE_RESIZE_VALUE = "ne-resize";
    String CSS_NONE_VALUE = "none";
    String CSS_NONZERO_VALUE = "nonzero";
    String CSS_NORMAL_VALUE = "normal";
    String CSS_NO_CHANGE_VALUE = "no-change";
    String CSS_NW_RESIZE_VALUE = "nw-resize";
    String CSS_N_RESIZE_VALUE = "n-resize";
    String CSS_OBLIQUE_VALUE = "oblique";
    String CSS_OLDLACE_VALUE = "oldlace";
    String CSS_OLIVEDRAB_VALUE = "olivedrab";
    String CSS_OLIVE_VALUE = "olive";
    String CSS_OPTIMIZELEGIBILITY_VALUE = "optimizelegibility";
    String CSS_OPTIMIZEQUALITY_VALUE = "optimizequality";
    String CSS_OPTIMIZESPEED_VALUE = "optimizespeed";
    String CSS_ORANGERED_VALUE = "orangered";
    String CSS_ORANGE_VALUE = "orange";
    String CSS_ORCHID_VALUE = "orchid";
    String CSS_OVERLINE_VALUE = "overline";
    String CSS_PAINTED_VALUE = "painted";
    String CSS_PALEGOLDENROD_VALUE = "palegoldenrod";
    String CSS_PALEGREEN_VALUE = "palegreen";
    String CSS_PALETURQUOISE_VALUE = "paleturquoise";
    String CSS_PALEVIOLETRED_VALUE = "palevioletred";
    String CSS_PAPAYAWHIP_VALUE = "papayawhip";
    String CSS_PEACHPUFF_VALUE = "peachpuff";
    String CSS_PERU_VALUE = "peru";
    String CSS_PINK_VALUE = "pink";
    String CSS_PLUM_VALUE = "plum";
    String CSS_POINTER_VALUE = "pointer";
    String CSS_POWDERBLUE_VALUE = "powderblue";
    String CSS_PURPLE_VALUE = "purple";
    String CSS_RED_VALUE = "red";
    String CSS_RESET_SIZE_VALUE = "reset-size";
    String CSS_RESET_VALUE = "reset";
    String CSS_RL_TB_VALUE = "rl-tb";
    String CSS_RL_VALUE = "rl";
    String CSS_ROSYBROWN_VALUE = "rosybrown";
    String CSS_ROUND_VALUE = "round";
    String CSS_ROYALBLUE_VALUE = "royalblue";
    String CSS_RTL_VALUE = "rtl";
    String CSS_RUN_IN_VALUE = "run-in";
    String CSS_SADDLEBROWN_VALUE = "saddlebrown";
    String CSS_SALMON_VALUE = "salmon";
    String CSS_SANDYBROWN_VALUE = "sandybrown";
    String CSS_SANS_SERIF_VALUE = "sans-serif";
    String CSS_SCROLLBAR_VALUE = "scrollbar";
    String CSS_SCROLL_VALUE = "scroll";
    String CSS_SEAGREEN_VALUE = "seagreen";
    String CSS_SEASHELL_VALUE = "seashell";
    String CSS_SEMI_CONDENSED_VALUE = "semi-condensed";
    String CSS_SEMI_EXPANDED_VALUE = "semi-expanded";
    String CSS_SERIF_VALUE = "serif";
    String CSS_SE_RESIZE_VALUE = "se-resize";
    String CSS_SIENNA_VALUE = "sienna";
    String CSS_SILVER_VALUE = "silver";
    String CSS_SKYBLUE_VALUE = "skyblue";
    String CSS_SLATEBLUE_VALUE = "slateblue";
    String CSS_SLATEGRAY_VALUE = "slategray";
    String CSS_SLATEGREY_VALUE = "slategrey";
    String CSS_SMALLER_VALUE = "smaller";
    String CSS_SMALL_CAPS_VALUE = "small-caps";
    String CSS_SMALL_CAPTION_VALUE = "small-caption";
    String CSS_SMALL_VALUE = "small";
    String CSS_SNOW_VALUE = "snow";
    String CSS_SPRINGGREEN_VALUE = "springgreen";
    String CSS_SQUARE_VALUE = "square";
    String CSS_SRGB_VALUE = "srgb";
    String CSS_START_VALUE = "start";
    String CSS_STATUS_BAR_VALUE = "status-bar";
    String CSS_STEELBLUE_VALUE = "steelblue";
    String CSS_STROKE_VALUE = "stroke";
    String CSS_SUB_VALUE = "sub";
    String CSS_SUPER_VALUE = "super";
    String CSS_SW_RESIZE_VALUE = "sw-resize";
    String CSS_S_RESIZE_VALUE = "s-resize";
    String CSS_TABLE_CAPTION_VALUE = "table-caption";
    String CSS_TABLE_CELL_VALUE = "table-cell";
    String CSS_TABLE_COLUMN_GROUP_VALUE = "table-column-group";
    String CSS_TABLE_COLUMN_VALUE = "table-column";
    String CSS_TABLE_FOOTER_GROUP_VALUE = "table-footer-group";
    String CSS_TABLE_HEADER_GROUP_VALUE = "table-header-group";
    String CSS_TABLE_ROW_GROUP_VALUE = "table-row-group";
    String CSS_TABLE_ROW_VALUE = "table-row";
    String CSS_TABLE_VALUE = "table";
    String CSS_TAN_VALUE = "tan";
    String CSS_TB_RL_VALUE = "tb-rl";
    String CSS_TB_VALUE = "tb";
    String CSS_TEAL_VALUE = "teal";
    String CSS_TEXT_AFTER_EDGE_VALUE = "text-after-edge";
    String CSS_TEXT_BEFORE_EDGE_VALUE = "text-before-edge";
    String CSS_TEXT_BOTTOM_VALUE = "text-bottom";
    String CSS_TEXT_TOP_VALUE = "text-top";
    String CSS_TEXT_VALUE = "text";
    String CSS_THISTLE_VALUE = "thistle";
    String CSS_THREEDDARKSHADOW_VALUE = "threeddarkshadow";
    String CSS_THREEDFACE_VALUE = "threedface";
    String CSS_THREEDHIGHLIGHT_VALUE = "threedhighlight";
    String CSS_THREEDLIGHTSHADOW_VALUE = "threedlightshadow";
    String CSS_THREEDSHADOW_VALUE = "threedshadow";
    String CSS_TOMATO_VALUE = "tomato";
    String CSS_TOP_VALUE = "top";
    String CSS_TURQUOISE_VALUE = "turquoise";
    String CSS_ULTRA_CONDENSED_VALUE = "ultra-condensed";
    String CSS_ULTRA_EXPANDED_VALUE = "ultra-expanded";
    String CSS_UNDERLINE_VALUE = "underline";
    String CSS_USE_SCRIPT_VALUE = "use-script";
    String CSS_VIOLET_VALUE = "violet";
    String CSS_VISIBLEFILLSTROKE_VALUE = "visiblefillstroke";
    String CSS_VISIBLEFILL_VALUE = "visiblefill";
    String CSS_VISIBLEPAINTED_VALUE = "visiblepainted";
    String CSS_VISIBLESTROKE_VALUE = "visiblestroke";
    String CSS_VISIBLE_VALUE = "visible";
    String CSS_WAIT_VALUE = "wait";
    String CSS_WHEAT_VALUE = "wheat";
    String CSS_WHITESMOKE_VALUE = "whitesmoke";
    String CSS_WHITE_VALUE = "white";
    String CSS_WIDER_VALUE = "wider";
    String CSS_WINDOWFRAME_VALUE = "windowframe";
    String CSS_WINDOWTEXT_VALUE = "windowtext";
    String CSS_WINDOW_VALUE = "window";
    String CSS_W_RESIZE_VALUE = "w-resize";
    String CSS_XX_LARGE_VALUE = "xx-large";
    String CSS_XX_SMALL_VALUE = "xx-small";
    String CSS_X_LARGE_VALUE = "x-large";
    String CSS_X_SMALL_VALUE = "x-small";
    String CSS_YELLOWGREEN_VALUE = "yellowgreen";
    String CSS_YELLOW_VALUE = "yellow";
    /////////////////////////////////////////////////////////////////////////
    // SVG tags
    /////////////////////////////////////////////////////////////////////////

    String SVG_A_TAG = "a";
    String SVG_ALT_GLYPH_TAG = "altGlyph";
    String SVG_ALT_GLYPH_DEF_TAG = "altGlyphDef";
    String SVG_ALT_GLYPH_ITEM_TAG = "altGlyphItem";
    String SVG_ANIMATE_TAG = "animate";
    String SVG_ANIMATE_COLOR_TAG = "animateColor";
    String SVG_ANIMATE_MOTION_TAG = "animateMotion";
    String SVG_ANIMATE_TRANSFORM_TAG = "animateTransform";
    String SVG_CIRCLE_TAG = "circle";
    String SVG_CLIP_PATH_TAG = "clipPath";
    String SVG_COLOR_PROFILE_TAG = "color-profile";
    String SVG_CURSOR_TAG = "cursor";
    String SVG_DEFS_TAG = "defs";
    String SVG_DESC_TAG = "desc";
    String SVG_ELLIPSE_TAG = "ellipse";
    String SVG_FE_BLEND_TAG = "feBlend";
    String SVG_FE_COLOR_MATRIX_TAG = "feColorMatrix";
    String SVG_FE_COMPONENT_TRANSFER_TAG = "feComponentTransfer";
    String SVG_FE_COMPOSITE_TAG = "feComposite";
    String SVG_FE_CONVOLVE_MATRIX_TAG = "feConvolveMatrix";
    String SVG_FE_DIFFUSE_LIGHTING_TAG = "feDiffuseLighting";
    String SVG_FE_DISPLACEMENT_MAP_TAG = "feDisplacementMap";
    String SVG_FE_DISTANT_LIGHT_TAG = "feDistantLight";
    String SVG_FE_FLOOD_TAG = "feFlood";
    String SVG_FE_FUNC_A_TAG = "feFuncA";
    String SVG_FE_FUNC_B_TAG = "feFuncB";
    String SVG_FE_FUNC_G_TAG = "feFuncG";
    String SVG_FE_FUNC_R_TAG = "feFuncR";
    String SVG_FE_GAUSSIAN_BLUR_TAG = "feGaussianBlur";
    String SVG_FE_IMAGE_TAG = "feImage";
    String SVG_FE_MERGE_NODE_TAG = "feMergeNode";
    String SVG_FE_MERGE_TAG = "feMerge";
    String SVG_FE_MORPHOLOGY_TAG = "feMorphology";
    String SVG_FE_OFFSET_TAG = "feOffset";
    String SVG_FE_POINT_LIGHT_TAG = "fePointLight";
    String SVG_FE_SPECULAR_LIGHTING_TAG = "feSpecularLighting";
    String SVG_FE_SPOT_LIGHT_TAG = "feSpotLight";
    String SVG_FE_TILE_TAG = "feTile";
    String SVG_FE_TURBULENCE_TAG = "feTurbulence";
    String SVG_FILTER_TAG = "filter";
    String SVG_FONT_TAG = "font";
    String SVG_FONT_FACE_TAG = "font-face";
    String SVG_FONT_FACE_FORMAT_TAG = "font-face-format";
    String SVG_FONT_FACE_NAME_TAG = "font-face-name";
    String SVG_FONT_FACE_SRC_TAG = "font-face-src";
    String SVG_FONT_FACE_URI_TAG = "font-face-uri";
    String SVG_FOREIGN_OBJECT_TAG = "foreignObject";
    String SVG_G_TAG = "g";
    String SVG_GLYPH_TAG = "glyph";
    String SVG_GLYPH_REF_TAG = "glyphRef";
    String SVG_H_KERN_TAG = "hkern";
    String SVG_IMAGE_TAG = "image";
    String SVG_LINE_TAG = "line";
    String SVG_LINEAR_GRADIENT_TAG = "linearGradient";
    String SVG_MARKER_TAG = "marker";
    String SVG_MASK_TAG = "mask";
    String SVG_METADATA_TAG = "metadata";
    String SVG_MISSING_GLYPH_TAG = "missing-glyph";
    String SVG_M_PATH_TAG = "mpath";
    String SVG_PATH_TAG = "path";
    String SVG_PATTERN_TAG = "pattern";
    String SVG_POLYGON_TAG = "polygon";
    String SVG_POLYLINE_TAG = "polyline";
    String SVG_RADIAL_GRADIENT_TAG = "radialGradient";
    String SVG_RECT_TAG = "rect";
    String SVG_SET_TAG = "set";
    String SVG_SCRIPT_TAG = "script";
    String SVG_STOP_TAG = "stop";
    String SVG_STYLE_TAG = "style";
    String SVG_SVG_TAG = "svg";
    String SVG_SWITCH_TAG = "switch";
    String SVG_SYMBOL_TAG = "symbol";
    String SVG_TEXT_PATH_TAG = "textPath";
    String SVG_TEXT_TAG = "text";
    String SVG_TITLE_TAG = "title";
    String SVG_T_REF_TAG = "tref";
    String SVG_T_SPAN_TAG = "tspan";
    String SVG_USE_TAG = "use";
    String SVG_VIEW_TAG = "view";
    String SVG_V_KERN_TAG = "vkern";

    /////////////////////////////////////////////////////////////////////////
    // SVG attributes
    /////////////////////////////////////////////////////////////////////////

    String SVG_ACCENT_HEIGHT_ATTRIBUTE = "accent-height";
    String SVG_ACCUMULATE_ATTRIBUTE = "accumulate";
    String SVG_ADDITIVE_ATTRIBUTE = "additive";
    String SVG_AMPLITUDE_ATTRIBUTE = "amplitude";
    String SVG_ARABIC_FORM_ATTRIBUTE = "arabic-form";
    String SVG_ASCENT_ATTRIBUTE = "ascent";
    String SVG_AZIMUTH_ATTRIBUTE = "azimuth";
    String SVG_ALPHABETIC_ATTRIBUTE = "alphabetic";
    String SVG_ATTRIBUTE_NAME_ATTRIBUTE = "attributeName";
    String SVG_ATTRIBUTE_TYPE_ATTRIBUTE = "attributeType";
    String SVG_BASE_FREQUENCY_ATTRIBUTE = "baseFrequency";
    String SVG_BASE_PROFILE_ATTRIBUTE = "baseProfile";
    String SVG_BEGIN_ATTRIBUTE = "begin";
    String SVG_BBOX_ATTRIBUTE = "bbox";
    String SVG_BIAS_ATTRIBUTE = "bias";
    String SVG_BY_ATTRIBUTE = "by";
    String SVG_CALC_MODE_ATTRIBUTE = "calcMode";
    String SVG_CAP_HEIGHT_ATTRIBUTE = "cap-height";
    String SVG_CLASS_ATTRIBUTE = "class";
    String SVG_CLIP_PATH_ATTRIBUTE = CSS_CLIP_PATH_PROPERTY;
    String SVG_CLIP_PATH_UNITS_ATTRIBUTE = "clipPathUnits";
    String SVG_COLOR_INTERPOLATION_ATTRIBUTE = CSS_COLOR_INTERPOLATION_PROPERTY;
    String SVG_COLOR_RENDERING_ATTRIBUTE = CSS_COLOR_RENDERING_PROPERTY;
    String SVG_CONTENT_SCRIPT_TYPE_ATTRIBUTE = "contentScriptType";
    String SVG_CONTENT_STYLE_TYPE_ATTRIBUTE = "contentStyleType";
    String SVG_CX_ATTRIBUTE = "cx";
    String SVG_CY_ATTRIBUTE = "cy";
    String SVG_DESCENT_ATTRIBUTE = "descent";
    String SVG_DIFFUSE_CONSTANT_ATTRIBUTE = "diffuseConstant";
    String SVG_DIVISOR_ATTRIBUTE = "divisor";
    String SVG_DUR_ATTRIBUTE = "dur";
    String SVG_DX_ATTRIBUTE = "dx";
    String SVG_DY_ATTRIBUTE = "dy";
    String SVG_D_ATTRIBUTE = "d";
    String SVG_EDGE_MODE_ATTRIBUTE = "edgeMode";
    String SVG_ELEVATION_ATTRIBUTE = "elevation";
    String SVG_ENABLE_BACKGROUND_ATTRIBUTE = CSS_ENABLE_BACKGROUND_PROPERTY;
    String SVG_END_ATTRIBUTE = "end";
    String SVG_EXPONENT_ATTRIBUTE = "exponent";
    String SVG_EXTERNAL_RESOURCES_REQUIRED_ATTRIBUTE = "externalResourcesRequired";
    String SVG_FILL_ATTRIBUTE = CSS_FILL_PROPERTY;
    String SVG_FILL_OPACITY_ATTRIBUTE = CSS_FILL_OPACITY_PROPERTY;
    String SVG_FILL_RULE_ATTRIBUTE = CSS_FILL_RULE_PROPERTY;
    String SVG_FILTER_ATTRIBUTE = CSS_FILTER_PROPERTY;
    String SVG_FILTER_RES_ATTRIBUTE = "filterRes";
    String SVG_FILTER_UNITS_ATTRIBUTE = "filterUnits";
    String SVG_FLOOD_COLOR_ATTRIBUTE = CSS_FLOOD_COLOR_PROPERTY;
    String SVG_FLOOD_OPACITY_ATTRIBUTE = CSS_FLOOD_OPACITY_PROPERTY;
    String SVG_FORMAT_ATTRIBUTE = "format";
    String SVG_FONT_FAMILY_ATTRIBUTE = CSS_FONT_FAMILY_PROPERTY;
    String SVG_FONT_SIZE_ATTRIBUTE = CSS_FONT_SIZE_PROPERTY;
    String SVG_FONT_STRETCH_ATTRIBUTE = CSS_FONT_STRETCH_PROPERTY;
    String SVG_FONT_STYLE_ATTRIBUTE = CSS_FONT_STYLE_PROPERTY;
    String SVG_FONT_VARIANT_ATTRIBUTE = CSS_FONT_VARIANT_PROPERTY;
    String SVG_FONT_WEIGHT_ATTRIBUTE = CSS_FONT_WEIGHT_PROPERTY;
    String SVG_FROM_ATTRIBUTE = "from";
    String SVG_FX_ATTRIBUTE = "fx";
    String SVG_FY_ATTRIBUTE = "fy";
    String SVG_G1_ATTRIBUTE = "g1";
    String SVG_G2_ATTRIBUTE = "g2";
    String SVG_GLYPH_NAME_ATTRIBUTE = "glyph-name";
    String SVG_GLYPH_REF_ATTRIBUTE = "glyphRef";
    String SVG_GRADIENT_TRANSFORM_ATTRIBUTE = "gradientTransform";
    String SVG_GRADIENT_UNITS_ATTRIBUTE = "gradientUnits";
    String SVG_HANGING_ATTRIBUTE = "hanging";
    String SVG_HEIGHT_ATTRIBUTE = "height";
    String SVG_HORIZ_ADV_X_ATTRIBUTE = "horiz-adv-x";
    String SVG_HORIZ_ORIGIN_X_ATTRIBUTE = "horiz-origin-x";
    String SVG_HORIZ_ORIGIN_Y_ATTRIBUTE = "horiz-origin-y";
    String SVG_ID_ATTRIBUTE = XML_ID_ATTRIBUTE;
    String SVG_IDEOGRAPHIC_ATTRIBUTE = "ideographic";
    String SVG_IMAGE_RENDERING_ATTRIBUTE = CSS_IMAGE_RENDERING_PROPERTY;
    String SVG_IN2_ATTRIBUTE = "in2";
    String SVG_INTERCEPT_ATTRIBUTE = "intercept";
    String SVG_IN_ATTRIBUTE = "in";
    String SVG_K_ATTRIBUTE = "k";
    String SVG_K1_ATTRIBUTE = "k1";
    String SVG_K2_ATTRIBUTE = "k2";
    String SVG_K3_ATTRIBUTE = "k3";
    String SVG_K4_ATTRIBUTE = "k4";
    String SVG_KERNEL_MATRIX_ATTRIBUTE = "kernelMatrix";
    String SVG_KERNEL_UNIT_LENGTH_ATTRIBUTE = "kernelUnitLength";
    String SVG_KERNING_ATTRIBUTE = CSS_KERNING_PROPERTY;
    String SVG_KEY_POINTS_ATTRIBUTE = "keyPoints";
    String SVG_KEY_SPLINES_ATTRIBUTE = "keySplines";
    String SVG_KEY_TIMES_ATTRIBUTE = "keyTimes";
    String SVG_LANG_ATTRIBUTE = "lang";
    String SVG_LENGTH_ADJUST_ATTRIBUTE = "lengthAdjust";
    String SVG_LIGHT_COLOR_ATTRIBUTE = "lightColor";
    String SVG_LIGHTING_COLOR_ATTRIBUTE = "lighting-color";
    String SVG_LIMITING_CONE_ANGLE_ATTRIBUTE = "limitingConeAngle";
    String SVG_LOCAL_ATTRIBUTE = "local";
    String SVG_MARKER_HEIGHT_ATTRIBUTE = "markerHeight";
    String SVG_MARKER_UNITS_ATTRIBUTE = "markerUnits";
    String SVG_MARKER_WIDTH_ATTRIBUTE = "markerWidth";
    String SVG_MASK_ATTRIBUTE = CSS_MASK_PROPERTY;
    String SVG_MASK_CONTENT_UNITS_ATTRIBUTE = "maskContentUnits";
    String SVG_MASK_UNITS_ATTRIBUTE = "maskUnits";
    String SVG_MATHEMATICAL_ATTRIBUTE = "mathematical";
    String SVG_MAX_ATTRIBUTE = "max";
    String SVG_MEDIA_ATTRIBUTE = "media";
    String SVG_METHOD_ATTRIBUTE = "method";
    String SVG_MIN_ATTRIBUTE = "min";
    String SVG_MODE_ATTRIBUTE = "mode";
    String SVG_NAME_ATTRIBUTE = "name";
    String SVG_NUM_OCTAVES_ATTRIBUTE = "numOctaves";
    String SVG_OFFSET_ATTRIBUTE = "offset";
    String SVG_OPACITY_ATTRIBUTE = CSS_OPACITY_PROPERTY;
    String SVG_OPERATOR_ATTRIBUTE = "operator";
    String SVG_ORDER_ATTRIBUTE = "order";
    String SVG_ORDER_X_ATTRIBUTE = "orderX";
    String SVG_ORDER_Y_ATTRIBUTE = "orderY";
    String SVG_ORIENT_ATTRIBUTE = "orient";
    String SVG_ORIENTATION_ATTRIBUTE = "orientation";
    String SVG_ORIGIN_ATTRIBUTE = "origin";
    String SVG_OVERLINE_POSITION_ATTRIBUTE = "overline-position";
    String SVG_OVERLINE_THICKNESS_ATTRIBUTE = "overline-thickness";
    String SVG_PANOSE_1_ATTRIBUTE = "panose-1";
    String SVG_PATH_ATTRIBUTE = "path";
    String SVG_PATH_LENGTH_ATTRIBUTE = "pathLength";
    String SVG_PATTERN_CONTENT_UNITS_ATTRIBUTE = "patternContentUnits";
    String SVG_PATTERN_TRANSFORM_ATTRIBUTE = "patternTransform";
    String SVG_PATTERN_UNITS_ATTRIBUTE = "patternUnits";
    String SVG_POINTS_ATTRIBUTE = "points";
    String SVG_POINTS_AT_X_ATTRIBUTE = "pointsAtX";
    String SVG_POINTS_AT_Y_ATTRIBUTE = "pointsAtY";
    String SVG_POINTS_AT_Z_ATTRIBUTE = "pointsAtZ";
    String SVG_PRESERVE_ALPHA_ATTRIBUTE = "preserveAlpha";
    String SVG_PRESERVE_ASPECT_RATIO_ATTRIBUTE = "preserveAspectRatio";
    String SVG_PRIMITIVE_UNITS_ATTRIBUTE = "primitiveUnits";
    String SVG_RADIUS_ATTRIBUTE = "radius";
    String SVG_REF_X_ATTRIBUTE = "refX";
    String SVG_REF_Y_ATTRIBUTE = "refY";
    String SVG_RENDERING_INTENT_ATTRIBUTE = "rendering-intent";
    String SVG_REPEAT_COUNT_ATTRIBUTE = "repeatCount";
    String SVG_REPEAT_DUR_ATTRIBUTE = "repeatDur";
    String SVG_REQUIRED_FEATURES_ATTRIBUTE = "requiredFeatures";
    String SVG_REQUIRED_EXTENSIONS_ATTRIBUTE = "requiredExtensions";
    String SVG_RESULT_ATTRIBUTE = "result";
    String SVG_RESULT_SCALE_ATTRIBUTE = "resultScale";
    String SVG_RESTART_ATTRIBUTE = "restart";
    String SVG_RX_ATTRIBUTE = "rx";
    String SVG_RY_ATTRIBUTE = "ry";
    String SVG_R_ATTRIBUTE = "r";
    String SVG_ROTATE_ATTRIBUTE = "rotate";
    String SVG_SCALE_ATTRIBUTE = "scale";
    String SVG_SEED_ATTRIBUTE = "seed";
    String SVG_SHAPE_RENDERING_ATTRIBUTE = CSS_SHAPE_RENDERING_PROPERTY;
    String SVG_SLOPE_ATTRIBUTE = "slope";
    String SVG_SNAPSHOT_TIME_ATTRIBUTE = "snapshotTime";
    String SVG_SPACE_ATTRIBUTE = "space";
    String SVG_SPACING_ATTRIBUTE = "spacing";
    String SVG_SPECULAR_CONSTANT_ATTRIBUTE = "specularConstant";
    String SVG_SPECULAR_EXPONENT_ATTRIBUTE = "specularExponent";
    String SVG_SPREAD_METHOD_ATTRIBUTE = "spreadMethod";
    String SVG_START_OFFSET_ATTRIBUTE = "startOffset";
    String SVG_STD_DEVIATION_ATTRIBUTE = "stdDeviation";
    String SVG_STEMH_ATTRIBUTE = "stemh";
    String SVG_STEMV_ATTRIBUTE = "stemv";
    String SVG_STITCH_TILES_ATTRIBUTE = "stitchTiles";
    String SVG_STOP_COLOR_ATTRIBUTE = "stop-color";
    String SVG_STOP_OPACITY_ATTRIBUTE = CSS_STOP_OPACITY_PROPERTY;
    String SVG_STRIKETHROUGH_POSITION_ATTRIBUTE = "strikethrough-position";
    String SVG_STRIKETHROUGH_THICKNESS_ATTRIBUTE = "strikethrough-thickness";
    String SVG_STRING_ATTRIBUTE = "string";
    String SVG_STROKE_ATTRIBUTE = CSS_STROKE_PROPERTY;
    String SVG_STROKE_DASHARRAY_ATTRIBUTE = CSS_STROKE_DASHARRAY_PROPERTY;
    String SVG_STROKE_DASHOFFSET_ATTRIBUTE = CSS_STROKE_DASHOFFSET_PROPERTY;
    String SVG_STROKE_LINECAP_ATTRIBUTE = CSS_STROKE_LINECAP_PROPERTY;
    String SVG_STROKE_LINEJOIN_ATTRIBUTE = CSS_STROKE_LINEJOIN_PROPERTY;
    String SVG_STROKE_MITERLIMIT_ATTRIBUTE = CSS_STROKE_MITERLIMIT_PROPERTY;
    String SVG_STROKE_OPACITY_ATTRIBUTE = CSS_STROKE_OPACITY_PROPERTY;
    String SVG_STROKE_WIDTH_ATTRIBUTE = CSS_STROKE_WIDTH_PROPERTY;
    String SVG_STYLE_ATTRIBUTE = "style";
    String SVG_SURFACE_SCALE_ATTRIBUTE = "surfaceScale";
    String SVG_SYSTEM_LANGUAGE_ATTRIBUTE = "systemLanguage";
    String SVG_TABLE_ATTRIBUTE = "table";
    String SVG_TABLE_VALUES_ATTRIBUTE = "tableValues";
    String SVG_TARGET_ATTRIBUTE = "target";
    String SVG_TARGET_X_ATTRIBUTE = "targetX";
    String SVG_TARGET_Y_ATTRIBUTE = "targetY";
    String SVG_TEXT_ANCHOR_ATTRIBUTE = CSS_TEXT_ANCHOR_PROPERTY;
    String SVG_TEXT_LENGTH_ATTRIBUTE = "textLength";
    String SVG_TEXT_RENDERING_ATTRIBUTE = CSS_TEXT_RENDERING_PROPERTY;
    String SVG_TITLE_ATTRIBUTE = "title";
    String SVG_TO_ATTRIBUTE = "to";
    String SVG_TRANSFORM_ATTRIBUTE = "transform";
    String SVG_TYPE_ATTRIBUTE = "type";
    String SVG_U1_ATTRIBUTE = "u1";
    String SVG_U2_ATTRIBUTE = "u2";
    String SVG_UNDERLINE_POSITION_ATTRIBUTE = "underline-position";
    String SVG_UNDERLINE_THICKNESS_ATTRIBUTE = "underline-thickness";
    String SVG_UNICODE_ATTRIBUTE = "unicode";
    String SVG_UNICODE_RANGE_ATTRIBUTE = "unicode-range";
    String SVG_UNITS_PER_EM_ATTRIBUTE = "units-per-em";
    String SVG_V_ALPHABETIC_ATTRIBUTE = "v-alphabetic";
    String SVG_V_HANGING_ATTRIBUTE = "v-hanging";
    String SVG_V_IDEOGRAPHIC_ATTRIBUTE = "v-ideographic";
    String SVG_V_MATHEMATICAL_ATTRIBUTE = "v-mathematical";
    String SVG_VALUES_ATTRIBUTE = "values";
    String SVG_VERSION_ATTRIBUTE = "version";
    String SVG_VERT_ADV_Y_ATTRIBUTE = "vert-adv-y";
    String SVG_VERT_ORIGIN_X_ATTRIBUTE = "vert-origin-x";
    String SVG_VERT_ORIGIN_Y_ATTRIBUTE = "vert-origin-y";
    String SVG_VIEW_BOX_ATTRIBUTE = "viewBox";
    String SVG_VIEW_TARGET_ATTRIBUTE = "viewTarget";
    String SVG_WIDTH_ATTRIBUTE = "width";
    String SVG_WIDTHS_ATTRIBUTE = "widths";
    String SVG_X1_ATTRIBUTE = "x1";
    String SVG_X2_ATTRIBUTE = "x2";
    String SVG_X_ATTRIBUTE = "x";
    String SVG_X_CHANNEL_SELECTOR_ATTRIBUTE = "xChannelSelector";
    String SVG_X_HEIGHT_ATTRIBUTE = "xHeight";
    String SVG_Y1_ATTRIBUTE = "y1";
    String SVG_Y2_ATTRIBUTE = "y2";
    String SVG_Y_ATTRIBUTE = "y";
    String SVG_Y_CHANNEL_SELECTOR_ATTRIBUTE = "yChannelSelector";
    String SVG_Z_ATTRIBUTE = "z";
    String SVG_ZOOM_AND_PAN_ATTRIBUTE = "zoomAndPan";

    /////////////////////////////////////////////////////////////////////////
    // SVG attribute value
    /////////////////////////////////////////////////////////////////////////

    String SVG_100_VALUE = "100";
    String SVG_200_VALUE = "200";
    String SVG_300_VALUE = "300";
    String SVG_400_VALUE = "400";
    String SVG_500_VALUE = "500";
    String SVG_600_VALUE = "600";
    String SVG_700_VALUE = "700";
    String SVG_800_VALUE = "800";
    String SVG_900_VALUE = "900";
    String SVG_ABSOLUTE_COLORIMETRIC_VALUE = "absolute-colorimetric";
    String SVG_ALIGN_VALUE = "align";
    String SVG_ALL_VALUE = "all";
    String SVG_ARITHMETIC_VALUE = "arithmetic";
    String SVG_ATOP_VALUE = "atop";
    String SVG_AUTO_VALUE = "auto";
    String SVG_A_VALUE = "A";
    String SVG_BACKGROUND_ALPHA_VALUE = "BackgroundAlpha";
    String SVG_BACKGROUND_IMAGE_VALUE = "BackgroundImage";
    String SVG_BEVEL_VALUE = "bevel";
    String SVG_BOLDER_VALUE = "bolder";
    String SVG_BOLD_VALUE = "bold";
    String SVG_BUTT_VALUE = "butt";
    String SVG_B_VALUE = "B";
    String SVG_COMPOSITE_VALUE = "composite";
    String SVG_CRISP_EDGES_VALUE = "crispEdges";
    String SVG_CROSSHAIR_VALUE = "crosshair";
    String SVG_DARKEN_VALUE = "darken";
    String SVG_DEFAULT_VALUE = "default";
    String SVG_DIGIT_ONE_VALUE = "1";
    String SVG_DILATE_VALUE = "dilate";
    String SVG_DISABLE_VALUE = "disable";
    String SVG_DISCRETE_VALUE = "discrete";
    String SVG_DUPLICATE_VALUE = "duplicate";
    String SVG_END_VALUE = "end";
    String SVG_ERODE_VALUE = "erode";
    String SVG_EVEN_ODD_VALUE = "evenodd";
    String SVG_EXACT_VALUE = "exact";
    String SVG_E_RESIZE_VALUE = "e-resize";
    String SVG_FALSE_VALUE = "false";
    String SVG_FILL_PAINT_VALUE = "FillPaint";
    String SVG_FLOOD_VALUE = "flood";
    String SVG_FRACTAL_NOISE_VALUE = "fractalNoise";
    String SVG_GAMMA_VALUE = "gamma";
    String SVG_GEOMETRIC_PRECISION_VALUE = "geometricPrecision";
    String SVG_G_VALUE = "G";
    String SVG_HELP_VALUE = "help";
    String SVG_HUE_ROTATE_VALUE = "hueRotate";
    String SVG_HUNDRED_PERCENT_VALUE = "100%";
    String SVG_H_VALUE = "h";
    String SVG_IDENTITY_VALUE = "identity";
    String SVG_INITIAL_VALUE = "initial";
    String SVG_IN_VALUE = "in";
    String SVG_ISOLATED_VALUE = "isolated";
    String SVG_ITALIC_VALUE = "italic";
    String SVG_LIGHTEN_VALUE = "lighten";
    String SVG_LIGHTER_VALUE = "lighter";
    String SVG_LINEAR_RGB_VALUE = "linearRGB";
    String SVG_LINEAR_VALUE = "linear";
    String SVG_LUMINANCE_TO_ALPHA_VALUE = "luminanceToAlpha";
    String SVG_MAGNIFY_VALUE = "magnify";
    String SVG_MATRIX_VALUE = "matrix";
    String SVG_MEDIAL_VALUE = "medial";
    String SVG_MEET_VALUE = "meet";
    String SVG_MIDDLE_VALUE = "middle";
    String SVG_MITER_VALUE = "miter";
    String SVG_MOVE_VALUE = "move";
    String SVG_MULTIPLY_VALUE = "multiply";
    String SVG_NEW_VALUE = "new";
    String SVG_NE_RESIZE_VALUE = "ne-resize";
    String SVG_NINETY_VALUE = "90";
    String SVG_NONE_VALUE = "none";
    String SVG_NON_ZERO_VALUE = "nonzero";
    String SVG_NORMAL_VALUE = "normal";
    String SVG_NO_STITCH_VALUE = "noStitch";
    String SVG_NW_RESIZE_VALUE = "nw-resize";
    String SVG_N_RESIZE_VALUE = "n-resize";
    String SVG_OBJECT_BOUNDING_BOX_VALUE = "objectBoundingBox";
    String SVG_OBLIQUE_VALUE = "oblique";
    String SVG_ONE_VALUE = "1";
    String SVG_OPAQUE_VALUE = "1";
    String SVG_OPTIMIZE_LEGIBILITY_VALUE = "optimizeLegibility";
    String SVG_OPTIMIZE_QUALITY_VALUE = "optimizeQuality";
    String SVG_OPTIMIZE_SPEED_VALUE = "optimizeSpeed";
    String SVG_OUT_VALUE = "out";
    String SVG_OVER_VALUE = "over";
    String SVG_PACED_VALUE = "paced";
    String SVG_PAD_VALUE = "pad";
    String SVG_PERCEPTUAL_VALUE = "perceptual";
    String SVG_POINTER_VALUE = "pointer";
    String SVG_PRESERVE_VALUE = "preserve";
    String SVG_REFLECT_VALUE = "reflect";
    String SVG_RELATIVE_COLORIMETRIC_VALUE = "relative-colorimetric";
    String SVG_REPEAT_VALUE = "repeat";
    String SVG_ROUND_VALUE = "round";
    String SVG_R_VALUE = "R";
    String SVG_SATURATE_VALUE = "saturate";
    String SVG_SATURATION_VALUE = "saturation";
    String SVG_SCREEN_VALUE = "screen";
    String SVG_SE_RESIZE_VALUE = "se-resize";
    String SVG_SLICE_VALUE = "slice";
    String SVG_SOURCE_ALPHA_VALUE = "SourceAlpha";
    String SVG_SOURCE_GRAPHIC_VALUE = "SourceGraphic";
    String SVG_SPACING_AND_GLYPHS_VALUE = "spacingAndGlyphs";
    String SVG_SPACING_VALUE = "spacing";
    String SVG_SQUARE_VALUE = "square";
    String SVG_SRGB_VALUE = "sRGB";
    String SVG_START_VALUE = "start";
    String SVG_STITCH_VALUE = "stitch";
    String SVG_STRETCH_VALUE = "stretch";
    String SVG_STROKE_PAINT_VALUE = "StrokePaint";
    String SVG_STROKE_WIDTH_VALUE = "strokeWidth";
    String SVG_SW_RESIZE_VALUE = "sw-resize";
    String SVG_S_RESIZE_VALUE = "s-resize";
    String SVG_TABLE_VALUE = "table";
    String SVG_TERMINAL_VALUE = "terminal";
    String SVG_TEXT_VALUE = "text";
    String SVG_TRANSLATE_VALUE = "translate";
    String SVG_TRUE_VALUE = "true";
    String SVG_TURBULENCE_VALUE = "turbulence";
    String SVG_USER_SPACE_ON_USE_VALUE = "userSpaceOnUse";
    String SVG_V_VALUE = "v";
    String SVG_WAIT_VALUE = "wait";
    String SVG_WRAP_VALUE = "wrap";
    String SVG_W_RESIZE_VALUE = "w-resize";
    String SVG_XMAXYMAX_VALUE = "xMaxYMax";
    String SVG_XMAXYMID_VALUE = "xMaxYMid";
    String SVG_XMAXYMIN_VALUE = "xMaxYMin";
    String SVG_XMIDYMAX_VALUE = "xMidYMax";
    String SVG_XMIDYMID_VALUE = "xMidYMid";
    String SVG_XMIDYMIN_VALUE = "xMidYMin";
    String SVG_XMINYMAX_VALUE = "xMinYMax";
    String SVG_XMINYMID_VALUE = "xMinYMid";
    String SVG_XMINYMIN_VALUE = "xMinYMin";
    String SVG_XOR_VALUE = "xor";
    String SVG_ZERO_PERCENT_VALUE = "0%";
    String SVG_ZERO_VALUE = "0";


    ///////////////////////////////////////////////////////////////////
    // default values for attributes
    ///////////////////////////////////////////////////////////////////

    String SVG_CIRCLE_CX_DEFAULT_VALUE = "0";
    String SVG_CIRCLE_CY_DEFAULT_VALUE = "0";
    String SVG_CLIP_PATH_CLIP_PATH_UNITS_DEFAULT_VALUE = SVG_USER_SPACE_ON_USE_VALUE;
    String SVG_COMPONENT_TRANSFER_FUNCTION_AMPLITUDE_DEFAULT_VALUE = "1";
    String SVG_COMPONENT_TRANSFER_FUNCTION_EXPONENT_DEFAULT_VALUE = "1";
    String SVG_COMPONENT_TRANSFER_FUNCTION_INTERCEPT_DEFAULT_VALUE = "0";
    String SVG_COMPONENT_TRANSFER_FUNCTION_OFFSET_DEFAULT_VALUE = "0";
    String SVG_COMPONENT_TRANSFER_FUNCTION_SLOPE_DEFAULT_VALUE = "1";
    String SVG_COMPONENT_TRANSFER_FUNCTION_TABLE_VALUES_DEFAULT_VALUE = "";
    String SVG_CURSOR_X_DEFAULT_VALUE = "0";
    String SVG_CURSOR_Y_DEFAULT_VALUE = "0";
    String SVG_ELLIPSE_CX_DEFAULT_VALUE = "0";
    String SVG_ELLIPSE_CY_DEFAULT_VALUE = "0";
    String SVG_FE_COMPOSITE_K1_DEFAULT_VALUE = "0";
    String SVG_FE_COMPOSITE_K2_DEFAULT_VALUE = "0";
    String SVG_FE_COMPOSITE_K3_DEFAULT_VALUE = "0";
    String SVG_FE_COMPOSITE_K4_DEFAULT_VALUE = "0";
    String SVG_FE_COMPOSITE_OPERATOR_DEFAULT_VALUE = SVG_OVER_VALUE;
    String SVG_FE_CONVOLVE_MATRIX_EDGE_MODE_DEFAULT_VALUE = SVG_DUPLICATE_VALUE;
    String SVG_FE_DIFFUSE_LIGHTING_DIFFUSE_CONSTANT_DEFAULT_VALUE = "1";
    String SVG_FE_DIFFUSE_LIGHTING_SURFACE_SCALE_DEFAULT_VALUE = "1";
    String SVG_FE_DISPLACEMENT_MAP_SCALE_DEFAULT_VALUE = "0";
    String SVG_FE_DISTANT_LIGHT_AZIMUTH_DEFAULT_VALUE = "0";
    String SVG_FE_DISTANT_LIGHT_ELEVATION_DEFAULT_VALUE = "0";
    String SVG_FE_POINT_LIGHT_X_DEFAULT_VALUE = "0";
    String SVG_FE_POINT_LIGHT_Y_DEFAULT_VALUE = "0";
    String SVG_FE_POINT_LIGHT_Z_DEFAULT_VALUE = "0";
    String SVG_FE_SPECULAR_LIGHTING_SPECULAR_CONSTANT_DEFAULT_VALUE = "1";
    String SVG_FE_SPECULAR_LIGHTING_SPECULAR_EXPONENT_DEFAULT_VALUE = "1";
    String SVG_FE_SPECULAR_LIGHTING_SURFACE_SCALE_DEFAULT_VALUE = "1";
    String SVG_FE_SPOT_LIGHT_LIMITING_CONE_ANGLE_DEFAULT_VALUE = "90";
    String SVG_FE_SPOT_LIGHT_POINTS_AT_X_DEFAULT_VALUE = "0";
    String SVG_FE_SPOT_LIGHT_POINTS_AT_Y_DEFAULT_VALUE = "0";
    String SVG_FE_SPOT_LIGHT_POINTS_AT_Z_DEFAULT_VALUE = "0";
    String SVG_FE_SPOT_LIGHT_SPECULAR_EXPONENT_DEFAULT_VALUE = "1";
    String SVG_FE_SPOT_LIGHT_X_DEFAULT_VALUE = "0";
    String SVG_FE_SPOT_LIGHT_Y_DEFAULT_VALUE = "0";
    String SVG_FE_SPOT_LIGHT_Z_DEFAULT_VALUE = "0";
    String SVG_FE_TURBULENCE_NUM_OCTAVES_DEFAULT_VALUE = "1";
    String SVG_FE_TURBULENCE_SEED_DEFAULT_VALUE = "0";
    String SVG_FILTER_FILTER_UNITS_DEFAULT_VALUE = SVG_USER_SPACE_ON_USE_VALUE;
    String SVG_FILTER_HEIGHT_DEFAULT_VALUE = "120%";
    String SVG_FILTER_PRIMITIVE_X_DEFAULT_VALUE = "0%";
    String SVG_FILTER_PRIMITIVE_Y_DEFAULT_VALUE = "0%";
    String SVG_FILTER_PRIMITIVE_WIDTH_DEFAULT_VALUE = "100%";
    String SVG_FILTER_PRIMITIVE_HEIGHT_DEFAULT_VALUE = "100%";
    String SVG_FILTER_PRIMITIVE_UNITS_DEFAULT_VALUE = SVG_USER_SPACE_ON_USE_VALUE;
    String SVG_FILTER_WIDTH_DEFAULT_VALUE = "120%";
    String SVG_FILTER_X_DEFAULT_VALUE = "-10%";
    String SVG_FILTER_Y_DEFAULT_VALUE = "-10%";
    String SVG_FONT_FACE_FONT_STRETCH_DEFAULT_VALUE = SVG_NORMAL_VALUE;
    String SVG_FONT_FACE_FONT_STYLE_DEFAULT_VALUE = SVG_ALL_VALUE;
    String SVG_FONT_FACE_FONT_VARIANT_DEFAULT_VALUE = SVG_NORMAL_VALUE;
    String SVG_FONT_FACE_FONT_WEIGHT_DEFAULT_VALUE = SVG_ALL_VALUE;
    String SVG_FONT_FACE_PANOSE_1_DEFAULT_VALUE = "0 0 0 0 0 0 0 0 0 0";
    String SVG_FONT_FACE_SLOPE_DEFAULT_VALUE = "0";
    String SVG_FONT_FACE_UNITS_PER_EM_DEFAULT_VALUE = "1000";
    String SVG_FOREIGN_OBJECT_X_DEFAULT_VALUE = "0";
    String SVG_FOREIGN_OBJECT_Y_DEFAULT_VALUE = "0";
    String SVG_HORIZ_ORIGIN_X_DEFAULT_VALUE = "0";
    String SVG_HORIZ_ORIGIN_Y_DEFAULT_VALUE = "0";
    String SVG_KERN_K_DEFAULT_VALUE = "0";
    String SVG_IMAGE_X_DEFAULT_VALUE = "0";
    String SVG_IMAGE_Y_DEFAULT_VALUE = "0";
    String SVG_LINE_X1_DEFAULT_VALUE = "0";
    String SVG_LINE_X2_DEFAULT_VALUE = "0";
    String SVG_LINE_Y1_DEFAULT_VALUE = "0";
    String SVG_LINE_Y2_DEFAULT_VALUE = "0";
    String SVG_LINEAR_GRADIENT_X1_DEFAULT_VALUE = "0%";
    String SVG_LINEAR_GRADIENT_X2_DEFAULT_VALUE = "100%";
    String SVG_LINEAR_GRADIENT_Y1_DEFAULT_VALUE = "0%";
    String SVG_LINEAR_GRADIENT_Y2_DEFAULT_VALUE = "0%";
    String SVG_MARKER_MARKER_HEIGHT_DEFAULT_VALUE = "3";
    String SVG_MARKER_MARKER_UNITS_DEFAULT_VALUE = SVG_STROKE_WIDTH_VALUE;
    String SVG_MARKER_MARKER_WIDTH_DEFAULT_VALUE = "3";
    String SVG_MARKER_ORIENT_DEFAULT_VALUE = "0";
    String SVG_MARKER_REF_X_DEFAULT_VALUE = "0";
    String SVG_MARKER_REF_Y_DEFAULT_VALUE = "0";
    String SVG_MASK_HEIGHT_DEFAULT_VALUE = "120%";
    String SVG_MASK_MASK_UNITS_DEFAULT_VALUE = SVG_USER_SPACE_ON_USE_VALUE;
    String SVG_MASK_WIDTH_DEFAULT_VALUE = "120%";
    String SVG_MASK_X_DEFAULT_VALUE = "-10%";
    String SVG_MASK_Y_DEFAULT_VALUE = "-10%";
    String SVG_PATTERN_X_DEFAULT_VALUE = "0";
    String SVG_PATTERN_Y_DEFAULT_VALUE = "0";
    String SVG_PATTERN_WIDTH_DEFAULT_VALUE = "0";
    String SVG_PATTERN_HEIGHT_DEFAULT_VALUE = "0";
    String SVG_RADIAL_GRADIENT_CX_DEFAULT_VALUE = "50%";
    String SVG_RADIAL_GRADIENT_CY_DEFAULT_VALUE = "50%";
    String SVG_RADIAL_GRADIENT_R_DEFAULT_VALUE = "50%";
    String SVG_RECT_X_DEFAULT_VALUE = "0";
    String SVG_RECT_Y_DEFAULT_VALUE = "0";
    String SVG_SCRIPT_TYPE_ECMASCRIPT = "text/ecmascript";
    String SVG_SCRIPT_TYPE_APPLICATION_ECMASCRIPT = "application/ecmascript";
    String SVG_SCRIPT_TYPE_JAVASCRIPT = "text/javascript";
    String SVG_SCRIPT_TYPE_APPLICATION_JAVASCRIPT = "application/javascript";
    String SVG_SCRIPT_TYPE_DEFAULT_VALUE = SVG_SCRIPT_TYPE_ECMASCRIPT;
    String SVG_SCRIPT_TYPE_JAVA = "application/java-archive";
    String SVG_SVG_X_DEFAULT_VALUE = "0";
    String SVG_SVG_Y_DEFAULT_VALUE = "0";
    String SVG_SVG_HEIGHT_DEFAULT_VALUE = "100%";
    String SVG_SVG_WIDTH_DEFAULT_VALUE = "100%";
    String SVG_TEXT_PATH_START_OFFSET_DEFAULT_VALUE = "0";
    String SVG_USE_X_DEFAULT_VALUE = "0";
    String SVG_USE_Y_DEFAULT_VALUE = "0";
    String SVG_USE_WIDTH_DEFAULT_VALUE = "100%";
    String SVG_USE_HEIGHT_DEFAULT_VALUE = "100%";

    ///////////////////////////////////////////////////////////////////
    // various constants in SVG attributes
    ///////////////////////////////////////////////////////////////////

    String TRANSFORM_TRANSLATE = "translate";
    String TRANSFORM_ROTATE    = "rotate";
    String TRANSFORM_SCALE     = "scale";
    String TRANSFORM_SKEWX     = "skewX";
    String TRANSFORM_SKEWY     = "skewY";
    String TRANSFORM_MATRIX    = "matrix";

    String PATH_ARC                = "A";
    String PATH_CLOSE              = "Z";
    String PATH_CUBIC_TO           = "C";
    String PATH_MOVE               = "M";
    String PATH_LINE_TO            = "L";
    String PATH_VERTICAL_LINE_TO   = "V";
    String PATH_HORIZONTAL_LINE_TO = "H";
    String PATH_QUAD_TO            = "Q";
    String PATH_SMOOTH_QUAD_TO     = "T";

    ///////////////////////////////////////////////////////////////////
    // event constants
    ///////////////////////////////////////////////////////////////////
    
    String SVG_EVENT_CLICK     = "click";
    String SVG_EVENT_KEYDOWN   = "keydown";
    String SVG_EVENT_KEYPRESS  = "keypress";
    String SVG_EVENT_KEYUP     = "keyup";
    String SVG_EVENT_MOUSEDOWN = "mousedown";
    String SVG_EVENT_MOUSEMOVE = "mousemove";
    String SVG_EVENT_MOUSEOUT  = "mouseout";
    String SVG_EVENT_MOUSEOVER = "mouseover";
    String SVG_EVENT_MOUSEUP   = "mouseup";

    ///////////////////////////////////////////////////////////////////
    // SVG feature strings
    ///////////////////////////////////////////////////////////////////

    public static final String SVG_FEATURE_ANIMATION = "http://www.w3.org/TR/SVG11/feature#Animation";                                                                
    public static final String SVG_FEATURE_ANIMATION_EVENTS_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#AnimationEventsAttribute";                                  
    public static final String SVG_FEATURE_BASIC_CLIP = "http://www.w3.org/TR/SVG11/feature#BasicClip";                                                                
    public static final String SVG_FEATURE_BASIC_FILTER = "http://www.w3.org/TR/SVG11/feature#BasicFilter";                                                            
    public static final String SVG_FEATURE_BASIC_FONT = "http://www.w3.org/TR/SVG11/feature#BasicFont";                                                                
    public static final String SVG_FEATURE_BASIC_GRAPHICS_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#BasicGraphicsAttribute";                                      
    public static final String SVG_FEATURE_BASIC_PAINT_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#BasicPaintAttribute";                                            
    public static final String SVG_FEATURE_BASIC_STRUCTURE = "http://www.w3.org/TR/SVG11/feature#BasicStructure";                                                      
    public static final String SVG_FEATURE_BASIC_TEXT = "http://www.w3.org/TR/SVG11/feature#BasicText";                                                                
    public static final String SVG_FEATURE_CLIP = "http://www.w3.org/TR/SVG11/feature#Clip";                                                                          
    public static final String SVG_FEATURE_COLOR_PROFILE = "http://www.w3.org/TR/SVG11/feature#ColorProfile";                                                          
    public static final String SVG_FEATURE_CONDITIONAL_PROCESSING = "http://www.w3.org/TR/SVG11/feature#ConditionalProcessing";                                        
    public static final String SVG_FEATURE_CONTAINER_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#ContainerAttribute";                                              
    public static final String SVG_FEATURE_CORE_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#CoreAttribute";                                                        
    public static final String SVG_FEATURE_CURSOR = "http://www.w3.org/TR/SVG11/feature#Cursor";                                                                      
    public static final String SVG_FEATURE_DOCUMENT_EVENTS_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#DocumentEventsAttribute";                                    
    public static final String SVG_FEATURE_EXTENSIBILITY = "http://www.w3.org/TR/SVG11/feature#Extensibility";                                                        
    public static final String SVG_FEATURE_EXTERNAL_RESOURCES_REQUIRED = "http://www.w3.org/TR/SVG11/feature#ExternalResourcesRequired";                                
    public static final String SVG_FEATURE_FILTER = "http://www.w3.org/TR/SVG11/feature#Filter";                                                                      
    public static final String SVG_FEATURE_FONT = "http://www.w3.org/TR/SVG11/feature#Font";                                                                          
    public static final String SVG_FEATURE_GRADIENT = "http://www.w3.org/TR/SVG11/feature#Gradient";                                                                  
    public static final String SVG_FEATURE_GRAPHICAL_EVENTS_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#GraphicalEventsAttribute";                                  
    public static final String SVG_FEATURE_GRAPHICS_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#GraphicsAttribute";                                                
    public static final String SVG_FEATURE_HYPERLINKING = "http://www.w3.org/TR/SVG11/feature#Hyperlinking";                                                          
    public static final String SVG_FEATURE_IMAGE = "http://www.w3.org/TR/SVG11/feature#Image";                                                                        
    public static final String SVG_FEATURE_MARKER = "http://www.w3.org/TR/SVG11/feature#Marker";                                                                      
    public static final String SVG_FEATURE_MASK = "http://www.w3.org/TR/SVG11/feature#Mask";                                                                          
    public static final String SVG_FEATURE_OPACITY_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#OpacityAttribute";                                                  
    public static final String SVG_FEATURE_PAINT_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#PaintAttribute";
    public static final String SVG_FEATURE_PATTERN = "http://www.w3.org/TR/SVG11/feature#Pattern";
    public static final String SVG_FEATURE_SCRIPT = "http://www.w3.org/TR/SVG11/feature#Script";
    public static final String SVG_FEATURE_SCRIPTING = "http://www.w3.org/TR/SVG11/feature#Scripting";
    public static final String SVG_FEATURE_SHAPE = "http://www.w3.org/TR/SVG11/feature#Shape";
    public static final String SVG_FEATURE_STRUCTURE = "http://www.w3.org/TR/SVG11/feature#Structure";
    public static final String SVG_FEATURE_STYLE = "http://www.w3.org/TR/SVG11/feature#Style";
    public static final String SVG_FEATURE_SVG = "http://www.w3.org/TR/SVG11/feature#SVG";
    public static final String SVG_FEATURE_SVG_ANIMATION = "http://www.w3.org/TR/SVG11/feature#SVG-animation";
    public static final String SVG_FEATURE_SVGDOM = "http://www.w3.org/TR/SVG11/feature#SVGDOM";
    public static final String SVG_FEATURE_SVGDOM_ANIMATION = "http://www.w3.org/TR/SVG11/feature#SVGDOM-animation";
    public static final String SVG_FEATURE_SVGDOM_DYNAMIC = "http://www.w3.org/TR/SVG11/feature#SVGDOM-dynamic";
    public static final String SVG_FEATURE_SVGDOM_STATIC = "http://www.w3.org/TR/SVG11/feature#SVGDOM-static";
    public static final String SVG_FEATURE_SVG_DYNAMIC = "http://www.w3.org/TR/SVG11/feature#SVG-dynamic";
    public static final String SVG_FEATURE_SVG_STATIC = "http://www.w3.org/TR/SVG11/feature#SVG-static";
    public static final String SVG_FEATURE_TEXT = "http://www.w3.org/TR/SVG11/feature#Text";
    public static final String SVG_FEATURE_VIEW = "http://www.w3.org/TR/SVG11/feature#View";
    public static final String SVG_FEATURE_VIEWPORT_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#ViewportAttribute";
    public static final String SVG_FEATURE_XLINK_ATTRIBUTE = "http://www.w3.org/TR/SVG11/feature#XlinkAttribute";
    public static final String SVG_FEATURE_TOUCH_EVENTS = "http://www.vectomatic.org/TR/SVG11/feature#SVGTouchEvents";
    public static final String SVG_FEATURE_DND_EVENTS = "http://www.vectomatic.org/TR/SVG11/feature#SVGDndEvents";

    ///////////////////////////////////////////////////////////////////
    // CSS type
    ///////////////////////////////////////////////////////////////////
    
    public static final String CSS_TYPE = "text/css";
}
