/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.UnitConverter;

public final class AddConverter
extends UnitConverter {
    private final double _offset;
    private static final long serialVersionUID = 1L;

    public AddConverter(double offset) {
        if ((double)((float)offset) == 0.0) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._offset = offset;
    }

    public double getOffset() {
        return this._offset;
    }

    @Override
    public UnitConverter inverse() {
        return new AddConverter(-this._offset);
    }

    @Override
    public double convert(double amount) {
        return amount + this._offset;
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof AddConverter) {
            double offset = this._offset + ((AddConverter)converter)._offset;
            return AddConverter.valueOf(offset);
        }
        return super.concatenate(converter);
    }

    private static UnitConverter valueOf(double offset) {
        float asFloat = (float)offset;
        return asFloat == 0.0f ? UnitConverter.IDENTITY : new AddConverter(offset);
    }
}

