/*******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Steve Monnier OBEO - initial API and implementation
 *
 * SPDX-License-Identifier: EPL-1.0
 *     
 *******************************************************************************/
package org.eclipse.apogy.core.programs.javascript.impl;

import org.eclipse.apogy.core.invocator.AbstractProgramRuntime;
import org.eclipse.apogy.core.invocator.Program;
import org.eclipse.apogy.core.invocator.ProgramSettings;
import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsFactory;

public class JavaScriptProgramFactoryCustomImpl extends JavaScriptProgramFactoryImpl {

	@Override
	public Program createProgram() {
		return ApogyCoreJavaScriptProgramsFactory.eINSTANCE.createJavaScriptProgram();
	}

	@Override
	public AbstractProgramRuntime createProgramRuntime(Program program, ProgramSettings settings) {
		AbstractProgramRuntime runtime = ApogyCoreJavaScriptProgramsFactory.eINSTANCE.createJavaScriptProgramRuntime();
		runtime.setProgram(program);
		return runtime;
	}

	@Override
	public void applySettings(Program program, ProgramSettings settings) {
		// Nothing to do for now.
	}
} // JavaScriptProgramFactoryImpl
