/*******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Steve Monnier OBEO - initial API and implementation
 *
 * SPDX-License-Identifier: EPL-1.0
 *     
 *******************************************************************************/
package org.eclipse.apogy.core.programs.javascript.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;

public class ApogyJavaScriptFacadeCustomImpl extends ApogyJavaScriptFacadeImpl {

	public static String JAVASCRIPT_MAIN_FUNCTION_HEADER = "/**\n" + " *\n"
			+ " * This is the entry point of the program. The arguments are passed in the same\n"
			+ " * order as the variables are defined in the Apogy Session.\n" + " *\n";

	public String createJavaScriptCodeTemplate(InvocatorSession session, JavaScriptProgram javaScriptProgram) {
		StringBuffer sb = new StringBuffer();

		sb.append(JAVASCRIPT_MAIN_FUNCTION_HEADER);
		sb.append(" *\n");

		// Adds a param entry for each of the variables.
		List<String> variablesNames = new ArrayList<String>();
		for (Variable variable : session.getEnvironment().getVariablesList().getVariables()) {
			variablesNames.add(variable.getName());
			sb.append(" * @param {" + variable.getVariableType().getInterfaceClass().getInstanceTypeName() + "} "
					+ variable.getName() + "\n");
		}

		// Adds the variables
		Iterator<String> it2 = variablesNames.iterator();
		while (it2.hasNext()) {
			String variableName = it2.next();
			sb.append(" * @variable " + variableName + "\t" + variableName + "\n");
		}

		sb.append(" */");
		sb.append("\n");

		// Adds the function main
		sb.append("function main(");

		// Adds the parameters.
		Iterator<String> it = variablesNames.iterator();
		while (it.hasNext()) {
			sb.append(it.next());
			if (it.hasNext()) {
				sb.append(",");
			}
		}
		sb.append(") { \n\n }");

		return sb.toString();
	}

} // ApogyJavaScriptFacadeImpl
