/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.TypeConverter;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.XmlRpcInvocationException;
import org.apache.xmlrpc.common.XmlRpcNotAuthorizedException;
import org.apache.xmlrpc.metadata.Util;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;

public class ReflectiveXmlRpcHandler
implements XmlRpcHandler {
    private final AbstractReflectiveHandlerMapping mapping;
    private final MethodData[] methods;
    private final Class clazz;
    private final RequestProcessorFactoryFactory.RequestProcessorFactory requestProcessorFactory;

    public ReflectiveXmlRpcHandler(AbstractReflectiveHandlerMapping pMapping, TypeConverterFactory pTypeConverterFactory, Class pClass, RequestProcessorFactoryFactory.RequestProcessorFactory pFactory, Method[] pMethods) {
        this.mapping = pMapping;
        this.clazz = pClass;
        this.methods = new MethodData[pMethods.length];
        this.requestProcessorFactory = pFactory;
        int i = 0;
        while (i < this.methods.length) {
            this.methods[i] = new MethodData(pMethods[i], pTypeConverterFactory);
            ++i;
        }
    }

    private Object getInstance(XmlRpcRequest pRequest) throws XmlRpcException {
        return this.requestProcessorFactory.getRequestProcessor(pRequest);
    }

    @Override
    public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
        AbstractReflectiveHandlerMapping.AuthenticationHandler authHandler = this.mapping.getAuthenticationHandler();
        if (authHandler != null && !authHandler.isAuthorized(pRequest)) {
            throw new XmlRpcNotAuthorizedException("Not authorized");
        }
        Object[] args = new Object[pRequest.getParameterCount()];
        int j = 0;
        while (j < args.length) {
            args[j] = pRequest.getParameter(j);
            ++j;
        }
        Object instance = this.getInstance(pRequest);
        int i = 0;
        while (i < this.methods.length) {
            MethodData methodData = this.methods[i];
            TypeConverter[] converters = methodData.typeConverters;
            if (args.length == converters.length) {
                boolean matching = true;
                int j2 = 0;
                while (j2 < args.length) {
                    if (!converters[j2].isConvertable(args[j2])) {
                        matching = false;
                        break;
                    }
                    ++j2;
                }
                if (matching) {
                    j2 = 0;
                    while (j2 < args.length) {
                        args[j2] = converters[j2].convert(args[j2]);
                        ++j2;
                    }
                    return this.invoke(instance, methodData.method, args);
                }
            }
            ++i;
        }
        throw new XmlRpcException("No method " + pRequest.getMethodName() + " matching arguments: " + Util.getSignature(args));
    }

    private Object invoke(Object pInstance, Method pMethod, Object[] pArgs) throws XmlRpcException {
        try {
            return pMethod.invoke(pInstance, pArgs);
        }
        catch (IllegalAccessException e) {
            throw new XmlRpcException("Illegal access to method " + pMethod.getName() + " in class " + this.clazz.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new XmlRpcException("Illegal argument for method " + pMethod.getName() + " in class " + this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof XmlRpcException) {
                throw (XmlRpcException)t;
            }
            throw new XmlRpcInvocationException("Failed to invoke method " + pMethod.getName() + " in class " + this.clazz.getName() + ": " + t.getMessage(), t);
        }
    }

    private static class MethodData {
        final Method method;
        final TypeConverter[] typeConverters;

        MethodData(Method pMethod, TypeConverterFactory pTypeConverterFactory) {
            this.method = pMethod;
            Class<?>[] paramClasses = this.method.getParameterTypes();
            this.typeConverters = new TypeConverter[paramClasses.length];
            int i = 0;
            while (i < paramClasses.length) {
                this.typeConverters[i] = pTypeConverterFactory.getTypeConverter(paramClasses[i]);
                ++i;
            }
        }
    }
}

