/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ParameterConfiguration;
import org.apache.commons.math3.ode.ParameterJacobianProvider;
import org.apache.commons.math3.ode.ParameterizedODE;

class ParameterJacobianWrapper
implements ParameterJacobianProvider {
    private final FirstOrderDifferentialEquations fode;
    private final ParameterizedODE pode;
    private final Map<String, Double> hParam;

    public ParameterJacobianWrapper(FirstOrderDifferentialEquations fode, ParameterizedODE pode, ParameterConfiguration[] paramsAndSteps) {
        this.fode = fode;
        this.pode = pode;
        this.hParam = new HashMap<String, Double>();
        ParameterConfiguration[] parameterConfigurationArray = paramsAndSteps;
        int n = paramsAndSteps.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterConfiguration param = parameterConfigurationArray[n2];
            String name = param.getParameterName();
            if (pode.isSupported(name)) {
                this.hParam.put(name, param.getHP());
            }
            ++n2;
        }
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.pode.getParametersNames();
    }

    @Override
    public boolean isSupported(String name) {
        return this.pode.isSupported(name);
    }

    @Override
    public void computeParameterJacobian(double t, double[] y, double[] yDot, String paramName, double[] dFdP) throws DimensionMismatchException, MaxCountExceededException {
        int n = this.fode.getDimension();
        if (this.pode.isSupported(paramName)) {
            double[] tmpDot = new double[n];
            double p = this.pode.getParameter(paramName);
            double hP = this.hParam.get(paramName);
            this.pode.setParameter(paramName, p + hP);
            this.fode.computeDerivatives(t, y, tmpDot);
            int i = 0;
            while (i < n) {
                dFdP[i] = (tmpDot[i] - yDot[i]) / hP;
                ++i;
            }
            this.pode.setParameter(paramName, p);
        } else {
            Arrays.fill(dFdP, 0, n, 0.0);
        }
    }
}

