/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Arrays;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

class TriDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedQ;
    private RealMatrix cachedQt;
    private RealMatrix cachedT;

    public TriDiagonalTransformer(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.main = new double[m];
        this.secondary = new double[m - 1];
        this.cachedQ = null;
        this.cachedQt = null;
        this.cachedT = null;
        this.transform();
    }

    public RealMatrix getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public RealMatrix getQT() {
        if (this.cachedQt == null) {
            int m = this.householderVectors.length;
            double[][] qta = new double[m][m];
            int k = m - 1;
            while (k >= 1) {
                double[] hK = this.householderVectors[k - 1];
                qta[k][k] = 1.0;
                if (hK[k] != 0.0) {
                    double inv = 1.0 / (this.secondary[k - 1] * hK[k]);
                    double beta = 1.0 / this.secondary[k - 1];
                    qta[k][k] = 1.0 + beta * hK[k];
                    int i = k + 1;
                    while (i < m) {
                        qta[k][i] = beta * hK[i];
                        ++i;
                    }
                    int j = k + 1;
                    while (j < m) {
                        beta = 0.0;
                        int i2 = k + 1;
                        while (i2 < m) {
                            beta += qta[j][i2] * hK[i2];
                            ++i2;
                        }
                        qta[j][k] = (beta *= inv) * hK[k];
                        i2 = k + 1;
                        while (i2 < m) {
                            double[] dArray = qta[j];
                            int n = i2;
                            dArray[n] = dArray[n] + beta * hK[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                --k;
            }
            qta[0][0] = 1.0;
            this.cachedQt = MatrixUtils.createRealMatrix(qta);
        }
        return this.cachedQt;
    }

    public RealMatrix getT() {
        if (this.cachedT == null) {
            int m = this.main.length;
            double[][] ta = new double[m][m];
            int i = 0;
            while (i < m) {
                ta[i][i] = this.main[i];
                if (i > 0) {
                    ta[i][i - 1] = this.secondary[i - 1];
                }
                if (i < this.main.length - 1) {
                    ta[i][i + 1] = this.secondary[i];
                }
                ++i;
            }
            this.cachedT = MatrixUtils.createRealMatrix(ta);
        }
        return this.cachedT;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    private void transform() {
        int m = this.householderVectors.length;
        double[] z = new double[m];
        int k = 0;
        while (k < m - 1) {
            double a;
            double[] hK = this.householderVectors[k];
            this.main[k] = hK[k];
            double xNormSqr = 0.0;
            int j = k + 1;
            while (j < m) {
                double c = hK[j];
                xNormSqr += c * c;
                ++j;
            }
            this.secondary[k] = a = hK[k + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a != 0.0) {
                int n = k + 1;
                hK[n] = hK[n] - a;
                double beta = -1.0 / (a * hK[k + 1]);
                Arrays.fill(z, k + 1, m, 0.0);
                int i = k + 1;
                while (i < m) {
                    double[] hI = this.householderVectors[i];
                    double hKI = hK[i];
                    double zI = hI[i] * hKI;
                    int j2 = i + 1;
                    while (j2 < m) {
                        double hIJ = hI[j2];
                        zI += hIJ * hK[j2];
                        int n2 = j2++;
                        z[n2] = z[n2] + hIJ * hKI;
                    }
                    z[i] = beta * (z[i] + zI);
                    ++i;
                }
                double gamma = 0.0;
                int i2 = k + 1;
                while (i2 < m) {
                    gamma += z[i2] * hK[i2];
                    ++i2;
                }
                gamma *= beta / 2.0;
                i2 = k + 1;
                while (i2 < m) {
                    int n3 = i2;
                    z[n3] = z[n3] - gamma * hK[i2];
                    ++i2;
                }
                i2 = k + 1;
                while (i2 < m) {
                    double[] hI = this.householderVectors[i2];
                    int j3 = i2;
                    while (j3 < m) {
                        int n4 = j3;
                        hI[n4] = hI[n4] - (hK[i2] * z[j3] + z[i2] * hK[j3]);
                        ++j3;
                    }
                    ++i2;
                }
            }
            ++k;
        }
        this.main[m - 1] = this.householderVectors[m - 1][m - 1];
    }
}

