/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class PolynomialFunctionLagrangeForm
implements UnivariateFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
        if (!PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, false)) {
            MathArrays.sortInPlace(this.x, new double[][]{this.y});
            PolynomialFunctionLagrangeForm.verifyInterpolationArray(this.x, this.y, true);
        }
    }

    @Override
    public double value(double z) {
        return PolynomialFunctionLagrangeForm.evaluateInternal(this.x, this.y, z);
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x, double[] y, double z) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y, false)) {
            return PolynomialFunctionLagrangeForm.evaluateInternal(x, y, z);
        }
        double[] xNew = new double[x.length];
        double[] yNew = new double[y.length];
        System.arraycopy(x, 0, xNew, 0, x.length);
        System.arraycopy(y, 0, yNew, 0, y.length);
        MathArrays.sortInPlace(xNew, new double[][]{yNew});
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(xNew, yNew, true);
        return PolynomialFunctionLagrangeForm.evaluateInternal(xNew, yNew, z);
    }

    private static double evaluateInternal(double[] x, double[] y, double z) {
        int nearest = 0;
        int n = x.length;
        double[] c = new double[n];
        double[] d = new double[n];
        double min_dist = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < n) {
            c[i] = y[i];
            d[i] = y[i];
            double dist = FastMath.abs(z - x[i]);
            if (dist < min_dist) {
                nearest = i;
                min_dist = dist;
            }
            ++i;
        }
        double value = y[nearest];
        int i2 = 1;
        while (i2 < n) {
            int j = 0;
            while (j < n - i2) {
                double tc = x[j] - z;
                double td = x[i2 + j] - z;
                double divider = x[j] - x[i2 + j];
                double w = (c[j + 1] - d[j]) / divider;
                c[j] = tc * w;
                d[j] = td * w;
                ++j;
            }
            value = (double)nearest < 0.5 * (double)(n - i2 + 1) ? (value += c[nearest]) : (value += d[--nearest]);
            ++i2;
        }
        return value;
    }

    protected void computeCoefficients() {
        int n = this.degree() + 1;
        this.coefficients = new double[n];
        int i = 0;
        while (i < n) {
            this.coefficients[i] = 0.0;
            ++i;
        }
        double[] c = new double[n + 1];
        c[0] = 1.0;
        int i2 = 0;
        while (i2 < n) {
            int j = i2;
            while (j > 0) {
                c[j] = c[j - 1] - c[j] * this.x[i2];
                --j;
            }
            c[0] = c[0] * -this.x[i2];
            c[i2 + 1] = 1.0;
            ++i2;
        }
        double[] tc = new double[n];
        int i3 = 0;
        while (i3 < n) {
            double d = 1.0;
            int j = 0;
            while (j < n) {
                if (i3 != j) {
                    d *= this.x[i3] - this.x[j];
                }
                ++j;
            }
            double t = this.y[i3] / d;
            tc[n - 1] = c[n];
            int n2 = n - 1;
            this.coefficients[n2] = this.coefficients[n2] + t * tc[n - 1];
            int j2 = n - 2;
            while (j2 >= 0) {
                tc[j2] = c[j2 + 1] + tc[j2 + 1] * this.x[i3];
                int n3 = j2;
                this.coefficients[n3] = this.coefficients[n3] + t * tc[j2];
                --j2;
            }
            ++i3;
        }
        this.coefficientsComputed = true;
    }

    public static boolean verifyInterpolationArray(double[] x, double[] y, boolean abort) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)2, x.length, true);
        }
        return MathArrays.checkOrder(x, MathArrays.OrderDirection.INCREASING, true, abort);
    }
}

