/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class LibMatrixReplace {
    private LibMatrixReplace() {
    }

    public static MatrixBlock replaceOperations(MatrixBlock in, MatrixBlock ret, double pattern, double replacement) {
        return LibMatrixReplace.replaceOperations(in, ret, pattern, replacement, InfrastructureAnalyzer.getLocalParallelism());
    }

    public static MatrixBlock replaceOperations(MatrixBlock in, MatrixBlock ret, double pattern, double replacement, int k) {
        in.examSparsity(k);
        int rlen = in.getNumRows();
        int clen = in.getNumColumns();
        long nonZeros = in.getNonZeros();
        boolean sparse = in.isInSparseFormat();
        if (ret != null) {
            ret.reset(rlen, clen, sparse);
        } else {
            ret = new MatrixBlock(rlen, clen, sparse);
        }
        if (nonZeros == 0L && pattern != 0.0) {
            return ret;
        }
        if (!in.containsValue(pattern)) {
            return in;
        }
        if (in.isEmpty() && pattern == 0.0) {
            ret.reset(rlen, clen, replacement);
            return ret;
        }
        boolean replaceNaN = Double.isNaN(pattern);
        long nnz = sparse ? LibMatrixReplace.replaceSparse(in, ret, pattern, replacement, replaceNaN) : (replaceNaN ? LibMatrixReplace.replaceDenseNaN(in, ret, replacement) : LibMatrixReplace.replaceDense(in, ret, pattern, replacement));
        ret.setNonZeros(nnz);
        ret.examSparsity(k);
        return ret;
    }

    private static long replaceSparse(MatrixBlock in, MatrixBlock ret, double pattern, double replacement, boolean replaceNaN) {
        if (replaceNaN) {
            return LibMatrixReplace.replaceSparseInSparseOutReplaceNaN(in, ret, replacement);
        }
        if (pattern != 0.0) {
            return LibMatrixReplace.replaceSparseInSparseOut(in, ret, pattern, replacement);
        }
        return LibMatrixReplace.replace0InSparse(in, ret, replacement);
    }

    private static long replaceSparseInSparseOutReplaceNaN(MatrixBlock in, MatrixBlock ret, double replacement) {
        ret.allocateSparseRowsBlock();
        SparseBlock a = in.sparseBlock;
        SparseBlock c = ret.sparseBlock;
        long nnz = 0L;
        for (int i = 0; i < in.rlen; ++i) {
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int alen = a.size(i);
            c.allocate(i, alen);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            for (int j = apos; j < apos + alen; ++j) {
                double val = avals[j];
                if (Double.isNaN(val)) {
                    c.append(i, aix[j], replacement);
                    continue;
                }
                c.append(i, aix[j], val);
            }
            c.compact(i);
            nnz += (long)c.size(i);
        }
        return nnz;
    }

    private static long replaceSparseInSparseOut(MatrixBlock in, MatrixBlock ret, double pattern, double replacement) {
        ret.allocateSparseRowsBlock();
        SparseBlock a = in.sparseBlock;
        SparseBlock c = ret.sparseBlock;
        return LibMatrixReplace.replaceSparseInSparseOut(a, c, pattern, replacement, 0, in.rlen);
    }

    private static long replaceSparseInSparseOut(SparseBlock a, SparseBlock c, double pattern, double replacement, int s, int e) {
        long nnz = 0L;
        for (int i = s; i < e; ++i) {
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            c.allocate(i, alen);
            for (int j = apos; j < apos + alen; ++j) {
                double val = avals[j];
                if (val == pattern) {
                    c.append(i, aix[j], replacement);
                    continue;
                }
                c.append(i, aix[j], val);
            }
            c.compact(i);
            nnz += (long)c.size(i);
        }
        return nnz;
    }

    private static long replace0InSparse(MatrixBlock in, MatrixBlock ret, double replacement) {
        ret.sparse = false;
        ret.allocateDenseBlock();
        SparseBlock a = in.sparseBlock;
        DenseBlock c = ret.getDenseBlock();
        if (a == null) {
            return (long)in.rlen * (long)in.clen;
        }
        for (int i = 0; i < in.rlen; ++i) {
            c.fillRow(i, replacement);
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int cpos = c.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            double[] cvals = c.values(i);
            for (int j = apos; j < apos + alen; ++j) {
                if (avals[j] == 0.0) continue;
                cvals[cpos + aix[j]] = avals[j];
            }
        }
        return (long)in.rlen * (long)in.clen;
    }

    private static long replaceDense(MatrixBlock in, MatrixBlock ret, double pattern, double replacement) {
        DenseBlock a = in.getDenseBlock();
        DenseBlock c = ret.allocateDenseBlock().getDenseBlock();
        long nnz = 0L;
        for (int bi = 0; bi < a.numBlocks(); ++bi) {
            int len = a.size(bi);
            double[] avals = a.valuesAt(bi);
            double[] cvals = c.valuesAt(bi);
            for (int i = 0; i < len; ++i) {
                cvals[i] = avals[i] == pattern ? replacement : avals[i];
                nnz += cvals[i] != 0.0 ? 1L : 0L;
            }
        }
        return nnz;
    }

    private static long replaceDenseNaN(MatrixBlock in, MatrixBlock ret, double replacement) {
        DenseBlock a = in.getDenseBlock();
        DenseBlock c = ret.allocateDenseBlock().getDenseBlock();
        long nnz = 0L;
        for (int bi = 0; bi < a.numBlocks(); ++bi) {
            int len = a.size(bi);
            double[] avals = a.valuesAt(bi);
            double[] cvals = c.valuesAt(bi);
            for (int i = 0; i < len; ++i) {
                cvals[i] = Double.isNaN(avals[i]) ? replacement : avals[i];
                nnz += cvals[i] != 0.0 ? 1L : 0L;
            }
        }
        return nnz;
    }
}

