/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.data.TensorIndexes;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.TensorWriter;
import org.apache.sysds.runtime.util.HDFSTool;

public class TensorWriterBinaryBlock
extends TensorWriter {
    @Override
    public void writeTensorToHDFS(TensorBlock src, String fname, int blen) throws IOException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        HDFSTool.addBinaryBlockSerializationFramework((Configuration)job);
        this.writeBinaryBlockTensorToHDFS(path, job, fs, src, blen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeBinaryBlockTensorToHDFS(Path path, JobConf job, FileSystem fs, TensorBlock src, int blen) throws IOException {
        TensorWriterBinaryBlock.writeBinaryBlockTensorToSequenceFile(path, job, fs, src, blen, 0, src.getNumRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBinaryBlockTensorToSequenceFile(Path path, JobConf job, FileSystem fs, TensorBlock src, int blen, int rl, int ru) throws IOException {
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriterTensor(path, (Configuration)job, 1);
        try {
            int i;
            int[] dims = src.getDims();
            for (int i2 = 0; i2 < dims.length; ++i2) {
                if (src.getDim(i2) <= dims[i2]) continue;
                throw new IOException("TensorBlock dimension " + i2 + " range [1:" + src.getDim(i2) + "] out of range [1:" + dims[i2] + "].");
            }
            long numBlocks = Math.max((long)Math.ceil((double)(ru - rl) / (double)blen), 1L);
            for (i = 1; i < dims.length; ++i) {
                numBlocks *= Math.max((long)Math.ceil((double)dims[i] / (double)blen), 1L);
            }
            i = 0;
            while ((long)i < numBlocks) {
                TensorBlock block;
                int[] offsets = new int[dims.length];
                long blockIndex = i;
                long[] tix = new long[dims.length];
                int[] blockDims = new int[dims.length];
                for (int j = dims.length - 1; j >= 0; --j) {
                    long numDimBlocks = Math.max((long)Math.ceil((double)src.getDim(j) / (double)blen), 1L);
                    tix[j] = 1L + blockIndex % numDimBlocks;
                    if (j == 0) {
                        int n = j;
                        tix[n] = tix[n] + (long)(rl / blen);
                    }
                    blockIndex /= numDimBlocks;
                    offsets[j] = ((int)tix[j] - 1) * blen;
                    blockDims[j] = tix[j] * (long)blen < (long)src.getDim(j) ? blen : src.getDim(j) - offsets[j];
                }
                TensorIndexes indx = new TensorIndexes(tix);
                if (src.isBasic()) {
                    block = new TensorBlock(src.getValueType(), blockDims).allocateBlock();
                } else {
                    Types.ValueType[] schema = src.getSchema();
                    Types.ValueType[] blockSchema = Arrays.copyOfRange(schema, offsets[1], offsets[1] + blockDims[1]);
                    block = new TensorBlock(blockSchema, blockDims).allocateBlock();
                }
                src.slice(offsets, block);
                writer.append((Writable)indx, (Writable)block);
                ++i;
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

