/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ACLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ConstScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class EmptyScheme
extends ACLAScheme {
    public EmptyScheme(IColIndex idx) {
        super(idx);
    }

    public static EmptyScheme create(ColGroupEmpty g) {
        return new EmptyScheme(g.getColIndices());
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return this;
        }
        if (data.isInSparseFormat()) {
            return this.updateSparse(data, columns);
        }
        if (data.getDenseBlock().isContiguous()) {
            return this.updateDense(data, columns);
        }
        return this.updateGeneric(data, columns);
    }

    private ICLAScheme updateGeneric(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        int nColScheme = columns.size();
        for (int r = 0; r < nRow; ++r) {
            for (int c = 0; c < nColScheme; ++c) {
                double v = data.get(r, columns.get(c));
                if (v == 0.0) continue;
                return this.updateToHigherScheme(data, columns);
            }
        }
        return this;
    }

    private ICLAScheme updateDense(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        int nCol = data.getNumColumns();
        int nColScheme = columns.size();
        double[] values = data.getDenseBlockValues();
        for (int r = 0; r < nRow; ++r) {
            int off = r * nCol;
            for (int c = 0; c < nColScheme; ++c) {
                double v = values[off + columns.get(c)];
                if (v == 0.0) continue;
                return this.updateToHigherScheme(data, columns);
            }
        }
        return this;
    }

    private ICLAScheme updateSparse(MatrixBlock data, IColIndex columns) {
        SparseBlock sb = data.getSparseBlock();
        int nRow = data.getNumRows();
        if (columns.size() == 1) {
            int col = columns.get(0);
            for (int i = 0; i < nRow; ++i) {
                if (sb.get(i, col) != 0.0) continue;
                return this.updateToHigherScheme(data, columns);
            }
        } else if (columns.size() * 2 > data.getNumColumns()) {
            for (int i = 0; i < nRow; ++i) {
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                int offC = 0;
                while (apos < alen || offC < columns.size()) {
                    int va = aix[apos];
                    int vb = columns.get(offC);
                    if (va < vb) {
                        ++apos;
                        continue;
                    }
                    if (vb < va) {
                        ++offC;
                        continue;
                    }
                    if (va != vb) continue;
                    return this.updateToHigherScheme(data, columns);
                }
            }
        } else {
            for (int i = 0; i < nRow; ++i) {
                int j = 0;
                while (i < columns.size()) {
                    int col = columns.get(j);
                    if (sb.get(i, col) == 0.0) {
                        return this.updateToHigherScheme(data, columns);
                    }
                    ++j;
                }
            }
        }
        return this;
    }

    private ICLAScheme updateToHigherScheme(MatrixBlock data, IColIndex columns) {
        double[] vals = new double[this.cols.size()];
        for (int c = 0; c < this.cols.size(); ++c) {
            vals[c] = data.get(0, c);
        }
        return ConstScheme.create(columns, vals).update(data, columns);
    }

    private ICLAScheme updateToHigherSchemeT(MatrixBlock data, IColIndex columns) {
        double[] vals = new double[this.cols.size()];
        for (int c = 0; c < this.cols.size(); ++c) {
            vals[c] = data.get(c, 0);
        }
        return ConstScheme.create(columns, vals).updateT(data, columns);
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        return new ColGroupEmpty(columns);
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        return new ColGroupEmpty(columns);
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return this;
        }
        if (data.isInSparseFormat()) {
            return this.updateSparseT(data, columns);
        }
        return this.updateDenseT(data, columns);
    }

    private ICLAScheme updateDenseT(MatrixBlock data, IColIndex columns) {
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < columns.size(); ++i) {
            int col = columns.get(i);
            double[] vals = db.values(col);
            int nCol = data.getNumColumns();
            int start = db.pos(col);
            int off = db.pos(col);
            while (i < nCol + start) {
                if (vals[off] != 0.0) {
                    return this.updateToHigherSchemeT(data, columns);
                }
                ++off;
            }
        }
        return this;
    }

    private ICLAScheme updateSparseT(MatrixBlock data, IColIndex columns) {
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < columns.size(); ++i) {
            if (sb.isEmpty(columns.get(i))) continue;
            return this.updateToHigherSchemeT(data, columns);
        }
        return this;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" Cols: ");
        sb.append(this.cols);
        return sb.toString();
    }

    @Override
    public EmptyScheme clone() {
        return new EmptyScheme(this.cols);
    }
}

