/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.CompressionSettingsBuilder;
import org.apache.sysds.runtime.compress.colgroup.ColGroupFactory;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public abstract class AColGroup
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)AColGroup.class.getName());
    private static final long serialVersionUID = -1318908671481L;
    protected final IColIndex _colIndexes;

    protected AColGroup(IColIndex colIndices) {
        this._colIndexes = colIndices;
    }

    public final IColIndex getColIndices() {
        return this._colIndexes;
    }

    public final int getNumCols() {
        return this._colIndexes.size();
    }

    public final AColGroup shiftColIndices(int offset) {
        return this.copyAndSet(this._colIndexes.shift(offset));
    }

    public abstract AColGroup copyAndSet(IColIndex var1);

    public long estimateInMemorySize() {
        long size = 16L;
        return size += this._colIndexes.estimateInMemorySize();
    }

    public final void decompressToSparseBlock(SparseBlock sb, int rl, int ru) {
        this.decompressToSparseBlock(sb, rl, ru, 0, 0);
    }

    public final void decompressToDenseBlock(DenseBlock db, int rl, int ru) {
        this.decompressToDenseBlock(db, rl, ru, 0, 0);
    }

    public abstract void decompressToDenseBlockTransposed(DenseBlock var1, int var2, int var3);

    public abstract void decompressToSparseBlockTransposed(SparseBlockMCSR var1, int var2);

    protected void write(DataOutput out) throws IOException {
        byte[] o = new byte[]{(byte)this.getColGroupType().ordinal()};
        out.write(o);
        this._colIndexes.write(out);
    }

    public long getExactSizeOnDisk() {
        long ret = 0L;
        ++ret;
        return ret += this._colIndexes.getExactSizeOnDisk();
    }

    public final AColGroup sliceColumns(int cl, int cu) {
        if (cl <= this._colIndexes.get(0) && cu > this._colIndexes.get(this._colIndexes.size() - 1)) {
            if (cl == 0) {
                return this;
            }
            return this.shiftColIndices(-cl);
        }
        if (cu - cl == 1) {
            return this.sliceColumn(cl);
        }
        return this.sliceMultiColumns(cl, cu);
    }

    public final AColGroup sliceColumn(int col) {
        int idx = this._colIndexes.findIndex(col);
        if (idx >= 0) {
            return this.sliceSingleColumn(idx);
        }
        return null;
    }

    protected final AColGroup sliceMultiColumns(int cl, int cu) {
        IColIndex.SliceResult sr = this._colIndexes.slice(cl, cu);
        if (sr.ret != null) {
            return this.sliceMultiColumns(sr.idStart, sr.idEnd, sr.ret);
        }
        return null;
    }

    public static double[] colSum(Collection<AColGroup> groups, double[] res, int nRows) {
        for (AColGroup g : groups) {
            g.computeColSums(res, nRows);
        }
        return res;
    }

    public double get(int r, int c) {
        int colIdx = this._colIndexes.findIndex(c);
        if (colIdx < 0) {
            return 0.0;
        }
        return this.getIdx(r, colIdx);
    }

    public abstract double getIdx(int var1, int var2);

    public abstract int getNumValues();

    public abstract CompressionType getCompType();

    protected abstract ColGroupType getColGroupType();

    public abstract void decompressToDenseBlock(DenseBlock var1, int var2, int var3, int var4, int var5);

    public abstract void decompressToSparseBlock(SparseBlock var1, int var2, int var3, int var4, int var5);

    public final AColGroup rightMultByMatrix(MatrixBlock right) {
        return this.rightMultByMatrix(right, null, 1);
    }

    public abstract AColGroup rightMultByMatrix(MatrixBlock var1, IColIndex var2, int var3);

    public void rightDecompressingMult(MatrixBlock right, MatrixBlock ret, int rl, int ru, int nRows, int crl, int cru) {
        throw new NotImplementedException("not supporting right Decompressing Multiply on class: " + this.getClass().getSimpleName());
    }

    public abstract void tsmm(MatrixBlock var1, int var2);

    public abstract void leftMultByMatrixNoPreAgg(MatrixBlock var1, MatrixBlock var2, int var3, int var4, int var5, int var6);

    public abstract void leftMultByAColGroup(AColGroup var1, MatrixBlock var2, int var3);

    public abstract void tsmmAColGroup(AColGroup var1, MatrixBlock var2);

    public abstract AColGroup scalarOperation(ScalarOperator var1);

    public abstract AColGroup binaryRowOpLeft(BinaryOperator var1, double[] var2, boolean var3);

    public AColGroup addVector(double[] v) {
        return this.binaryRowOpRight(new BinaryOperator(Plus.getPlusFnObject(), 1), v, false);
    }

    public abstract AColGroup binaryRowOpRight(BinaryOperator var1, double[] var2, boolean var3);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2, int var3, int var4, int var5);

    protected abstract AColGroup sliceSingleColumn(int var1);

    protected abstract AColGroup sliceMultiColumns(int var1, int var2, IColIndex var3);

    public abstract AColGroup sliceRows(int var1, int var2);

    public abstract double getMin();

    public abstract double getMax();

    public abstract double getSum(int var1);

    public abstract boolean containsValue(double var1);

    public abstract long getNumberNonZeros(int var1);

    public abstract AColGroup replace(double var1, double var3);

    public abstract void computeColSums(double[] var1, int var2);

    public abstract CM_COV_Object centralMoment(CMOperator var1, int var2);

    public abstract AColGroup rexpandCols(int var1, boolean var2, boolean var3, int var4);

    public abstract double getCost(ComputationCostEstimator var1, int var2);

    public abstract AColGroup unaryOperation(UnaryOperator var1);

    public abstract boolean isEmpty();

    public abstract AColGroup append(AColGroup var1);

    public static AColGroup appendN(AColGroup[] groups, int blen, int rlen) {
        return groups[0].appendNInternal(groups, blen, rlen);
    }

    protected abstract AColGroup appendNInternal(AColGroup[] var1, int var2, int var3);

    public abstract ICLAScheme getCompressionScheme();

    public void clear() {
    }

    public abstract AColGroup recompress();

    public AColGroup morph(CompressionType ct, int nRow) {
        if (ct == this.getCompType()) {
            return this;
        }
        if (ct == CompressionType.DDCFOR) {
            return this;
        }
        if (ct == CompressionType.UNCOMPRESSED) {
            AColGroup cgMoved = this.copyAndSet(ColIndexFactory.create(this._colIndexes.size()));
            long nnz = this.getNumberNonZeros(nRow);
            MatrixBlock newDict = new MatrixBlock(nRow, this._colIndexes.size(), nnz);
            newDict.allocateBlock();
            if (newDict.isInSparseFormat()) {
                cgMoved.decompressToSparseBlock(newDict.getSparseBlock(), 0, nRow);
            } else {
                cgMoved.decompressToDenseBlock(newDict.getDenseBlock(), 0, nRow);
            }
            newDict.setNonZeros(nnz);
            AColGroup cgUC = ColGroupUncompressed.create(newDict);
            return cgUC.copyAndSet(this._colIndexes);
        }
        throw new NotImplementedException("Morphing from : " + this.getCompType() + " to " + ct + " is not implemented");
    }

    public abstract CompressedSizeInfoColGroup getCompressionInfo(int var1);

    public AColGroup combine(AColGroup other, int nRow) {
        return CLALibCombineGroups.combine(this, other, nRow);
    }

    public IEncode getEncoding() {
        throw new NotImplementedException();
    }

    public AColGroup sortColumnIndexes() {
        if (this._colIndexes.isSorted()) {
            return this;
        }
        int[] reorderingIndex = this._colIndexes.getReorderingIndex();
        IColIndex ni = this._colIndexes.sort();
        return this.fixColIndexes(ni, reorderingIndex);
    }

    protected abstract AColGroup fixColIndexes(IColIndex var1, int[] var2);

    public abstract AColGroup reduceCols();

    public final void selectionMultiply(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        if (ret.isInSparseFormat()) {
            this.sparseSelection(selection, points, ret, rl, ru);
        } else {
            this.denseSelection(selection, points, ret, rl, ru);
        }
    }

    public abstract double getSparsity();

    protected abstract void sparseSelection(MatrixBlock var1, ColGroupUtils.P[] var2, MatrixBlock var3, int var4, int var5);

    protected abstract void denseSelection(MatrixBlock var1, ColGroupUtils.P[] var2, MatrixBlock var3, int var4, int var5);

    public boolean sameIndexStructure(AColGroup that) {
        return false;
    }

    public AColGroup combineWithSameIndex(int nRow, int nCol, List<AColGroup> right) {
        IColIndex combinedColIndex = this.combineColIndexes(nCol, right);
        MatrixBlock decompressTarget = new MatrixBlock(nRow, combinedColIndex.size(), false);
        decompressTarget.allocateDenseBlock();
        DenseBlock db = decompressTarget.getDenseBlock();
        int nColInThisGroup = this._colIndexes.size();
        this.copyAndSet(ColIndexFactory.create(nColInThisGroup)).decompressToDenseBlock(db, 0, nRow);
        for (int i = 0; i < right.size(); ++i) {
            right.get(i).copyAndSet(ColIndexFactory.create(i * nColInThisGroup, i * nColInThisGroup + nColInThisGroup)).decompressToDenseBlock(db, 0, nRow);
        }
        decompressTarget.setNonZeros(nRow * combinedColIndex.size());
        CompressedSizeInfoColGroup ci = new CompressedSizeInfoColGroup(ColIndexFactory.create(combinedColIndex.size()), nRow, nRow, CompressionType.DDC);
        CompressedSizeInfo csi = new CompressedSizeInfo(ci);
        CompressionSettings cs = new CompressionSettingsBuilder().create();
        return ColGroupFactory.compressColGroups(decompressTarget, csi, cs).get(0).copyAndSet(combinedColIndex);
    }

    public AColGroup combineWithSameIndex(int nRow, int nCol, AColGroup right) {
        IColIndex combinedColIndex = this._colIndexes.combine(right._colIndexes.shift(nCol));
        MatrixBlock decompressTarget = new MatrixBlock(nRow, combinedColIndex.size(), false);
        decompressTarget.allocateDenseBlock();
        DenseBlock db = decompressTarget.getDenseBlock();
        int nColInThisGroup = this._colIndexes.size();
        this.copyAndSet(ColIndexFactory.create(nColInThisGroup)).decompressToDenseBlock(db, 0, nRow);
        right.copyAndSet(ColIndexFactory.create(nColInThisGroup, nColInThisGroup + nColInThisGroup)).decompressToDenseBlock(db, 0, nRow);
        decompressTarget.setNonZeros(nRow * combinedColIndex.size());
        CompressedSizeInfoColGroup ci = new CompressedSizeInfoColGroup(ColIndexFactory.create(combinedColIndex.size()), nRow, nRow, CompressionType.DDC);
        CompressedSizeInfo csi = new CompressedSizeInfo(ci);
        CompressionSettings cs = new CompressionSettingsBuilder().create();
        return ColGroupFactory.compressColGroups(decompressTarget, csi, cs).get(0).copyAndSet(combinedColIndex);
    }

    protected IColIndex combineColIndexes(int nCol, List<AColGroup> right) {
        IColIndex combinedColIndex = this._colIndexes;
        for (int i = 0; i < right.size(); ++i) {
            combinedColIndex = combinedColIndex.combine(right.get(i).getColIndices().shift(nCol * i + nCol));
        }
        return combinedColIndex;
    }

    public abstract AColGroup[] splitReshape(int var1, int var2, int var3);

    public AColGroup[] splitReshapePushDown(int multiplier, int nRow, int nColOrg, ExecutorService pool) throws Exception {
        return this.splitReshape(multiplier, nRow, nColOrg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n%15s", "Type: "));
        sb.append(this.getClass().getSimpleName());
        sb.append(String.format("\n%15s", "Columns: "));
        sb.append(this._colIndexes);
        return sb.toString();
    }

    protected static enum ColGroupType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCSingle,
        SDCSingleZeros,
        SDCZeros,
        SDCFOR,
        DDCFOR,
        DeltaDDC,
        LinearFunctional;

    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCFOR,
        DDCFOR,
        DeltaDDC,
        LinearFunctional;


        public boolean isDense() {
            return this == DDC || this == CONST || this == DDCFOR || this == DDCFOR;
        }

        public boolean isConst() {
            return this == CONST || this == EMPTY;
        }

        public boolean isSDC() {
            return this == SDC;
        }
    }
}

