/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.InvalidMessageError;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.transconsole.common.messages.InvalidMessageBundleException;
import com.google.transconsole.common.messages.MessageBundle;
import java.util.List;

public class Util {
    private static final String PROJECT_ID = "AdWordsSelect";
    private static final String LANGUAGE_ID = "en-US";

    private Util() {
        throw new AssertionError((Object)"Don't instantiate me!");
    }

    public static <K, V> ImmutableList<V> map(List<K> fromList, Function<? super K, ? extends V> function) {
        return ImmutableList.copyOf(Lists.transform(fromList, function));
    }

    public static MessageBundle bundleMessages(AlertSink alertSink, List<ExtractedMessage> messages) {
        MessageBundle messageBundle = new MessageBundle(PROJECT_ID, LANGUAGE_ID);
        for (ExtractedMessage msg : messages) {
            try {
                messageBundle.addMessage(msg.getTcMessage());
            }
            catch (InvalidMessageBundleException e) {
                alertSink.add(new InvalidMessageError(msg.getSourcePosition(), e.getCause()));
            }
        }
        return messageBundle;
    }
}

