/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.Closeables;
import com.google.gxp.com.google.common.io.IoSupplier;
import com.google.gxp.com.google.common.io.LimitInputStream;
import com.google.gxp.com.google.common.io.MultiInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.Checksum;

public final class Bytes {
    private static final int BUF_SIZE = 4096;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private Bytes() {
    }

    public static IoSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] b) {
        return Bytes.newInputStreamSupplier(b, 0, b.length);
    }

    public static IoSupplier<ByteArrayInputStream> newInputStreamSupplier(final byte[] b, final int off, final int len) {
        return new IoSupplier<ByteArrayInputStream>(){

            @Override
            public ByteArrayInputStream get() {
                return new ByteArrayInputStream(b, off, len);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(IoSupplier<? extends InputStream> from, IoSupplier<? extends OutputStream> to) throws IOException {
        boolean threw = true;
        InputStream in = from.get();
        try {
            long l;
            OutputStream out = to.get();
            try {
                long count = Bytes.copy(in, out);
                threw = false;
                l = count;
            }
            catch (Throwable throwable) {
                Closeables.close(out, threw);
                throw throwable;
            }
            Closeables.close(out, threw);
            return l;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(IoSupplier<? extends InputStream> from, OutputStream to) throws IOException {
        boolean threw = true;
        InputStream in = from.get();
        try {
            long count = Bytes.copy(in, to);
            threw = false;
            long l = count;
            return l;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4096);
        long total = 0L;
        while (from.read(buf) != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                total += (long)to.write(buf);
            }
            buf.clear();
        }
        return total;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Bytes.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(IoSupplier<? extends InputStream> supplier) throws IOException {
        boolean threw = true;
        InputStream in = supplier.get();
        try {
            byte[] result = Bytes.toByteArray(in);
            threw = false;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    public static long length(IoSupplier<? extends InputStream> supplier) throws IOException {
        long count = 0L;
        boolean threw = true;
        InputStream in = supplier.get();
        try {
            while (true) {
                long amt;
                if ((amt = in.skip(Integer.MAX_VALUE)) == 0L) {
                    if (in.read() == -1) {
                        threw = false;
                        long l = count;
                        return l;
                    }
                    ++count;
                    continue;
                }
                count += amt;
            }
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    public static boolean equal(IoSupplier<? extends InputStream> supplier1, IoSupplier<? extends InputStream> supplier2) throws IOException {
        byte[] buf1 = new byte[4096];
        byte[] buf2 = new byte[4096];
        boolean threw = true;
        InputStream in1 = supplier1.get();
        try {
            InputStream in2 = supplier2.get();
            try {
                while (true) {
                    int read2;
                    int read1;
                    if ((read1 = Bytes.read(in1, buf1, 0, 4096)) != (read2 = Bytes.read(in2, buf2, 0, 4096)) || !Arrays.equals(buf1, buf2)) {
                        threw = false;
                        boolean bl = false;
                        return bl;
                    }
                    if (read1 == 4096) continue;
                    threw = false;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                Closeables.close(in2, threw);
            }
        }
        finally {
            Closeables.close(in1, threw);
        }
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        Bytes.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (Bytes.read(in, b, off, len) != len) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        while (n > 0L) {
            long amt = in.skip(n);
            if (amt == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            n -= amt;
        }
    }

    public static long getChecksum(IoSupplier<? extends InputStream> supplier, final Checksum checksum) throws IOException {
        return Bytes.process(supplier, new ByteProcessor<Long>(){

            @Override
            public void update(byte[] buf, int off, int len) {
                checksum.update(buf, off, len);
            }

            @Override
            public Long finish() {
                long result = checksum.getValue();
                checksum.reset();
                return result;
            }
        });
    }

    public static byte[] getDigest(IoSupplier<? extends InputStream> supplier, final MessageDigest md) throws IOException {
        return Bytes.process(supplier, new ByteProcessor<byte[]>(){

            @Override
            public void update(byte[] buf, int off, int len) {
                md.update(buf, off, len);
            }

            @Override
            public byte[] finish() {
                return md.digest();
            }
        });
    }

    private static <T> T process(IoSupplier<? extends InputStream> supplier, ByteProcessor<T> processor) throws IOException {
        byte[] buf = new byte[4096];
        boolean threw = true;
        InputStream in = supplier.get();
        try {
            while (true) {
                int amt;
                if ((amt = in.read(buf)) == -1) {
                    threw = false;
                    T t = processor.finish();
                    return t;
                }
                processor.update(buf, 0, amt);
            }
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    @Deprecated
    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    public static IoSupplier<InputStream> slice(final IoSupplier<? extends InputStream> supplier, final long offset, final long length) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkArgument(offset >= 0L, "offset is negative");
        Preconditions.checkArgument(length >= 0L, "length is negative");
        return new IoSupplier<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                InputStream in = (InputStream)supplier.get();
                if (offset > 0L) {
                    try {
                        Bytes.skipFully(in, offset);
                    }
                    catch (IOException e) {
                        Closeables.closeQuietly(in);
                        throw e;
                    }
                }
                return new LimitInputStream(in, length);
            }
        };
    }

    public static IoSupplier<InputStream> join(final Iterable<? extends IoSupplier<? extends InputStream>> suppliers) {
        return new IoSupplier<InputStream>(){

            @Override
            public InputStream get() throws IOException {
                return new MultiInputStream(suppliers.iterator());
            }
        };
    }

    public static IoSupplier<InputStream> join(IoSupplier<? extends InputStream> ... suppliers) {
        return Bytes.join(Arrays.asList(suppliers));
    }

    private static interface ByteProcessor<T> {
        public void update(byte[] var1, int var2, int var3);

        public T finish();
    }
}

