/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base.dynamic;

import com.google.gxp.base.GxpContext;
import com.google.gxp.base.dynamic.GxpCompilationError;
import com.google.gxp.base.dynamic.JavaCompilationError;
import com.google.gxp.base.dynamic.ThrowableError;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.html.HtmlClosure;
import java.io.IOException;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class GxpCompilationException
extends RuntimeException
implements HtmlClosure {
    private final HtmlClosure htmlClosure;

    protected GxpCompilationException(HtmlClosure htmlClosure) {
        this.htmlClosure = Preconditions.checkNotNull(htmlClosure);
    }

    @Override
    public void write(Appendable out, GxpContext gxpContext) throws IOException {
        this.htmlClosure.write(out, gxpContext);
    }

    public static class Throw
    extends GxpCompilationException {
        private final Throwable throwable;

        public Throw(Throwable throwable) {
            super(ThrowableError.getGxpClosure(throwable));
            this.throwable = Preconditions.checkNotNull(throwable);
        }
    }

    public static class Java
    extends GxpCompilationException {
        private final List<Diagnostic<? extends JavaFileObject>> diagnostics;

        public Java(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
            super(JavaCompilationError.getGxpClosure(diagnostics));
            this.diagnostics = Preconditions.checkNotNull(diagnostics);
        }
    }

    public static class Gxp
    extends GxpCompilationException {
        private final AlertPolicy alertPolicy;
        private final AlertSet alertSet;

        public Gxp(AlertPolicy alertPolicy, AlertSet alertSet) {
            super(GxpCompilationError.getGxpClosure(alertPolicy, alertSet));
            this.alertPolicy = Preconditions.checkNotNull(alertPolicy);
            this.alertSet = Preconditions.checkNotNull(alertSet);
        }
    }
}

